/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionAnalysisProvider;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FindDivergedExceptionLineHandler;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.execution.filters.NullPointerExceptionInfo;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public class ExceptionLineParserImpl
implements ExceptionLineParser {
    private final Project myProject;
    private Filter.Result myResult;
    private ExceptionInfoCache.ClassResolveInfo myClassResolveInfo;
    private String myMethod;
    private ExceptionWorker.ParsedLine myInfo;
    private final ExceptionInfoCache myCache;
    private ExceptionLineRefiner myLocationRefiner;

    ExceptionLineParserImpl(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            ExceptionLineParserImpl.$$$reportNull$$$0(0);
        }
        this.myProject = cache.getProject();
        this.myCache = cache;
    }

    public Filter.Result execute(@NotNull String line, int textEndOffset) {
        if (line == null) {
            ExceptionLineParserImpl.$$$reportNull$$$0(1);
        }
        return this.execute(line, textEndOffset, null);
    }

    public Filter.Result execute(@NotNull String line, int textEndOffset, @Nullable ExceptionLineRefiner elementMatcher) {
        if (line == null) {
            ExceptionLineParserImpl.$$$reportNull$$$0(2);
        }
        this.myResult = null;
        this.myInfo = ExceptionWorker.parseExceptionLine((String)line);
        if (this.myInfo == null || this.myProject.isDisposed()) {
            return null;
        }
        this.myMethod = this.myInfo.methodNameRange.substring(line);
        String className = this.myInfo.classFqnRange.substring(line).trim();
        this.myClassResolveInfo = this.myCache.resolveClassOrFile(className, this.myInfo.fileName);
        if (this.myClassResolveInfo.getClasses().isEmpty()) {
            return null;
        }
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + this.myInfo.fileLineRange.getStartOffset();
        int highlightEndOffset = textStartOffset + this.myInfo.fileLineRange.getEndOffset();
        ArrayList virtualFiles = new ArrayList(this.myClassResolveInfo.getClasses().keySet());
        ExceptionFinder action = elementMatcher == null || this.myInfo.lineNumber <= 0 ? null : new ExceptionFinder(elementMatcher, this.myInfo.lineNumber - 1, textEndOffset, this.myMethod, className);
        HyperlinkInfo linkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(virtualFiles, this.myInfo.lineNumber - 1, this.myProject, (HyperlinkInfoFactory.HyperlinkHandler)action);
        Filter.Result result = new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, this.myClassResolveInfo.isInLibrary());
        this.myLocationRefiner = this.myMethod.startsWith("access$") ? elementMatcher : (elementMatcher instanceof FunctionCallMatcher && className.matches(".+\\$\\$Lambda\\$\\d+/0x[0-9a-f]+") ? new FunctionCallMatcher(this.myMethod) : (this.myMethod.startsWith("lambda$") ? new FunctionCallMatcher(null) : new StackFrameMatcher(line, this.myInfo)));
        this.myResult = result;
        return result;
    }

    public ExceptionLineRefiner getLocationRefiner() {
        return this.myLocationRefiner;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExceptionLineParserImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    public Filter.Result getResult() {
        return this.myResult;
    }

    @Nullable
    public UClass getUClass() {
        ExceptionInfoCache.ClassResolveInfo info = this.myClassResolveInfo;
        if (info == null) {
            return null;
        }
        return (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)ContainerUtil.getFirstItem(info.getClasses().values())), UClass.class);
    }

    public String getMethod() {
        return this.myMethod;
    }

    public PsiFile getFile() {
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(this.myClassResolveInfo.getClasses().values());
        return element == null ? null : element.getContainingFile();
    }

    public ExceptionWorker.ParsedLine getInfo() {
        return this.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionLineParserImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionLineParserImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static final class ExceptionFinder
    implements HyperlinkInfoFactory.HyperlinkHandler {
        private final ExceptionLineRefiner myElementMatcher;
        private final int myLineNumber;
        private final int myTextEndOffset;
        private boolean myAnalysisWasActivated;
        private final String myMethod;
        private final String myClassName;

        private ExceptionFinder(@NotNull ExceptionLineRefiner elementMatcher, int lineNumber, int textEndOffset, @Nullable String method, @Nullable String className) {
            if (elementMatcher == null) {
                ExceptionFinder.$$$reportNull$$$0(0);
            }
            this.myElementMatcher = elementMatcher;
            this.myLineNumber = lineNumber;
            this.myTextEndOffset = textEndOffset;
            this.myMethod = method;
            this.myClassName = className;
        }

        public void onLinkFollowed(@NotNull Project project, @NotNull VirtualFile file, @NotNull Editor targetEditor, @Nullable Editor originalEditor) {
            if (project == null) {
                ExceptionFinder.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ExceptionFinder.$$$reportNull$$$0(2);
            }
            if (targetEditor == null) {
                ExceptionFinder.$$$reportNull$$$0(3);
            }
            if (DumbService.isDumb((Project)project)) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null || document.getLineCount() <= this.myLineNumber) {
                return;
            }
            if (!PsiDocumentManager.getInstance((Project)project).isCommitted(document)) {
                return;
            }
            int startOffset = document.getLineStartOffset(this.myLineNumber);
            int endOffset = document.getLineEndOffset(this.myLineNumber);
            long stamp = document.getModificationStamp();
            ReadAction.nonBlocking(() -> this.computeLinkInfo(project, file, startOffset, endOffset, targetEditor, originalEditor)).expireWhen(() -> project.isDisposed() || targetEditor.isDisposed() || document.getModificationStamp() != stamp).finishOnUiThread(ModalityState.nonModal(), info -> {
                if (info == null) {
                    return;
                }
                if (info.myTarget != null) {
                    TextRange range = info.myTarget.getTextRange();
                    targetEditor.getCaretModel().moveToOffset(range.getStartOffset());
                }
                if (info.myAction != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                    this.displayAnalysisAction(project, (LinkInfo)info, targetEditor);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        @Nullable
        private LinkInfo computeLinkInfo(@NotNull Project project, @NotNull VirtualFile file, int lineStart, int lineEnd, @Nullable Editor targetEditor, @Nullable Editor originalEditor) {
            PsiFile psiFile;
            if (project == null) {
                ExceptionFinder.$$$reportNull$$$0(4);
            }
            if (file == null) {
                ExceptionFinder.$$$reportNull$$$0(5);
            }
            if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
                return null;
            }
            Set<ExceptionLineRefiner.RefinerMatchResult> matchResults = this.getExceptionOrigin(psiFile, lineStart, lineEnd);
            if (matchResults.isEmpty()) {
                return FindDivergedExceptionLineHandler.createLinkInfo(psiFile, this.myClassName, this.myMethod, this.myElementMatcher, lineStart, lineEnd, targetEditor);
            }
            if (matchResults.size() == 1) {
                ExceptionLineRefiner.RefinerMatchResult matchResult = matchResults.iterator().next();
                AnAction action = this.findAnalysisAction(project, matchResult.reason(), originalEditor);
                return new LinkInfo(psiFile, matchResult.target(), matchResult.reason(), action, finder -> {
                    finder.myAnalysisWasActivated = true;
                });
            }
            return null;
        }

        @NotNull
        private Set<ExceptionLineRefiner.RefinerMatchResult> getExceptionOrigin(@NotNull PsiFile file, int lineStart, int lineEnd) {
            if (file == null) {
                ExceptionFinder.$$$reportNull$$$0(6);
            }
            if (!file.isValid()) {
                Set<ExceptionLineRefiner.RefinerMatchResult> set = Set.of();
                if (set == null) {
                    ExceptionFinder.$$$reportNull$$$0(7);
                }
                return set;
            }
            PsiElement element = file.findElementAt(lineStart);
            HashSet<ExceptionLineRefiner.RefinerMatchResult> candidates = new HashSet<ExceptionLineRefiner.RefinerMatchResult>();
            while (element != null && element.getTextRange().getStartOffset() < lineEnd) {
                PsiElement finalElement = element;
                ExceptionLineRefiner.RefinerMatchResult matched = this.myElementMatcher.matchElement(finalElement);
                if (matched != null) {
                    candidates.add(matched);
                    if (candidates.size() > 1) {
                        HashSet<ExceptionLineRefiner.RefinerMatchResult> hashSet = candidates;
                        if (hashSet == null) {
                            ExceptionFinder.$$$reportNull$$$0(8);
                        }
                        return hashSet;
                    }
                }
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
            }
            HashSet<ExceptionLineRefiner.RefinerMatchResult> hashSet = candidates;
            if (hashSet == null) {
                ExceptionFinder.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        private void displayAnalysisAction(final @NotNull Project project, final @NotNull LinkInfo linkInfo, @NotNull Editor editor) {
            AnAction action;
            if (project == null) {
                ExceptionFinder.$$$reportNull$$$0(10);
            }
            if (linkInfo == null) {
                ExceptionFinder.$$$reportNull$$$0(11);
            }
            if (editor == null) {
                ExceptionFinder.$$$reportNull$$$0(12);
            }
            if ((action = linkInfo.myAction) == null) {
                return;
            }
            String actionName = action.getTemplatePresentation().getDescription();
            Objects.requireNonNull(actionName);
            final Ref ref = Ref.create();
            String content = HtmlChunk.link((String)"analyze", (String)actionName).toString();
            Color background = MessageType.INFO.getPopupBackground();
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(content, null, background, (HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e.getDescription().equals("analyze")) {
                        Balloon b = (Balloon)ref.get();
                        if (b != null) {
                            Disposer.dispose((Disposable)b);
                        }
                        linkInfo.prepare.accept(this);
                        PsiFile file = linkInfo.myPsiFile;
                        ActionsCollector.getInstance().record(project, action, null, file.getLanguage());
                        ActionUtil.performAction((AnAction)action, (AnActionEvent)AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)DataContext.EMPTY_CONTEXT));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/filters/ExceptionLineParserImpl$ExceptionFinder$1", "hyperlinkActivated"));
                }
            }).createBalloon();
            EditorUtil.disposeWithEditor((Editor)editor, (Disposable)balloon);
            ref.set((Object)balloon);
            RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            PsiElement psiElement = linkInfo.myReason;
            if (psiElement instanceof Navigatable) {
                Navigatable navigatable = (Navigatable)psiElement;
                int previousOffset = editor.getCaretModel().getOffset();
                navigatable.navigate(true);
                point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
                editor.getCaretModel().moveToOffset(previousOffset);
            }
            if (ExceptionFinder.getLine(editor, linkInfo.myReason) < ExceptionFinder.getLine(editor, linkInfo.myTarget)) {
                Point previousPoint = point.getPoint();
                balloon.show(new RelativePoint(point.getComponent(), new Point(previousPoint.x, previousPoint.y - editor.getLineHeight())), Balloon.Position.above);
            } else {
                balloon.show(point, Balloon.Position.below);
            }
            editor.getScrollingModel().addVisibleAreaListener(e -> {
                if (e.getNewRectangle().equals(e.getOldRectangle())) {
                    return;
                }
                Disposer.dispose((Disposable)balloon);
            }, (Disposable)balloon);
        }

        private static long getLine(@NotNull Editor editor, @Nullable PsiElement psiElement) {
            if (editor == null) {
                ExceptionFinder.$$$reportNull$$$0(13);
            }
            if (psiElement == null) {
                return -1L;
            }
            Document document = editor.getDocument();
            TextRange range = psiElement.getTextRange();
            if (range == null) {
                return -1L;
            }
            return document.getLineNumber(range.getStartOffset());
        }

        @Nullable
        private AnAction findAnalysisAction(@NotNull Project project, @NotNull PsiElement element, @Nullable Editor originalEditor) {
            Supplier<List> supplier;
            if (project == null) {
                ExceptionFinder.$$$reportNull$$$0(14);
            }
            if (element == null) {
                ExceptionFinder.$$$reportNull$$$0(15);
            }
            if (this.myAnalysisWasActivated) {
                return null;
            }
            if (originalEditor != null) {
                Document origDocument = originalEditor.getDocument();
                supplier = () -> {
                    String traceLine;
                    ExceptionWorker.ParsedLine line;
                    int stackLineNumber = origDocument.getLineNumber(this.myTextEndOffset);
                    if (stackLineNumber < 1) {
                        return Collections.emptyList();
                    }
                    int lineCount = Math.min(origDocument.getLineCount(), stackLineNumber + 100);
                    ArrayList<ExceptionAnalysisProvider.StackLine> nextLines = new ArrayList<ExceptionAnalysisProvider.StackLine>();
                    for (int i = stackLineNumber - 1; i < lineCount && (line = ExceptionWorker.parseExceptionLine((String)(traceLine = origDocument.getText(TextRange.create((int)origDocument.getLineStartOffset(i), (int)origDocument.getLineEndOffset(i)))))) != null; ++i) {
                        String methodName = line.methodNameRange.substring(traceLine);
                        if (methodName.startsWith("access$")) continue;
                        ExceptionAnalysisProvider.StackLine stackLine = new ExceptionAnalysisProvider.StackLine(line.classFqnRange.substring(traceLine), methodName, line.fileName);
                        nextLines.add(stackLine);
                    }
                    return nextLines;
                };
            } else {
                supplier = Collections::emptyList;
            }
            ExceptionInfo info = this.myElementMatcher.getExceptionInfo();
            ExceptionAnalysisProvider exceptionAnalysisProvider = (ExceptionAnalysisProvider)project.getService(ExceptionAnalysisProvider.class);
            AnAction action = info == null ? exceptionAnalysisProvider.getIntermediateRowAnalysisAction(element, supplier) : exceptionAnalysisProvider.getAnalysisAction(element, info, supplier);
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementMatcher";
                    break;
                }
                case 1: 
                case 4: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEditor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/ExceptionLineParserImpl$ExceptionFinder";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkInfo";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/ExceptionLineParserImpl$ExceptionFinder";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExceptionOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onLinkFollowed";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "computeLinkInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getExceptionOrigin";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "displayAnalysisAction";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getLine";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "findAnalysisAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class FunctionCallMatcher
    implements ExceptionLineRefiner {
        @Nullable
        private final String myMethodName;

        private FunctionCallMatcher(@Nullable String name) {
            this.myMethodName = name;
        }

        public ExceptionLineRefiner.RefinerMatchResult matchElement(@NotNull PsiElement element) {
            if (element == null) {
                FunctionCallMatcher.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiIdentifier)) {
                return null;
            }
            if (this.myMethodName != null && !element.textMatches((CharSequence)this.myMethodName)) {
                return null;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            PsiMethod target = call.resolveMethod();
            if (target == null) {
                return null;
            }
            if (LambdaUtil.getFunctionalInterfaceMethod((PsiClass)target.getContainingClass()) != target) {
                return null;
            }
            return ExceptionLineRefiner.RefinerMatchResult.of((PsiElement)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/filters/ExceptionLineParserImpl$FunctionCallMatcher", "matchElement"));
        }
    }

    private static final class StackFrameMatcher
    implements ExceptionLineRefiner {
        private static final ClassMethod METHOD_HANDLE_AS_TYPE = new ClassMethod("java.lang.invoke.MethodHandle", "asType");
        private static final ClassMethod VAR_HANDLE_METHOD_HANDLE = new ClassMethod("java.lang.invoke.VarHandle", "getMethodHandle");
        private static final ClassMethod INVOKERS_CHECK_GENERIC_TYPE = new ClassMethod("java.lang.invoke.Invokers", "checkGenericType");
        private static final ClassMethod INVOKERS_CHECK_EXACT_TYPE = new ClassMethod("java.lang.invoke.Invokers", "checkExactType");
        private static final ClassSetMethods VAR_HANDLES = new ClassSetMethods("java.lang.invoke.VarHandle", Set.of("get", "set", "getVolatile", "setVolatile", "setOpaque", "getOpaque", "getAcquire", "setAcquire", "setRelease", "compareAndSet", "compareAndExchange", "compareAndExchangeAcquire", "compareAndExchangeRelease", "weakCompareAndSetPlain", "weakCompareAndSet", "weakCompareAndSetAcquire", "weakCompareAndSetRelease", "getAndSet", "getAndSetAcquire", "getAndSetRelease", "getAndAdd", "getAndAddAcquire", "getAndAddRelease", "getAndBitwiseOr", "getAndBitwiseOrAcquire", "getAndBitwiseOrRelease", "getAndBitwiseAnd", "getAndBitwiseAndAcquire", "getAndBitwiseAndRelease", "getAndBitwiseXor", "getAndBitwiseXorAcquire", "getAndBitwiseXorRelease"));
        private static final ClassSetMethods METHOD_HANDLES = new ClassSetMethods("java.lang.invoke.MethodHandle", Set.of("invokeExact", "invoke"));
        private static final Map<ClassMethod, ClassSetMethods> MAPPED_METHODS = Map.of(METHOD_HANDLE_AS_TYPE, VAR_HANDLES, VAR_HANDLE_METHOD_HANDLE, VAR_HANDLES, INVOKERS_CHECK_GENERIC_TYPE, METHOD_HANDLES, INVOKERS_CHECK_EXACT_TYPE, METHOD_HANDLES);
        @NonNls
        private final Set<String> myMethodNames;
        @NonNls
        private final String myClassName;
        private final boolean myHasDollarInName;
        private final StackFrameMatcher myAdditionalMatcher;

        private StackFrameMatcher(@NotNull String line, @NotNull ExceptionWorker.ParsedLine info) {
            if (line == null) {
                StackFrameMatcher.$$$reportNull$$$0(0);
            }
            if (info == null) {
                StackFrameMatcher.$$$reportNull$$$0(1);
            }
            this.myClassName = info.classFqnRange.substring(line);
            this.myMethodNames = Set.of(info.methodNameRange.substring(line));
            this.myHasDollarInName = StringUtil.getShortName((String)this.myClassName).contains("$");
            ClassSetMethods mappedMethods = MAPPED_METHODS.get(new ClassMethod(this.myClassName, info.methodNameRange.substring(line)));
            this.myAdditionalMatcher = mappedMethods != null ? new StackFrameMatcher(mappedMethods.className(), mappedMethods.methodName()) : null;
        }

        private StackFrameMatcher(String className, Set<String> methodNames) {
            this.myClassName = className;
            this.myMethodNames = methodNames;
            this.myHasDollarInName = StringUtil.getShortName((String)this.myClassName).contains("$");
            this.myAdditionalMatcher = null;
        }

        public ExceptionLineRefiner.RefinerMatchResult matchElement(@NotNull PsiElement element) {
            PsiElement parent;
            ExceptionLineRefiner.RefinerMatchResult result;
            if (element == null) {
                StackFrameMatcher.$$$reportNull$$$0(2);
            }
            ExceptionLineRefiner.RefinerMatchResult refinerMatchResult = result = this.myAdditionalMatcher == null ? null : this.myAdditionalMatcher.matchElement(element);
            if (result != null) {
                return result;
            }
            if (this.myMethodNames.contains("requireNonNull") && this.myClassName.equals("java.util.Objects") && (result = NullPointerExceptionInfo.matchCompilerGeneratedNullCheck((PsiElement)element)) != null) {
                return result;
            }
            if (!(element instanceof PsiIdentifier)) {
                return null;
            }
            if (this.myMethodNames.contains("<init>")) {
                if (this.myHasDollarInName || element.textMatches((CharSequence)StringUtil.getShortName((String)this.myClassName))) {
                    PsiElement parent2 = element.getParent();
                    while (parent2 instanceof PsiJavaCodeReferenceElement) {
                        parent2 = parent2.getParent();
                    }
                    if (parent2 instanceof PsiAnonymousClass) {
                        return this.isTargetClass(parent2) || this.isTargetClass((PsiElement)((PsiAnonymousClass)parent2).getSuperClass()) ? ExceptionLineRefiner.RefinerMatchResult.of((PsiElement)element) : null;
                    }
                    if (parent2 instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement ref = ((PsiNewExpression)parent2).getClassOrAnonymousClassReference();
                        return ref != null && this.isTargetClass(ref.resolve()) ? ExceptionLineRefiner.RefinerMatchResult.of((PsiElement)element) : null;
                    }
                }
            } else if ((this.myMethodNames.size() == 1 && element.textMatches((CharSequence)this.myMethodNames.iterator().next()) || this.myMethodNames.contains(element.getText())) && (parent = element.getParent()) instanceof PsiReferenceExpression) {
                PsiElement target = ((PsiReferenceExpression)parent).resolve();
                return target instanceof PsiMethod && this.isTargetClass((PsiElement)((PsiMethod)target).getContainingClass()) ? ExceptionLineRefiner.RefinerMatchResult.of((PsiElement)element) : null;
            }
            return null;
        }

        private boolean isTargetClass(PsiElement maybeClass) {
            if (!(maybeClass instanceof PsiClass)) {
                return false;
            }
            PsiClass declaredClass = (PsiClass)maybeClass;
            if (this.myClassName.startsWith("com.sun.proxy.$Proxy")) {
                return true;
            }
            String declaredName = declaredClass.getQualifiedName();
            if (this.myClassName.equals(declaredName)) {
                return true;
            }
            PsiClass calledClass = ClassUtil.findPsiClass((PsiManager)maybeClass.getManager(), (String)this.myClassName, (PsiClass)declaredClass, (boolean)true);
            if (calledClass == null) {
                calledClass = ClassUtil.findPsiClass((PsiManager)maybeClass.getManager(), (String)this.myClassName, null, (boolean)true);
            }
            return calledClass == declaredClass || declaredName != null && InheritanceUtil.isInheritor((PsiClass)calledClass, (boolean)false, (String)declaredName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionLineParserImpl$StackFrameMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private record ClassMethod(String className, String methodName) {
        }

        private record ClassSetMethods(String className, Set<String> methodName) {
        }
    }

    static class LinkInfo {
        @NotNull
        final PsiFile myPsiFile;
        @Nullable
        final PsiElement myTarget;
        @Nullable
        final PsiElement myReason;
        @Nullable
        final AnAction myAction;
        @NotNull
        final Consumer<ExceptionFinder> prepare;

        LinkInfo(@NotNull PsiFile file, @Nullable PsiElement target, @Nullable PsiElement reason, @Nullable AnAction action, @NotNull Consumer<ExceptionFinder> callback) {
            if (file == null) {
                LinkInfo.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                LinkInfo.$$$reportNull$$$0(1);
            }
            this.myPsiFile = file;
            this.myTarget = target;
            this.myReason = reason;
            this.myAction = action;
            this.prepare = callback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/filters/ExceptionLineParserImpl$LinkInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

