/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.StackTraceFoldingKt;
import com.intellij.execution.filters.StackTraceFoldingSettings;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.NoStackTraceFoldingPanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/execution/filters/StackTraceFolding;", "Lcom/intellij/execution/ConsoleFolding;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "countToFold", "", "getCountToFold", "()I", "frameCount", "shouldFoldLine", "project", "Lcom/intellij/openapi/project/Project;", "line", "", "getPlaceholderText", "lines", "", "shouldBeAttachedToThePreviousLine", "isEnabledForConsole", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nStackTraceFolding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceFolding.kt\ncom/intellij/execution/filters/StackTraceFolding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,56:1\n1807#2,3:57\n69#3:60\n*S KotlinDebug\n*F\n+ 1 StackTraceFolding.kt\ncom/intellij/execution/filters/StackTraceFolding\n*L\n41#1:57,3\n54#1:60\n*E\n"})
public final class StackTraceFolding
extends ConsoleFolding {
    private int frameCount;

    private final boolean getEnabled() {
        return StackTraceFoldingSettings.Companion.getInstance().getFoldJavaStackTrace();
    }

    private final int getCountToFold() {
        return StackTraceFoldingSettings.Companion.getInstance().getFoldJavaStackTraceGreaterThan();
    }

    public boolean shouldFoldLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.startsWith$default((String)line, (String)"\tat ", (boolean)false, (int)2, null) || StackTraceFoldingKt.access$getENCLOSED_MORE_REGEX$p().matches((CharSequence)line)) {
            int n = this.frameCount;
            this.frameCount = n + 1;
            return this.frameCount > this.getCountToFold();
        }
        this.frameCount = 0;
        return false;
    }

    @Nullable
    public String getPlaceholderText(@NotNull Project project, @NotNull List<String> lines) {
        String string;
        boolean hasAsync;
        int count;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            count = lines.size();
            Iterable $this$any$iv = lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"\tat --- Async.Stack.Trace --- ", (boolean)false, (int)2, null)) continue;
                    v0 = true;
                    break block5;
                }
                v0 = hasAsync = false;
            }
        }
        if (hasAsync) {
            var7_7 = new Object[]{count};
            string = ExecutionBundle.message((String)"java.stack.trace.folded.frames.including.async", (Object[])var7_7);
        } else {
            var7_7 = new Object[]{count};
            string = ExecutionBundle.message((String)"java.stack.trace.folded.frames", (Object[])var7_7);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String msg = string2;
        return "\t" + msg;
    }

    public boolean shouldBeAttachedToThePreviousLine() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabledForConsole(@NotNull ConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        if (!super.isEnabledForConsole(consoleView)) return false;
        if (!this.getEnabled()) return false;
        JComponent jComponent = consoleView.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        Component $this$getParentOfType$iv = jComponent;
        boolean $i$f$getParentOfType = false;
        if (ComponentUtil.getParentOfType(NoStackTraceFoldingPanel.class, (Component)$this$getParentOfType$iv) != null) return false;
        return true;
    }
}

