/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ThreadDumpProvider;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

class JstackThreadDumpProvider
extends ThreadDumpProvider {
    JstackThreadDumpProvider() {
    }

    @Override
    protected String dumpThreads(String pid) {
        String jstack;
        Path javaPath;
        Path jstackPath;
        String commandLine;
        ProcessHandle handle = ProcessHandle.of(Long.parseLong(pid)).orElse(null);
        if (handle != null && (commandLine = (String)handle.info().command().orElse(null)) != null && Files.isExecutable(jstackPath = (javaPath = Paths.get(commandLine, new String[0])).resolveSibling(jstack = "jstack" + (SystemInfo.isWindows ? ".exe" : "")))) {
            try {
                GeneralCommandLine command = new GeneralCommandLine(new String[]{jstackPath.toAbsolutePath().toString(), pid});
                ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command);
                if (output.getExitCode() == 0) {
                    return output.getStdout();
                }
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }
}

