/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/jar/JarApplicationRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "<init>", "()V", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "canImport", "", "typeName", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "intellij.java.execution.impl"})
public final class JarApplicationRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, Object> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof JarApplicationConfiguration)) {
            throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfiguration.getClass());
        }
        ObjectUtils.consumeIfCast((Object)cfg.get("moduleName"), String.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$1(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$0(modelsProvider, runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("jarPath"), String.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$3(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$2(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("jvmArgs"), String.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$5(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$4(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("programParameters"), String.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$7(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$6(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("workingDirectory"), String.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$9(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$8(runConfiguration, arg_0), arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("envs"), Map.class, arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$11(arg_0 -> JarApplicationRunConfigurationImporter.process$lambda$10(runConfiguration, arg_0), arg_0));
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)typeName, (Object)"jarApplication");
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((JarApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(JarApplicationConfigurationType.class)).getConfigurationFactories()[0];
    }

    private static final Unit process$lambda$0(IdeModifiableModelsProvider $modelsProvider, RunConfiguration $runConfiguration, String it) {
        Module module = $modelsProvider.getModifiableModuleModel().findModuleByName(it);
        if (module != null) {
            ((JarApplicationConfiguration)$runConfiguration).setModule(module);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$2(RunConfiguration $runConfiguration, String it) {
        ((JarApplicationConfiguration)$runConfiguration).setJarPath(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$4(RunConfiguration $runConfiguration, String it) {
        ((JarApplicationConfiguration)$runConfiguration).setVMParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$6(RunConfiguration $runConfiguration, String it) {
        ((JarApplicationConfiguration)$runConfiguration).setProgramParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$8(RunConfiguration $runConfiguration, String it) {
        ((JarApplicationConfiguration)$runConfiguration).setWorkingDirectory(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$10(RunConfiguration $runConfiguration, Map it) {
        JarApplicationConfiguration jarApplicationConfiguration = (JarApplicationConfiguration)$runConfiguration;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        jarApplicationConfiguration.setEnvs(TypeIntrinsics.asMutableMap((Object)it));
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

