/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ClassUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedClassLocation
extends Location<PsiClass> {
    private static final Logger LOG = Logger.getInstance(NestedClassLocation.class);
    private final Project myProject;
    private final PsiClass myNestedClass;
    private final Location<? extends PsiClass> myClassLocation;

    public NestedClassLocation(@NotNull Project project, @NotNull PsiClass nestedClass, @NotNull Location<? extends PsiClass> classLocation) {
        if (project == null) {
            NestedClassLocation.$$$reportNull$$$0(0);
        }
        if (nestedClass == null) {
            NestedClassLocation.$$$reportNull$$$0(1);
        }
        if (classLocation == null) {
            NestedClassLocation.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myNestedClass = nestedClass;
        this.myClassLocation = classLocation;
    }

    public String getNestedInConcreteInheritor() {
        return ClassUtil.getJVMClassName((PsiClass)((PsiClass)this.myClassLocation.getPsiElement())) + "$" + this.myNestedClass.getName();
    }

    public static NestedClassLocation elementInClass(PsiClass psiElement, PsiClass psiClass) {
        Location classLocation = PsiLocation.fromPsiElement((PsiElement)psiClass);
        return new NestedClassLocation(classLocation.getProject(), psiElement, (Location<? extends PsiClass>)classLocation);
    }

    @NotNull
    public PsiClass getPsiElement() {
        PsiClass psiClass = this.myNestedClass;
        if (psiClass == null) {
            NestedClassLocation.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NestedClassLocation.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return this.myClassLocation.getModule();
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.myClassLocation.getPsiElement();
    }

    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(final Class<T> ancestorClass, boolean strict) {
        final Iterator fromClass = this.myClassLocation.getAncestors(ancestorClass, false);
        if (strict) {
            Iterator iterator = fromClass;
            if (iterator == null) {
                NestedClassLocation.$$$reportNull$$$0(5);
            }
            return iterator;
        }
        return new Iterator<Location<T>>(){
            private boolean myFirstStep;
            {
                this.myFirstStep = ancestorClass.isInstance(NestedClassLocation.this.myNestedClass);
            }

            @Override
            public boolean hasNext() {
                return this.myFirstStep || fromClass.hasNext();
            }

            @Override
            public Location<T> next() {
                NestedClassLocation location = this.myFirstStep ? NestedClassLocation.this : (Location)fromClass.next();
                this.myFirstStep = false;
                return location;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLocation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/info/NestedClassLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/info/NestedClassLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

