/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProcessProxyImpl;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.application.AppMainV2;
import com.intellij.util.PathsList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class ProcessProxyFactoryImpl
extends ProcessProxyFactory {
    private static final boolean ourMayUseLauncher = !Boolean.getBoolean("idea.no.launcher");

    public ProcessProxy createCommandLineProxy(JavaCommandLine javaCmdLine) throws ExecutionException {
        JavaParameters javaParameters = javaCmdLine.getJavaParameters();
        String mainClass = javaParameters.getMainClass();
        if (ourMayUseLauncher && mainClass != null) {
            boolean runtimeJarFile;
            Path rtJarPath = Path.of(JavaSdkUtil.getIdeaRtJarPath(), new String[0]);
            boolean bl = runtimeJarFile = Files.isRegularFile(rtJarPath, new LinkOption[0]) && rtJarPath.startsWith(PathManager.getHomePath());
            if (runtimeJarFile || javaParameters.getModuleName() == null) {
                try {
                    ProcessProxyImpl proxy = new ProcessProxyImpl(StringUtil.getShortName((String)mainClass));
                    String port = String.valueOf(proxy.getPortNumber());
                    JavaSdkVersion jdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)javaParameters.getJdk());
                    if (jdkVersion != null && !jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
                        throw new ExecutionException(JavaBundle.message((String)"error.message.ide.does.not.support.starting.processes.using.old.java.app", (Object[])new Object[]{jdkVersion.getDescription()}));
                    }
                    if (runtimeJarFile) {
                        javaParameters.getVMParametersList().add("-javaagent:" + String.valueOf(rtJarPath) + "=" + port);
                    } else {
                        boolean isJava21preview;
                        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
                        ParametersList vmParametersList = javaParameters.getVMParametersList();
                        vmParametersList.defineProperty("idea.launcher.port", port);
                        boolean bl2 = isJava21preview = JavaSdkVersion.JDK_21.equals((Object)jdkVersion) && javaParameters.getVMParametersList().getParameters().contains("--enable-preview");
                        if (isJava21preview) {
                            vmParametersList.defineProperty("idea.launcher.use.21.preview", Boolean.toString(isJava21preview));
                        }
                        javaParameters.getProgramParametersList().prepend(mainClass);
                        javaParameters.setMainClass(AppMainV2.class.getName());
                    }
                    return proxy;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(ProcessProxy.class).warn((Throwable)e);
                }
            }
        }
        return null;
    }

    public ProcessProxy getAttachedProxy(ProcessHandler processHandler) {
        return (ProcessProxy)ProcessProxyImpl.KEY.get((UserDataHolder)processHandler);
    }
}

