/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeaTestDiscoveryProtocolReader
implements TestDiscoveryProtocolReader,
TestDiscoveryProtocolReader.NameEnumeratorReader {
    private static final Logger LOG = Logger.getInstance(IdeaTestDiscoveryProtocolReader.class);
    @NotNull
    private final Int2ObjectMap<String> myTestExecutionNameEnumerator;
    @NotNull
    private final TestDiscoveryIndex myIndex;
    private final String myModuleName;
    private final byte myFrameworkId;

    IdeaTestDiscoveryProtocolReader(@NotNull TestDiscoveryIndex index, @Nullable String moduleName, byte frameworkId) {
        if (index == null) {
            IdeaTestDiscoveryProtocolReader.$$$reportNull$$$0(0);
        }
        this.myTestExecutionNameEnumerator = new Int2ObjectOpenHashMap();
        this.myIndex = index;
        this.myModuleName = moduleName;
        this.myFrameworkId = frameworkId;
    }

    public void testDiscoveryDataProcessingStarted(int version) {
    }

    public void testDiscoveryDataProcessingFinished() {
    }

    public TestDiscoveryProtocolReader.MetadataReader createMetadataReader() {
        return new TestDiscoveryProtocolReader.MetadataReader(this){

            public void processMetadataEntry(String k, String v) {
            }
        };
    }

    public TestDiscoveryProtocolReader.ClassMetadataReader createClassMetadataReader() {
        return new TestDiscoveryProtocolReader.ClassMetadataReader(this){

            public void classStarted(int i) {
            }

            public void file(int i) {
            }

            public void method(int i, byte[] bytes) {
            }

            public void classFinished(int i) {
            }

            public void finished() {
            }
        };
    }

    public TestDiscoveryProtocolReader.NameEnumeratorReader createNameEnumeratorReader() {
        return this;
    }

    public TestDiscoveryProtocolReader.TestDataReader createTestDataReader(final int testClassId, final int testMethodId) {
        return new TestDiscoveryProtocolReader.TestDataReader(){
            private final String myTestClassName;
            private final String myTestMethodName;
            private final MultiMap<String, String> myUsedMethods;
            private final List<String> myUsedFiles;
            private int myCurrentClassId;
            {
                this.myTestClassName = (String)IdeaTestDiscoveryProtocolReader.this.myTestExecutionNameEnumerator.get(testClassId);
                this.myTestMethodName = (String)IdeaTestDiscoveryProtocolReader.this.myTestExecutionNameEnumerator.get(testMethodId);
                this.myUsedMethods = new MultiMap();
                this.myUsedFiles = new SmartList();
            }

            public void classProcessingStarted(int classId) {
                this.myCurrentClassId = classId;
            }

            public void processUsedMethod(int methodId) {
                String className = (String)IdeaTestDiscoveryProtocolReader.this.myTestExecutionNameEnumerator.get(this.myCurrentClassId);
                String methodName = (String)IdeaTestDiscoveryProtocolReader.this.myTestExecutionNameEnumerator.get(methodId);
                if (className == null || methodName == null) {
                    LOG.error("Inconsistent state");
                    return;
                }
                this.myUsedMethods.putValue((Object)className, (Object)methodName);
            }

            public void classProcessingFinished(int classId) {
                this.myCurrentClassId = -1;
            }

            public void testDataProcessed() {
                IdeaTestDiscoveryProtocolReader.this.myIndex.updateTestData(this.myTestClassName, this.myTestMethodName, this.myUsedMethods, this.myUsedFiles, IdeaTestDiscoveryProtocolReader.this.myModuleName, IdeaTestDiscoveryProtocolReader.this.myFrameworkId);
            }

            public void processAffectedFile(int[] ints) {
                this.myUsedFiles.add(Arrays.stream(ints).mapToObj(id1 -> (String)IdeaTestDiscoveryProtocolReader.this.myTestExecutionNameEnumerator.get(id1)).collect(Collectors.joining(File.separator)));
            }
        };
    }

    public void debug(String message) {
        LOG.debug(message);
    }

    public void error(String message) {
        LOG.error(message);
    }

    public void error(Exception exception) {
        LOG.error((Throwable)exception);
    }

    public void enumerate(String name, int id) {
        String previousName = (String)this.myTestExecutionNameEnumerator.put(id, (Object)name);
        LOG.assertTrue(previousName == null || previousName.equals(name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/execution/testDiscovery/IdeaTestDiscoveryProtocolReader", "<init>"));
    }
}

