/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testDiscovery.IdeaTestDiscoveryProtocolReader;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolUtil;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TestDiscoveryDataSocketListener {
    private static final Logger LOG = Logger.getInstance(TestDiscoveryDataSocketListener.class);
    @Nullable
    private final String myModuleName;
    private final byte myFrameworkId;
    private volatile boolean myClosed;
    private volatile boolean myFinished;
    private final ServerSocket myServer;
    private final int myPort;
    private final TestDiscoveryIndex myTestDiscoveryIndex;

    public TestDiscoveryDataSocketListener(@NotNull Project project, @Nullable String moduleName, byte frameworkPrefix) throws IOException {
        if (project == null) {
            TestDiscoveryDataSocketListener.$$$reportNull$$$0(0);
        }
        this.myTestDiscoveryIndex = TestDiscoveryIndex.getInstance(project);
        this.myModuleName = moduleName;
        this.myFrameworkId = frameworkPrefix;
        this.myServer = new ServerSocket(0);
        this.myPort = this.myServer.getLocalPort();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myClosed) {
                return;
            }
            Socket socket = null;
            try {
                socket = this.myServer.accept();
                socket.setReceiveBufferSize(0x100000);
                socket.setTcpNoDelay(true);
                InputStream testDataStream = socket.getInputStream();
                IdeaTestDiscoveryProtocolReader protocolReader = new IdeaTestDiscoveryProtocolReader(this.myTestDiscoveryIndex, this.myModuleName, this.myFrameworkId);
                TestDiscoveryProtocolUtil.readSequentially((InputStream)testDataStream, (TestDiscoveryProtocolReader)protocolReader);
                this.myFinished = true;
            }
            catch (IOException e) {
                if (!this.myClosed) {
                    LOG.error((Throwable)e);
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public int getPort() {
        return this.myPort;
    }

    void attach(ProcessHandler handler) {
        handler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestDiscoveryDataSocketListener.this.myClosed = true;
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                TestDiscoveryDataSocketListener.this.myClosed = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryDataSocketListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @TestOnly
    public void awaitTermination() {
        while (!this.myFinished) {
            TimeoutUtil.sleep((long)100L);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testDiscovery/TestDiscoveryDataSocketListener", "<init>"));
    }
}

