/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.TestDiscoveryListener;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testDiscovery.IdeaTestDiscoveryProtocolReader;
import com.intellij.execution.testDiscovery.TestDiscoveryDataSocketListener;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.coverage.data.SingleTrFileDiscoveryProtocolDataListener;
import com.intellij.rt.coverage.data.SocketTestDiscoveryProtocolDataListener;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestDiscoveryExtension
extends RunConfigurationExtension {
    public static final String TEST_DISCOVERY_REGISTRY_KEY = "testDiscovery.enabled";
    private static final String TEST_DISCOVERY_AGENT_PATH = "test.discovery.agent.path";
    private static final boolean USE_SOCKET = SystemProperties.getBooleanProperty((String)"test.discovery.use.socket", (boolean)true);
    public static final Key<TestDiscoveryDataSocketListener> SOCKET_LISTENER_KEY = Key.create((String)"test.discovery.socket.data.listener");
    private static final Logger LOG = Logger.getInstance(TestDiscoveryExtension.class);
    private static final Object ourTracesLock = new Object();

    @NotNull
    public String getSerializationId() {
        return "testDiscovery";
    }

    protected void attachToProcess(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(1);
        }
        if (runnerSettings == null && this.isApplicableFor(configuration)) {
            final Disposable disposable = Disposer.newDisposable();
            final MessageBusConnection connection = configuration.getProject().getMessageBus().connect();
            TestDiscoveryDataSocketListener listener = (TestDiscoveryDataSocketListener)SOCKET_LISTENER_KEY.get((UserDataHolder)configuration);
            if (listener == null) {
                final Alarm processTracesAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, disposable);
                connection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new SMTRunnerEventsAdapter(this){

                    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                        if (testsRoot == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (testsRoot.getHandler() != handler) {
                            return;
                        }
                        processTracesAlarm.cancelAllRequests();
                        processTracesAlarm.addRequest(() -> TestDiscoveryExtension.processTracesFile((JavaTestConfigurationWithDiscoverySupport)configuration), 0);
                        connection.disconnect();
                        Disposer.dispose((Disposable)disposable);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRoot", "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1", "onTestingFinished"));
                    }
                });
            } else {
                listener.attach(handler);
            }
        }
    }

    public void updateJavaParameters(@NotNull RunConfigurationBase configuration, @NotNull JavaParameters params, RunnerSettings runnerSettings) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(2);
        }
        if (params == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(3);
        }
        if (runnerSettings != null || !this.isApplicableFor(configuration)) {
            return;
        }
        String agentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)PathUtil.getJarPathForClass(TestDiscoveryProjectData.class), (String)"testDiscovery", (String)TEST_DISCOVERY_AGENT_PATH);
        if (agentPath == null) {
            return;
        }
        params.getVMParametersList().add("-javaagent:" + agentPath);
        TestDiscoveryDataSocketListener listener = TestDiscoveryExtension.tryInstallSocketListener(configuration);
        params.getVMParametersList().addProperty("test.discovery.data.version", String.valueOf(3));
        if (ApplicationManager.getApplication().isInternal()) {
            params.getVMParametersList().addProperty("test.discovery.affected.roots", configuration.getProject().getBasePath());
        }
        if (listener != null) {
            params.getVMParametersList().addProperty("test.discovery.data.port", Integer.toString(listener.getPort()));
            params.getVMParametersList().addProperty("test.discovery.data.host", "127.0.0.1");
            params.getVMParametersList().addProperty("test.discovery.data.listener", SocketTestDiscoveryProtocolDataListener.class.getName());
        } else {
            params.getVMParametersList().addProperty("org.jetbrains.instrumentation.trace.file", TestDiscoveryExtension.getTraceFilePath(configuration));
            params.getVMParametersList().addProperty("test.discovery.data.listener", SingleTrFileDiscoveryProtocolDataListener.class.getName());
        }
    }

    @NotNull
    private static String getTraceFilePath(RunConfigurationBase<?> configuration) {
        String string = String.valueOf(TestDiscoveryExtension.baseTestDiscoveryPathForProject(configuration.getProject())) + File.separator + configuration.getUniqueID() + ".tr";
        if (string == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener, RunnerSettings runnerSettings) {
        return listener instanceof TestDiscoveryListener && (runnerSettings != null || !this.isApplicableFor(configuration));
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(5);
        }
        return configuration instanceof JavaTestConfigurationBase && Registry.is((String)TEST_DISCOVERY_REGISTRY_KEY);
    }

    @NotNull
    public static Path baseTestDiscoveryPathForProject(Project project) {
        Path path = ProjectUtil.getProjectCachePath((Project)project, (String)"testDiscovery");
        if (path == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(6);
        }
        return path;
    }

    public void cleanUserData(RunConfigurationBase runConfigurationBase) {
        runConfigurationBase.putUserData(SOCKET_LISTENER_KEY, null);
    }

    private static void processTracesFile(JavaTestConfigurationWithDiscoverySupport configuration) {
        String tracesFilePath = TestDiscoveryExtension.getTraceFilePath(configuration);
        TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(configuration.getProject());
        String moduleName = TestDiscoveryExtension.getConfigurationModuleName(configuration);
        byte frameworkId = configuration.getTestFrameworkId();
        TestDiscoveryExtension.processTracesFile(tracesFilePath, moduleName, frameworkId, testDiscoveryIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processTracesFile(String tracesFilePath, String moduleName, byte frameworkId, TestDiscoveryIndex discoveryIndex) {
        File tracesFile = new File(tracesFilePath);
        Object object = ourTracesLock;
        synchronized (object) {
            try {
                TestDiscoveryProtocolUtil.readFile((File)tracesFile, (TestDiscoveryProtocolReader)new IdeaTestDiscoveryProtocolReader(discoveryIndex, moduleName, frameworkId));
            }
            catch (IOException e) {
                LOG.error("Can not load " + tracesFilePath, (Throwable)e);
            }
            finally {
                FileUtil.delete((File)tracesFile);
            }
        }
    }

    @NotNull
    private static String getConfigurationModuleName(JavaTestConfigurationBase configuration) {
        String string = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModuleName();
        if (string == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static TestDiscoveryDataSocketListener tryInstallSocketListener(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(8);
        }
        TestDiscoveryDataSocketListener listener = null;
        if (USE_SOCKET) {
            try {
                JavaTestConfigurationWithDiscoverySupport javaTestConfigurationBase = (JavaTestConfigurationWithDiscoverySupport)configuration;
                listener = new TestDiscoveryDataSocketListener(configuration.getProject(), TestDiscoveryExtension.getConfigurationModuleName(javaTestConfigurationBase), javaTestConfigurationBase.getTestFrameworkId());
                configuration.putUserData(SOCKET_LISTENER_KEY, (Object)listener);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return listener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "baseTestDiscoveryPathForProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateJavaParameters";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryInstallSocketListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

