/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testDiscovery.TestDiscoveryIndexKt;
import com.intellij.execution.testDiscovery.indices.DiscoveredTestDataHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Couple;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010 \u001a\u00020!H\u0016JP\u0010\"\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0016\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00152\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100%2\b\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J/\u0010*\u001a\u0004\u0018\u0001H+\"\n\b\u0000\u0010+*\u0004\u0018\u00010\f2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H+0-H\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lcom/intellij/execution/testDiscovery/TestDiscoveryIndex;", "Lcom/intellij/openapi/Disposable;", "basePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myHolder", "Lcom/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder;", "lock", "", "hasTestTrace", "", "testClassName", "", "testMethodName", "frameworkId", "", "getTestsByFile", "Lcom/intellij/util/containers/MultiMap;", "relativePath", "getTestsByClassName", "classFQName", "getTestsByMethodName", "methodName", "getTestModulesByMethodName", "", "getAffectedFiles", "testQName", "Lcom/intellij/openapi/util/Couple;", "dispose", "", "updateTestData", "usedMethods", "usedFiles", "", "moduleName", "holder", "getHolder", "()Lcom/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder;", "executeUnderLock", "R", "action", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "MyPostStartUpActivity", "intellij.java.execution.impl"})
public final class TestDiscoveryIndex
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path basePath;
    @Nullable
    private volatile DiscoveredTestDataHolder myHolder;
    @NotNull
    private final Object lock;

    @NonInjectable
    public TestDiscoveryIndex(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
        this.lock = new Object();
    }

    public TestDiscoveryIndex(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = TestDiscoveryExtension.baseTestDiscoveryPathForProject(project);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"baseTestDiscoveryPathForProject(...)");
        this(path);
    }

    public final boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        Intrinsics.checkNotNullParameter((Object)testClassName, (String)"testClassName");
        Intrinsics.checkNotNullParameter((Object)testMethodName, (String)"testMethodName");
        Object r = this.executeUnderLock(arg_0 -> TestDiscoveryIndex.hasTestTrace$lambda$0(testClassName, testMethodName, frameworkId, arg_0));
        Intrinsics.checkNotNull(r);
        return (Boolean)r;
    }

    @NotNull
    public final MultiMap<String, String> getTestsByFile(@Nullable String relativePath, byte frameworkId) {
        MultiMap multiMap = (MultiMap)this.executeUnderLock(arg_0 -> TestDiscoveryIndex.getTestsByFile$lambda$0(relativePath, frameworkId, arg_0));
        if (multiMap == null) {
            MultiMap multiMap2 = MultiMap.empty();
            multiMap = multiMap2;
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
        }
        return multiMap;
    }

    @NotNull
    public final MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) {
        Intrinsics.checkNotNullParameter((Object)classFQName, (String)"classFQName");
        MultiMap multiMap = (MultiMap)this.executeUnderLock(arg_0 -> TestDiscoveryIndex.getTestsByClassName$lambda$0(classFQName, frameworkId, arg_0));
        if (multiMap == null) {
            MultiMap multiMap2 = MultiMap.empty();
            multiMap = multiMap2;
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
        }
        return multiMap;
    }

    @NotNull
    public final MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        Intrinsics.checkNotNullParameter((Object)classFQName, (String)"classFQName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        MultiMap multiMap = (MultiMap)this.executeUnderLock(arg_0 -> TestDiscoveryIndex.getTestsByMethodName$lambda$0(classFQName, methodName, frameworkId, arg_0));
        if (multiMap == null) {
            MultiMap multiMap2 = MultiMap.empty();
            multiMap = multiMap2;
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
        }
        return multiMap;
    }

    @NotNull
    public final Collection<String> getTestModulesByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        Intrinsics.checkNotNullParameter((Object)classFQName, (String)"classFQName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Collection collection = (Collection)this.executeUnderLock(arg_0 -> TestDiscoveryIndex.getTestModulesByMethodName$lambda$0(classFQName, methodName, frameworkId, arg_0));
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public final Collection<String> getAffectedFiles(@Nullable Couple<String> testQName, byte frameworkId) {
        Collection collection = (Collection)this.executeUnderLock(arg_0 -> TestDiscoveryIndex.getAffectedFiles$lambda$0(testQName, frameworkId, arg_0));
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            DiscoveredTestDataHolder holder = this.myHolder;
            if (holder != null) {
                holder.dispose();
                this.myHolder = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull List<String> usedFiles, @Nullable String moduleName, byte frameworkId) {
        Intrinsics.checkNotNullParameter((Object)testClassName, (String)"testClassName");
        Intrinsics.checkNotNullParameter((Object)testMethodName, (String)"testMethodName");
        Intrinsics.checkNotNullParameter(usedMethods, (String)"usedMethods");
        Intrinsics.checkNotNullParameter(usedFiles, (String)"usedFiles");
        this.executeUnderLock(arg_0 -> TestDiscoveryIndex.updateTestData$lambda$0(testClassName, testMethodName, usedMethods, usedFiles, moduleName, frameworkId, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DiscoveredTestDataHolder getHolder() {
        DiscoveredTestDataHolder holder = null;
        holder = this.myHolder;
        if (holder == null) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                holder = this.myHolder;
                if (holder == null) {
                    this.myHolder = holder = new DiscoveredTestDataHolder(this.basePath);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <R> R executeUnderLock(Function1<? super DiscoveredTestDataHolder, ? extends R> action) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            DiscoveredTestDataHolder holder = this.getHolder();
            if (holder == null || holder.isDisposed()) {
                R r = null;
                return r;
            }
            try {
                Object object2 = action.invoke((Object)holder);
                return (R)object2;
            }
            catch (Throwable e) {
                TestDiscoveryIndexKt.access$getLOG().error("Unexpected problem", e);
                holder.dispose();
                PathKt.delete$default((Path)this.basePath, (boolean)false, (int)1, null);
                this.myHolder = null;
                R r = null;
                return r;
            }
        }
    }

    private static final boolean hasTestTrace$lambda$0(String $testClassName, String $testMethodName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return holder.hasTestTrace($testClassName, $testMethodName, $frameworkId);
    }

    private static final MultiMap getTestsByFile$lambda$0(String $relativePath, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = $relativePath;
        Intrinsics.checkNotNull((Object)string);
        return holder.getTestsByFile(string, $frameworkId);
    }

    private static final MultiMap getTestsByClassName$lambda$0(String $classFQName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return holder.getTestsByClassName($classFQName, $frameworkId);
    }

    private static final MultiMap getTestsByMethodName$lambda$0(String $classFQName, String $methodName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return holder.getTestsByMethodName($classFQName, $methodName, $frameworkId);
    }

    private static final Collection getTestModulesByMethodName$lambda$0(String $classFQName, String $methodName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return holder.getTestModulesByMethodName($classFQName, $methodName, $frameworkId);
    }

    private static final Collection getAffectedFiles$lambda$0(Couple $testQName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Couple couple = $testQName;
        Intrinsics.checkNotNull((Object)couple);
        return holder.getAffectedFiles((Couple<String>)couple, $frameworkId);
    }

    private static final Unit updateTestData$lambda$0(String $testClassName, String $testMethodName, MultiMap $usedMethods, List $usedFiles, String $moduleName, byte $frameworkId, DiscoveredTestDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        holder.updateTestData($testClassName, $testMethodName, (MultiMap<String, String>)$usedMethods, $usedFiles, $moduleName, $frameworkId);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final TestDiscoveryIndex getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Path access$getBasePath$p(TestDiscoveryIndex $this) {
        return $this.basePath;
    }

    public static final /* synthetic */ DiscoveredTestDataHolder access$getHolder(TestDiscoveryIndex $this) {
        return $this.getHolder();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/testDiscovery/TestDiscoveryIndex$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/execution/testDiscovery/TestDiscoveryIndex;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TestDiscoveryIndex getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TestDiscoveryIndex.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TestDiscoveryIndex)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/testDiscovery/TestDiscoveryIndex$MyPostStartUpActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.java.execution.impl"})
    public static final class MyPostStartUpActivity
    implements ProjectActivity {
        public MyPostStartUpActivity() {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var5_3 = $completion;
            if ((var5_3.label & -2147483648) != 0) {
                var5_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyPostStartUpActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    service = TestDiscoveryIndex.Companion.getInstance(project);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = service;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(service, null){
                        int label;
                        final /* synthetic */ TestDiscoveryIndex $service;
                        {
                            this.$service = $service;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return Boxing.boxBoolean((boolean)Files.exists(TestDiscoveryIndex.access$getBasePath$p(this.$service), new LinkOption[0]));
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    service = (TestDiscoveryIndex)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) {
                        return Unit.INSTANCE;
                    }
                    TestDiscoveryIndex.access$getHolder(service);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

