/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTreeModel;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiscoveredTestsTree
extends Tree
implements UiDataProvider,
Disposable {
    private final DiscoveredTestsTreeModel myModel = new DiscoveredTestsTreeModel();

    DiscoveredTestsTree(String title) {
        this.setModel((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myModel), (Disposable)this));
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), DiscoveredTestsTree::obj2psi);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this), o -> {
            PsiElement component = DiscoveredTestsTree.obj2psi(o.getLastPathComponent());
            return component instanceof PsiMember ? ((PsiMember)component).getName() : null;
        }, true);
        this.getSelectionModel().setSelectionMode(2);
        this.getEmptyText().setText(ExecutionBundle.message((String)"no.tests.captured.for.0", (Object[])new Object[]{title}));
        this.setPaintBusy(true);
        this.setRootVisible(false);
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof DiscoveredTestsTreeModel.Node) {
                    DiscoveredTestsTreeModel.Node node = (DiscoveredTestsTreeModel.Node)value;
                    this.setIcon(node.getIcon());
                    String name = node.getName();
                    assert (name != null);
                    this.append(name);
                    if (node instanceof DiscoveredTestsTreeModel.Node.Clazz) {
                        String packageName = ((DiscoveredTestsTreeModel.Node.Clazz)node).getPackageName();
                        if (packageName != null) {
                            this.append(FontUtil.spaceAndThinSpace() + packageName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        int testMethodCount = DiscoveredTestsTree.this.myModel.getChildren(value).size();
                        this.append(JavaCompilerBundle.message((String)"affected.tests.counts", (Object[])new Object[]{testMethodCount, testMethodCount == 1 ? 0 : 1}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (node instanceof DiscoveredTestsTreeModel.Node.Method) {
                        boolean isParametrized;
                        boolean bl = isParametrized = !((DiscoveredTestsTreeModel.Node.Method)node).getParameters().isEmpty();
                        if (isParametrized) {
                            this.append(FontUtil.spaceAndThinSpace() + JavaCompilerBundle.message((String)"test.discovery.parametrized", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                    }
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTree$1", "customizeCellRenderer"));
            }
        });
        this.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            boolean myAlreadyDone;

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.myAlreadyDone && DiscoveredTestsTree.this.getTestCount() != 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        TreeUtil.collapseAll((JTree)((Object)DiscoveredTestsTree.this), (int)0);
                        TreeUtil.promiseSelectFirst((JTree)((Object)DiscoveredTestsTree.this));
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTree$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this));
        CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
    }

    public void dispose() {
    }

    public void addTest(@NotNull PsiClass testClass, @Nullable PsiMethod testMethod, @Nullable String parameter) {
        if (testClass == null) {
            DiscoveredTestsTree.$$$reportNull$$$0(0);
        }
        this.myModel.addTest(testClass, testMethod, parameter);
    }

    @NotNull
    public Set<Module> getContainingModules() {
        Set<Module> set = this.myModel.getTestClasses().stream().map(element -> {
            SmartPsiElementPointer pointer = element.getPointer();
            return ModuleUtilCore.findModuleForFile((VirtualFile)pointer.getVirtualFile(), (Project)pointer.getProject());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            DiscoveredTestsTree.$$$reportNull$$$0(1);
        }
        return set;
    }

    TestMethodUsage @NotNull [] getTestMethods() {
        TestMethodUsage[] testMethodUsageArray = this.myModel.getTestMethods();
        if (testMethodUsageArray == null) {
            DiscoveredTestsTree.$$$reportNull$$$0(2);
        }
        return testMethodUsageArray;
    }

    @Nullable
    public PsiElement getSelectedElement() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        return DiscoveredTestsTree.obj2psi(path == null ? null : path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement obj2psi(@Nullable Object obj) {
        return Optional.ofNullable((DiscoveredTestsTreeModel.Node)ObjectUtils.tryCast((Object)obj, DiscoveredTestsTreeModel.Node.class)).map(n -> n.getPointer()).map(p -> p.getElement()).orElse(null);
    }

    public int getTestCount() {
        return this.myModel.getTestCount();
    }

    public int getTestClassesCount() {
        return this.myModel.getTestClassesCount();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DiscoveredTestsTree.$$$reportNull$$$0(3);
        }
        TreePath[] paths = this.getSelectionPaths();
        sink.set(LangDataKeys.POSITION_ADJUSTER_POPUP, (Object)PopupUtil.getPopupContainerFor((Component)((Object)this)));
        if (paths == null || paths.length == 0) {
            return;
        }
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> DiscoveredTestsTree.obj2psi(paths[0].getLastPathComponent()));
        sink.lazy(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, () -> {
            SmartList result = new SmartList();
            TreeModel model = this.getModel();
            for (TreePath p : paths) {
                Object o = p.getLastPathComponent();
                PsiElement e = DiscoveredTestsTree.obj2psi(o);
                if (e instanceof PsiMethod) {
                    result.add(e);
                    continue;
                }
                int count = model.getChildCount(e);
                if (count == 0 && e != null) {
                    result.add(e);
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiMethod)ObjectUtils.tryCast((Object)DiscoveredTestsTree.obj2psi(model.getChild(e, i)), PsiMethod.class)));
                }
            }
            return result.toArray(PsiElement.EMPTY_ARRAY);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/DiscoveredTestsTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTest";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

