/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testDiscovery.IntellijTestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.ShowAffectedTestsAction;
import com.intellij.find.FindUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FindUnusedTestDataAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(FindUnusedTestDataAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindUnusedTestDataAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] roots = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = e.getProject();
        e.getPresentation().setEnabled(roots != null && roots.length > 0 && project != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FindUnusedTestDataAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindUnusedTestDataAction.$$$reportNull$$$0(2);
        }
        VirtualFile[] roots = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = e.getProject();
        assert (project != null);
        assert (roots != null && roots.length > 0);
        VirtualFile projectBasePath = ShowAffectedTestsAction.getBasePathAsVirtualFile(project);
        if (projectBasePath == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            Set paths = JBIterable.of((Object[])roots).flatMap(f -> VfsUtil.collectChildrenRecursively((VirtualFile)f)).map(f -> VcsFileUtil.getRelativeFilePath((VirtualFile)f, (VirtualFile)projectBasePath)).filter(Objects::nonNull).map(p -> "/" + p).toSet();
            try {
                List<String> filesWithoutTests = new IntellijTestDiscoveryProducer().getFilesWithoutTests(project, paths);
                if (!filesWithoutTests.isEmpty()) {
                    VirtualFileManager vfm = VirtualFileManager.getInstance();
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    String basePath = projectBasePath.getPath();
                    application.runReadAction(() -> {
                        PsiFile[] files = JBIterable.of((Object)filesWithoutTests).flatten(FunctionUtil.id()).map(f -> vfm.refreshAndFindFileByUrl("file://" + basePath + f)).map(arg_0 -> ((PsiManager)psiManager).findFile(arg_0)).filter(Objects::nonNull).toSet().toArray(PsiFile.EMPTY_ARRAY);
                        if (files.length == 0) {
                            FindUnusedTestDataAction.nothingToDo();
                        } else {
                            application.invokeLater(() -> FindUtil.showInUsageView(null, (Object[])files, file -> new UsageInfo2UsageAdapter(new UsageInfo(file)), (String)JavaCompilerBundle.message((String)"test.discovery.unused.test.data.tab.title", (Object[])new Object[0]), p -> p.setCodeUsages(false), (Project)project));
                        }
                    });
                } else {
                    FindUnusedTestDataAction.nothingToDo();
                }
            }
            catch (IOException io) {
                LOG.warn((Throwable)io);
            }
        });
    }

    private static void nothingToDo() {
        Notifications.Bus.notify((Notification)new Notification(FindUnusedTestDataAction.class.getName(), ExecutionBundle.message((String)"well.done", (Object[])new Object[0]), ExecutionBundle.message((String)"every.file.is.used", (Object[])new Object[0]), NotificationType.INFORMATION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/FindUnusedTestDataAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/FindUnusedTestDataAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

