/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInModule;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestMethodUsage
implements Usage,
UsageInFile,
UsageInModule,
PsiElementUsage,
UiDataProvider {
    @NotNull
    private final SmartPsiElementPointer<? extends PsiMethod> myTestMethodPointer;
    @Nullable
    private final SmartPsiElementPointer<? extends PsiClass> myTestClassPointer;

    TestMethodUsage(@NotNull SmartPsiElementPointer<? extends PsiMethod> testMethod, @NotNull SmartPsiElementPointer<? extends PsiClass> testClass, @NotNull Collection<String> parameters) {
        if (testMethod == null) {
            TestMethodUsage.$$$reportNull$$$0(0);
        }
        if (testClass == null) {
            TestMethodUsage.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            TestMethodUsage.$$$reportNull$$$0(2);
        }
        this.myTestMethodPointer = testMethod;
        this.myTestClassPointer = parameters.isEmpty() ? null : testClass;
    }

    @Nullable
    public Location<PsiMethod> calculateLocation() {
        PsiClass c;
        PsiMethod m = (PsiMethod)this.myTestMethodPointer.getElement();
        if (m == null) {
            return null;
        }
        PsiClass psiClass = c = this.myTestClassPointer == null ? m.getContainingClass() : (PsiClass)this.myTestClassPointer.getElement();
        if (c == null) {
            return null;
        }
        return MethodLocation.elementInClass(m, c);
    }

    public VirtualFile getFile() {
        return this.getPointer().getVirtualFile();
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForFile((PsiFile)this.getPointer().getContainingFile());
    }

    @NotNull
    public UsagePresentation getPresentation() {
        return new UsagePresentation(){

            public TextChunk @NotNull [] getText() {
                TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), this.getPlainText())};
                if (textChunkArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return textChunkArray;
            }

            @NotNull
            @NlsSafe
            public String getPlainText() {
                PsiMember element = TestMethodUsage.this.getElement();
                if (element == null) {
                    return "";
                }
                String string = StringUtil.notNullize((String)element.getName());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIcon() {
                PsiMember element = TestMethodUsage.this.getElement();
                if (element == null) {
                    return null;
                }
                return element.getIcon(0);
            }

            public String getTooltipText() {
                return this.getPlainText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPlainText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getPointer().getProject();
        FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        TextEditor te = (TextEditor)editor;
        Segment segment = this.getPointer().getPsiRange();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), te);
    }

    public void selectInEditor() {
        this.navigate(true);
    }

    public void highlightInEditor() {
        PsiMember element = this.getElement();
        if (element != null) {
            Project project = this.getPointer().getProject();
            TextRange range = element.getTextRange();
            SelectInEditorManager.getInstance((Project)project).selectInEditor(this.getFile(), range.getStartOffset(), range.getEndOffset(), false, false);
        }
    }

    public void navigate(boolean requestFocus) {
        PsiMember element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Nullable
    public PsiMember getElement() {
        return (PsiMember)this.getPointer().getElement();
    }

    @NotNull
    private SmartPsiElementPointer<? extends PsiMember> getPointer() {
        Object object = this.myTestClassPointer != null ? this.myTestClassPointer : this.myTestMethodPointer;
        if (object == null) {
            TestMethodUsage.$$$reportNull$$$0(3);
        }
        return object;
    }

    public int getNavigationOffset() {
        Segment segment = this.getPointer().getPsiRange();
        if (segment == null) {
            return -1;
        }
        return segment.getStartOffset();
    }

    public boolean isNonCodeUsage() {
        return false;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TestMethodUsage.$$$reportNull$$$0(4);
        }
        sink.lazy(UsageView.USAGE_INFO_LIST_KEY, () -> {
            PsiMember psi = this.getElement();
            return psi == null ? null : Collections.singletonList(new UsageInfo((PsiElement)psi));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/TestMethodUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

