/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.JavaAwareTestConsoleProperties;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeViewProvider;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.Key;
import com.intellij.util.config.AbstractProperty;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public class JavaSMTRunnerTestTreeView
extends SMTRunnerTestTreeView
implements SMTRunnerTestTreeViewProvider.CustomizedDurationProvider {
    private static final Key<Long> FIRST_CHILD_START = Key.create((String)"JavaSMTRunnerTestTreeView.FIRST_CHILD_START");
    @NotNull
    private final TestConsoleProperties myTestConsoleProperties;

    public JavaSMTRunnerTestTreeView(@NotNull TestConsoleProperties testConsoleProperties) {
        if (testConsoleProperties == null) {
            JavaSMTRunnerTestTreeView.$$$reportNull$$$0(0);
        }
        this.myTestConsoleProperties = testConsoleProperties;
    }

    public void setTestResultsViewer(TestResultsViewer resultsViewer) {
        super.setTestResultsViewer(resultsViewer);
        if (resultsViewer instanceof SMTestRunnerResultsForm) {
            final SMTestRunnerResultsForm testFrameworkRunningModel = (SMTestRunnerResultsForm)resultsViewer;
            TestFrameworkActions.addPropertyListener((AbstractProperty)JavaAwareTestConsoleProperties.USE_WALL_TIME, (TestFrameworkPropertyListener)new TestFrameworkPropertyListener<Boolean>(this){

                public void onChanged(Boolean ignore) {
                    testFrameworkRunningModel.redrawStatusLabel();
                }
            }, (TestFrameworkRunningModel)testFrameworkRunningModel, (boolean)true);
        }
    }

    protected TreeCellRenderer getRenderer(TestConsoleProperties properties) {
        return new TestTreeRenderer(properties){

            @Nls
            @Nullable
            public String getDurationText(@NotNull SMTestProxy testProxy, @NotNull TestConsoleProperties consoleProperties) {
                if (testProxy == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (consoleProperties == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (testProxy.getDurationStrategy() != TestDurationStrategy.AUTOMATIC) {
                    return testProxy.getDurationString(consoleProperties);
                }
                if (testProxy.isInProgress() && !testProxy.isSubjectToHide(consoleProperties)) {
                    Long startedAt = testProxy.isSuite() && !JavaAwareTestConsoleProperties.USE_WALL_TIME.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) ? 2.getFirstChildStartedAt(testProxy) : testProxy.getStartTimeMillis();
                    if (startedAt == null || startedAt == 0L) {
                        return null;
                    }
                    long durationMillis = System.currentTimeMillis() - startedAt;
                    long durationSeconds = TimeUnit.MILLISECONDS.toSeconds(durationMillis);
                    if (durationSeconds == 0L) {
                        return null;
                    }
                    durationMillis = TimeUnit.SECONDS.toMillis(durationSeconds);
                    return NlsMessages.formatDurationApproximateNarrow((long)durationMillis);
                }
                if (testProxy.isSuite() && testProxy.isFinal() && !testProxy.isSubjectToHide(consoleProperties) && JavaAwareTestConsoleProperties.USE_WALL_TIME.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
                    Long startTime = testProxy.getStartTimeMillis();
                    Long endTime = testProxy.getEndTimeMillis();
                    if (startTime != null && endTime != null && startTime < endTime) {
                        return NlsMessages.formatDurationApproximateNarrow((long)(endTime - startTime));
                    }
                }
                return testProxy.getDurationString(consoleProperties);
            }

            @Nullable
            private static Long getFirstChildStartedAt(@NotNull SMTestProxy testProxy) {
                Long data;
                if (testProxy == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((data = (Long)testProxy.getUserData(FIRST_CHILD_START)) != null) {
                    return data;
                }
                Long minTime = null;
                for (SMTestProxy child : testProxy.getChildren()) {
                    Long time = child.isLeaf() ? child.getStartTimeMillis() : 2.getFirstChildStartedAt(child);
                    if (time == null || minTime != null && time >= minTime) continue;
                    minTime = time;
                }
                if (minTime != null) {
                    testProxy.putUserData(FIRST_CHILD_START, minTime);
                }
                return minTime;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testProxy";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consoleProperties";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/JavaSMTRunnerTestTreeView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDurationText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFirstChildStartedAt";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nls
    public String getToolTipText(MouseEvent event) {
        String text = super.getToolTipText(event);
        if (text != null) {
            return text;
        }
        if (event == null) {
            return null;
        }
        Point p = event.getPoint();
        TreePath location = this.getClosestPathForLocation(p.x, p.y);
        if (location == null) {
            return null;
        }
        SMTestProxy test = this.getSelectedTest(location);
        if (test == null || test.isLeaf() || test.getDurationStrategy() != TestDurationStrategy.AUTOMATIC || test.getEndTimeMillis() == null || test.getStartTimeMillis() == null || test.getEndTimeMillis() <= test.getStartTimeMillis()) {
            return null;
        }
        if (this.getWidth() / 2 < Math.abs(p.x)) {
            long overallDuration = test.getEndTimeMillis() - test.getStartTimeMillis();
            Long sumDuration = test.getDuration();
            Object durationText = "";
            durationText = (String)durationText + JavaBundle.message((String)"java.test.overall.time", (Object[])new Object[]{NlsMessages.formatDurationApproximateNarrow((long)overallDuration)});
            if (sumDuration != null) {
                durationText = (String)durationText + "<br>";
                durationText = (String)durationText + JavaBundle.message((String)"java.test.sum.time", (Object[])new Object[]{NlsMessages.formatDurationApproximateNarrow((long)sumDuration)});
            }
            return "<html>" + (String)durationText + "</html>";
        }
        return null;
    }

    public Long getCustomizedDuration(@NotNull SMTestProxy proxy) {
        if (proxy == null) {
            JavaSMTRunnerTestTreeView.$$$reportNull$$$0(1);
        }
        if (!proxy.isSuite() || proxy.getDurationStrategy() != TestDurationStrategy.AUTOMATIC || !JavaAwareTestConsoleProperties.USE_WALL_TIME.value((AbstractProperty.AbstractPropertyContainer)this.myTestConsoleProperties)) {
            return proxy.getDuration();
        }
        Long startTime = proxy.getStartTimeMillis();
        Long endTime = proxy.getEndTimeMillis();
        if (endTime == null && proxy.isInProgress()) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == null || endTime == null || startTime >= endTime) {
            return null;
        }
        return endTime - startTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsoleProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/JavaSMTRunnerTestTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomizedDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

