/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestLocator
implements SMTestLocator,
DumbAware {
    private static final Logger LOG = Logger.getInstance(JavaTestLocator.class);
    public static final String SUITE_PROTOCOL = "java:suite";
    public static final String TEST_PROTOCOL = "java:test";
    public static final JavaTestLocator INSTANCE = new JavaTestLocator();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String sourcePath, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        List list;
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(0);
        }
        if (sourcePath == null) {
            JavaTestLocator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(3);
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        try {
            list = (List)dumbService.computeWithAlternativeResolveEnabled(() -> {
                String path = sourcePath;
                String paramName = null;
                int idx = path.indexOf(91);
                if (idx >= 0) {
                    paramName = path.substring(idx);
                    path = path.substring(0, idx);
                }
                Object results = Collections.emptyList();
                if (SUITE_PROTOCOL.equals(protocol)) {
                    path = StringUtil.trimEnd((String)path, (String)".");
                    PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)path, null, (boolean)true, (GlobalSearchScope)scope);
                    if (aClass != null) {
                        results = new SmartList();
                        results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
                    } else {
                        results = JavaTestLocator.collectMethodNavigatables(path, project, scope, paramName);
                    }
                } else if (TEST_PROTOCOL.equals(protocol)) {
                    results = JavaTestLocator.collectMethodNavigatables(path, project, scope, paramName);
                }
                return results;
            });
        }
        catch (IndexNotReadyException e) {
            LOG.error((Throwable)e);
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaTestLocator.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (list == null) {
            JavaTestLocator.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, final @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(6);
        }
        if (path == null) {
            JavaTestLocator.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(9);
        }
        List<Location> locations = this.getLocation(protocol, path, project, scope);
        if (metainfo != null) {
            for (Location location : locations) {
                List<1> list;
                String[] lineColumn;
                PsiElement element = location.getPsiElement();
                if (element instanceof PsiMethod) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)metainfo, (CharSequence)ClassUtil.getVMParametersMethodSignature((PsiMethod)((PsiMethod)element)))) continue;
                    List<Location> list2 = Collections.singletonList(location);
                    if (list2 == null) {
                        JavaTestLocator.$$$reportNull$$$0(10);
                    }
                    return list2;
                }
                if (!(element instanceof PsiClass) || (lineColumn = metainfo.split(":")).length != 2) continue;
                try {
                    final int line = Integer.parseInt(lineColumn[0]);
                    final int col = Integer.parseInt(lineColumn[1]);
                    list = Collections.singletonList(new PsiLocation<PsiElement>(this, project, element){

                        public OpenFileDescriptor getOpenFileDescriptor() {
                            VirtualFile file = this.getVirtualFile();
                            return file != null ? new OpenFileDescriptor(project, file, line, col) : null;
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (list == null) {
                    JavaTestLocator.$$$reportNull$$$0(11);
                }
                return list;
            }
        }
        List<Location> list = locations;
        if (list == null) {
            JavaTestLocator.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String stacktraceLine, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (stacktraceLine == null) {
            JavaTestLocator.$$$reportNull$$$0(13);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(15);
        }
        StackTraceLine line = new StackTraceLine(project, stacktraceLine);
        List<Location> list = this.getLocation(TEST_PROTOCOL, line.getClassName() + "/" + line.getMethodName(), project, scope);
        if (list == null) {
            JavaTestLocator.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static List<Location> collectMethodNavigatables(@NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope, String paramName) {
        int classSeparatorIdx;
        if (path == null) {
            JavaTestLocator.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(19);
        }
        if ((classSeparatorIdx = path.indexOf(47)) > 0) {
            String className = path.substring(0, classSeparatorIdx);
            String methodName = path.substring(classSeparatorIdx + 1);
            return JavaTestLocator.collectMethodNavigatables(project, scope, paramName, methodName, className);
        }
        String className = StringUtil.getPackageName((String)path);
        String methodName = StringUtil.getShortName((String)path);
        if (!className.isEmpty()) {
            return JavaTestLocator.collectMethodNavigatables(project, scope, paramName, methodName, className);
        }
        return Collections.emptyList();
    }

    private static List<Location> collectMethodNavigatables(@NotNull Project project, @NotNull GlobalSearchScope scope, String paramName, String methodName, String className) {
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(21);
        }
        SmartList results = Collections.emptyList();
        PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)className, null, (boolean)true, (GlobalSearchScope)scope);
        if (aClass != null) {
            results = new SmartList();
            if (methodName.trim().equals(aClass.getName())) {
                results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
            } else {
                PsiMethod[] methods = aClass.findMethodsByName(methodName.trim(), true);
                if (methods.length == 0 && !methodName.equals(methodName.trim())) {
                    methods = aClass.findMethodsByName(methodName, true);
                }
                for (PsiMethod method : methods) {
                    results.add(paramName != null ? new PsiMemberParameterizedLocation(project, (PsiElement)method, aClass, paramName) : MethodLocation.elementInClass(method, aClass));
                }
            }
        }
        return results;
    }

    private static Location createClassNavigatable(String paramName, @NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaTestLocator.$$$reportNull$$$0(22);
        }
        return paramName != null ? PsiMemberParameterizedLocation.getParameterizedLocation(aClass, paramName) : new PsiLocation(aClass.getProject(), (PsiElement)aClass);
    }

    @NotNull
    public static String createLocationUrl(@NotNull String protocol, @NotNull String className) {
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(23);
        }
        if (className == null) {
            JavaTestLocator.$$$reportNull$$$0(24);
        }
        return JavaTestLocator.createLocationUrl(protocol, className, null);
    }

    @NotNull
    public static String createLocationUrl(@NotNull String protocol, @NotNull String className, @Nullable String methodName) {
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(25);
        }
        if (className == null) {
            JavaTestLocator.$$$reportNull$$$0(26);
        }
        return JavaTestLocator.createLocationUrl(protocol, className, methodName, null);
    }

    @NotNull
    public static String createLocationUrl(@NotNull String protocol, @NotNull String className, @Nullable String methodName, @Nullable String paramName) {
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(27);
        }
        if (className == null) {
            JavaTestLocator.$$$reportNull$$$0(28);
        }
        String baseUrl = protocol + "://";
        if (methodName == null) {
            String string = baseUrl + className;
            if (string == null) {
                JavaTestLocator.$$$reportNull$$$0(29);
            }
            return string;
        }
        methodName = StringUtil.trimEnd((String)methodName, (String)"()");
        if (paramName == null) {
            String string = baseUrl + className + "/" + methodName;
            if (string == null) {
                JavaTestLocator.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = baseUrl + className + "/" + methodName + paramName;
        if (string == null) {
            JavaTestLocator.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 12, 16, 29, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/JavaTestLocator";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktraceLine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/JavaTestLocator";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodNavigatables";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createClassNavigatable";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLocationUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 12, 16, 29, 30, 31 -> new IllegalStateException(string);
        };
    }
}

