/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.execution.ui.ProgramInputRedirectPanel;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;

public class CommonJavaParametersPanel
extends CommonProgramParametersPanel {
    private LabeledComponent<RawCommandLineEditor> myVMParametersComponent;
    private ProgramInputRedirectPanel myInputRedirectPanel;

    protected void addComponents() {
        this.myVMParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.java.vm.parameters.label", (Object[])new Object[0]));
        this.copyDialogCaption(this.myVMParametersComponent);
        this.myVMParametersComponent.setLabelLocation("West");
        this.add((Component)this.myVMParametersComponent);
        super.addComponents();
        this.myInputRedirectPanel = new ProgramInputRedirectPanel();
        this.add((Component)this.myInputRedirectPanel);
    }

    protected final boolean isMacroSupportEnabled() {
        return true;
    }

    protected void initMacroSupport() {
        super.initMacroSupport();
        this.addMacroSupport((ExtendableTextField)((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).getEditorField(), MacrosDialog.Filters.ALL);
        this.addMacroSupport((ExtendableTextField)this.myInputRedirectPanel.getComponent().getTextField(), MacrosDialog.Filters.ANY_PATH);
    }

    public void setVMParameters(String text) {
        ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).setText(text);
    }

    public String getVMParameters() {
        return ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).getText();
    }

    public LabeledComponent<RawCommandLineEditor> getVMParametersComponent() {
        return this.myVMParametersComponent;
    }

    public void setAnchor(JComponent labelAnchor) {
        super.setAnchor(labelAnchor);
        this.myVMParametersComponent.setAnchor(labelAnchor);
    }

    protected void setupAnchor() {
        super.setupAnchor();
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this, this.myVMParametersComponent, this.myInputRedirectPanel});
    }

    public void applyTo(CommonJavaRunConfigurationParameters configuration) {
        InputRedirectAware.InputRedirectOptions inputRedirectOptions;
        super.applyTo((CommonProgramRunConfigurationParameters)configuration);
        configuration.setVMParameters(this.getVMParameters());
        InputRedirectAware.InputRedirectOptions inputRedirectOptions2 = inputRedirectOptions = configuration instanceof RunConfiguration ? InputRedirectAware.getInputRedirectOptions((RunConfiguration)((RunConfiguration)configuration)) : null;
        if (inputRedirectOptions != null) {
            this.myInputRedirectPanel.applyTo(inputRedirectOptions);
        }
    }

    public void reset(CommonJavaRunConfigurationParameters configuration) {
        super.reset((CommonProgramRunConfigurationParameters)configuration);
        this.setVMParameters(configuration.getVMParameters());
        InputRedirectAware.InputRedirectOptions inputRedirectOptions = configuration instanceof RunConfiguration ? InputRedirectAware.getInputRedirectOptions((RunConfiguration)((RunConfiguration)configuration)) : null;
        this.myInputRedirectPanel.setVisible(inputRedirectOptions != null);
        this.myInputRedirectPanel.reset(inputRedirectOptions);
    }
}

