/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JrePathEditor
extends LabeledComponent<ComboBox<JreComboBoxItem>>
implements PanelWithAnchor {
    private final JreComboboxEditor myComboboxEditor;
    private final DefaultJreItem myDefaultJreItem;
    private DefaultJreSelector myDefaultJreSelector;
    @Nls
    private String myDefaultJreDescription;
    private final SortedComboBoxModel<JreComboBoxItem> myComboBoxModel = new SortedComboBoxModel<JreComboBoxItem>((o1, o2) -> {
        int result = Integer.compare(o1.getOrder(), o2.getOrder());
        if (result != 0) {
            return result;
        }
        return o1.getPresentableText().compareToIgnoreCase(o2.getPresentableText());
    }){

        public void setSelectedItem(Object anItem) {
            if (anItem instanceof AddJreItem) {
                ((ComboBox)JrePathEditor.this.getComponent()).hidePopup();
                JrePathEditor.this.getBrowseRunnable().run();
            } else {
                super.setSelectedItem(anItem);
            }
        }
    };
    private String myPreviousCustomJrePath;
    private boolean myRemoteTarget;

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        this(true);
    }

    public JrePathEditor(boolean editable) {
        this.myDefaultJreItem = new DefaultJreItem();
        this.myComboBoxModel.add((Object)this.myDefaultJreItem);
        this.myComboBoxModel.setSelectedItem((Object)this.myDefaultJreItem);
        ComboBox comboBox = new ComboBox(this.myComboBoxModel, JBUI.scale((int)300));
        comboBox.setEditable(editable);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> list, JreComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    value.render((SimpleColoredComponent)this, selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$2", "customizeCellRenderer"));
            }
        });
        this.setComponent((JComponent)comboBox);
        this.myComboboxEditor = new JreComboboxEditor(this.myComboBoxModel){

            @Override
            protected JTextField createEditorComponent() {
                ExtendableTextField field = new ExtendableTextField().addBrowseExtension(JrePathEditor.this.getBrowseRunnable(), null, false);
                field.setBorder(null);
                field.addFocusListener(new FocusListener(this){

                    @Override
                    public void focusGained(FocusEvent e) {
                        1.update(e);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        1.update(e);
                    }

                    private static void update(FocusEvent e) {
                        Container c = e.getComponent().getParent();
                        if (c != null) {
                            c.revalidate();
                            c.repaint();
                        }
                    }
                });
                field.setTextToTriggerEmptyTextStatus(ExecutionBundle.message((String)"default.jre.name", (Object[])new Object[0]));
                return field;
            }
        };
        comboBox.setEditor((ComboBoxEditor)this.myComboboxEditor);
        InsertPathAction.addTo((JTextComponent)this.myComboboxEditor.getEditorComponent());
        this.setLabelLocation("West");
        this.setText(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
        this.updateUI();
        this.updateModel(items -> this.myComboBoxModel.setAll((Collection)items));
        this.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                JrePathEditor.this.updateDefaultJrePresentation();
            }
        });
    }

    private void updateModel(Consumer<List<JreComboBoxItem>> consumer) {
        boolean editable = ((ComboBox)this.getComponent()).isEditable();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<JreComboBoxItem> items = this.buildModel(editable);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (((ComboBox)this.getComponent()).isVisible()) {
                    consumer.accept(items);
                }
            }, ModalityState.any());
        });
    }

    public boolean updateModel(@NotNull Project project, @Nullable String targetName) {
        if (project == null) {
            JrePathEditor.$$$reportNull$$$0(0);
        }
        ArrayList items = new ArrayList();
        this.myRemoteTarget = false;
        TargetEnvironmentConfiguration config = TargetEnvironmentConfigurations.getEffectiveConfiguration((String)targetName, (Project)project);
        if (config != null) {
            this.myRemoteTarget = true;
            items.addAll(ContainerUtil.mapNotNull((Collection)config.getRuntimes().resolvedConfigs(), configuration -> configuration instanceof JavaLanguageRuntimeConfiguration ? new CustomJreItem((JavaLanguageRuntimeConfiguration)configuration) : null));
            this.myComboBoxModel.addAll(items);
            if (!items.isEmpty()) {
                this.myComboBoxModel.setSelectedItem(items.get(0));
            }
            return false;
        }
        this.updateModel(items1 -> {
            items.addAll(items1);
            this.myComboBoxModel.setAll((Collection)items);
        });
        return true;
    }

    private List<JreComboBoxItem> buildModel(boolean editable) {
        Sdk[] allJDKs;
        ArrayList<JreComboBoxItem> model = new ArrayList<JreComboBoxItem>();
        model.add(this.myDefaultJreItem);
        for (Sdk sdk : allJDKs = ProjectJdkTable.getInstance().getAllJdks()) {
            model.add(new SdkAsJreItem(sdk));
        }
        HashSet<String> jrePaths = new HashSet<String>();
        for (JreProvider provider : JreProvider.EP_NAME.getExtensionList()) {
            String path;
            if (!provider.isAvailable() || StringUtil.isEmpty((String)(path = provider.getJrePath()))) continue;
            jrePaths.add(path);
            model.add(new CustomJreItem(provider));
        }
        for (Sdk jdk : allJDKs) {
            String homePath;
            block7: {
                homePath = jdk.getHomePath();
                if (!SystemInfo.isMac && jdk.getHomePath() != null) {
                    try {
                        Path path = Path.of(jdk.getHomePath(), "jre");
                        if (!Files.isDirectory(path, new LinkOption[0])) break block7;
                        homePath = path.toString();
                    }
                    catch (SecurityException | InvalidPathException ignored) {
                        continue;
                    }
                }
            }
            if (!jrePaths.add(homePath)) continue;
            model.add(new CustomJreItem(homePath, null, jdk.getVersionString()));
        }
        if (!editable) {
            model.add(new AddJreItem());
        }
        return model;
    }

    private Runnable getBrowseRunnable() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0])).withDescription(ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]));
        return new BrowseFolderRunnable(null, descriptor, (JComponent)((ComboBox)this.getComponent()), JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jre = this.getSelectedJre();
        if (jre instanceof DefaultJreItem || this.myRemoteTarget) {
            return this.myPreviousCustomJrePath;
        }
        return jre.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        return !(this.getSelectedJre() instanceof DefaultJreItem) && !this.myRemoteTarget;
    }

    private JreComboBoxItem getSelectedJre() {
        ComboBox comboBox = (ComboBox)this.getComponent();
        return comboBox.isEditable() ? (JreComboBoxItem)comboBox.getEditor().getItem() : (JreComboBoxItem)comboBox.getSelectedItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.myDefaultJreSelector = defaultJreSelector;
        this.myDefaultJreSelector.addChangeListener(() -> this.updateDefaultJrePresentation());
        this.updateDefaultJrePresentation();
    }

    public void setPathOrName(@Nullable String pathOrName, boolean useAlternativeJre) {
        JreComboBoxItem toSelect = this.myDefaultJreItem;
        if (!StringUtil.isEmpty((String)pathOrName)) {
            this.myPreviousCustomJrePath = pathOrName;
            if (useAlternativeJre) {
                toSelect = this.findOrAddCustomJre(pathOrName);
            }
        }
        ((ComboBox)this.getComponent()).setSelectedItem((Object)toSelect);
        this.updateDefaultJrePresentation();
    }

    private void updateDefaultJrePresentation() {
        this.myDefaultJreDescription = null;
        this.updateDefaultJrePresentation(description -> {
            StatusText text = this.myComboboxEditor.getEmptyText();
            text.clear();
            text.appendText(ExecutionBundle.message((String)"default.jre.name", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            text.appendText(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        });
    }

    private void updateDefaultJrePresentation(@NotNull Consumer<? super @Nls String> uiUpdater) {
        if (uiUpdater == null) {
            JrePathEditor.$$$reportNull$$$0(1);
        }
        ReadAction.nonBlocking(this.myDefaultJreSelector::getDescriptionString).coalesceBy(new Object[]{this, uiUpdater}).finishOnUiThread(ModalityState.stateForComponent((Component)((Object)this)), uiUpdater).expireWhen(() -> !this.myDefaultJreSelector.isValid()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private JreComboBoxItem findOrAddCustomJre(@NotNull String pathOrName) {
        if (pathOrName == null) {
            JrePathEditor.$$$reportNull$$$0(2);
        }
        for (JreComboBoxItem item : this.myComboBoxModel.getItems()) {
            if ((!(item instanceof CustomJreItem) || !FileUtil.pathsEqual((String)pathOrName, (String)((CustomJreItem)item).myPath)) && !pathOrName.equals(item.getPathOrName())) continue;
            return item;
        }
        CustomJreItem item = new CustomJreItem(pathOrName);
        this.myComboBoxModel.add((Object)item);
        return item;
    }

    public void addActionListener(ActionListener listener) {
        ((ComboBox)this.getComponent()).addActionListener(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOrName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/JrePathEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDefaultJrePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrAddCustomJre";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(ExecutionBundle.message((String)"default.jre.name", (Object[])new Object[0]));
            component.setIcon(EmptyIcon.ICON_16);
            if (JrePathEditor.this.myDefaultJreDescription != null) {
                component.append(JrePathEditor.this.myDefaultJreDescription, SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (JrePathEditor.this.myDefaultJreSelector != null) {
                JrePathEditor.this.updateDefaultJrePresentation(description -> {
                    JrePathEditor.this.myDefaultJreDescription = description;
                    JrePathEditor.this.myComboBoxModel.update((Object)this);
                });
            }
        }

        @Override
        public String getPresentableText() {
            return ExecutionBundle.message((String)"default.jre.name", (Object[])new Object[0]);
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public String getVersion() {
            return JrePathEditor.this.myDefaultJreSelector.getVersion();
        }

        @Override
        @Nullable
        public String getDescription() {
            return (String)JrePathEditor.this.myDefaultJreSelector.getNameAndDescription().second;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk mySdk;

        SdkAsJreItem(Sdk sdk) {
            this.mySdk = sdk;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            OrderEntryAppearanceService.getInstance().forJdk(this.mySdk, false, selected, true).customize(component);
        }

        @Override
        public String getPresentableText() {
            return this.mySdk.getName();
        }

        @Override
        public String getPathOrName() {
            return this.mySdk.getName();
        }

        @Override
        public String getVersion() {
            return this.mySdk.getVersionString();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.mySdk.getVersionString();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        @NlsSafe
        private final String myPath;
        private final @NlsContexts.Label String myName;
        private final String myVersion;
        private final String myID;

        CustomJreItem(String path) {
            this.myPath = path;
            this.myName = null;
            JdkVersionDetector.JdkVersionInfo info = SdkVersionUtil.getJdkVersionInfo((String)path);
            this.myVersion = info == null ? null : info.toString();
            this.myID = null;
        }

        CustomJreItem(@NotNull JreProvider provider) {
            if (provider == null) {
                CustomJreItem.$$$reportNull$$$0(0);
            }
            this.myPath = provider.getJrePath();
            this.myName = provider.getPresentableName();
            this.myVersion = null;
            this.myID = provider.getID();
        }

        CustomJreItem(String path, @NlsContexts.Label String name, String version) {
            this.myPath = path;
            this.myName = name;
            this.myVersion = version;
            this.myID = null;
        }

        CustomJreItem(JavaLanguageRuntimeConfiguration runtimeConfiguration) {
            this.myPath = runtimeConfiguration.getHomePath();
            this.myName = null;
            this.myVersion = runtimeConfiguration.getJavaVersionString();
            this.myID = null;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        @NlsContexts.Label
        public String getPresentableText() {
            return this.myName != null && !this.myName.equals(this.myPath) ? this.myName : FileUtil.toSystemDependentName((String)this.myPath);
        }

        @Override
        @NonNls
        @Nullable
        public String getID() {
            return this.myID;
        }

        @Override
        public String getPathOrName() {
            return this.myPath;
        }

        @Override
        public String getVersion() {
            return this.myVersion;
        }

        @Override
        @NlsSafe
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        public int getOrder() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/execution/ui/JrePathEditor$CustomJreItem", "<init>"));
        }
    }

    private static class AddJreItem
    implements JreComboBoxItem {
        private AddJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(EmptyIcon.ICON_16);
        }

        @Override
        @NlsContexts.Label
        public String getPresentableText() {
            return ExecutionBundle.message((String)"run.configuration.select.alternate.jre.action", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    public static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @NonNls
        @Nullable
        default public String getID() {
            return null;
        }

        @Nullable
        @NlsSafe
        public String getPathOrName();

        @Nullable
        default public String getVersion() {
            return null;
        }

        @NlsSafe
        @Nullable
        default public String getDescription() {
            return this.getPresentableText();
        }

        public int getOrder();
    }
}

