/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.vmOptions;

import com.intellij.execution.vmOptions.CommandOptionsExtractor;
import com.intellij.execution.vmOptions.JdkOptionsData;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionsService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsServiceImpl;", "Lcom/intellij/execution/vmOptions/VMOptionsService;", "<init>", "()V", "getOrComputeOptionsForJdk", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/execution/vmOptions/JdkOptionsData;", "javaHome", "", "getOrComputeOptionsForJavac", "getStandardOptions", "getStandardJavacOptions", "Companion", "intellij.java.execution.impl"})
public final class VMOptionsServiceImpl
implements VMOptionsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<VMOption> STANDARD_OPTION_LIST = CommandOptionsExtractor.Java.getStandardOptionList();

    @Override
    @NotNull
    public CompletableFuture<JdkOptionsData> getOrComputeOptionsForJdk(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        return CommandOptionsExtractor.Java.INSTANCE.getOrComputeOptions(javaHome);
    }

    @Override
    @NotNull
    public CompletableFuture<JdkOptionsData> getOrComputeOptionsForJavac(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        return CommandOptionsExtractor.Javac.INSTANCE.getOrComputeOptions(javaHome);
    }

    @Override
    @NotNull
    public JdkOptionsData getStandardOptions() {
        return new JdkOptionsData(CommandOptionsExtractor.Java.getStandardOptionList());
    }

    @Override
    @NotNull
    public JdkOptionsData getStandardJavacOptions() {
        return new JdkOptionsData(CommandOptionsExtractor.Javac.INSTANCE.getSTANDARD_OPTIONS_LIST());
    }

    @JvmName(name="getStandardOptionList")
    @NotNull
    public static final List<VMOption> getStandardOptionList() {
        return Companion.getStandardOptionList();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/vmOptions/VMOptionsServiceImpl$Companion;", "", "<init>", "()V", "STANDARD_OPTION_LIST", "", "Lcom/intellij/execution/vmOptions/VMOption;", "getStandardOptionList$annotations", "getStandardOptionList", "()Ljava/util/List;", "intellij.java.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="getStandardOptionList")
        @NotNull
        public final List<VMOption> getStandardOptionList() {
            return STANDARD_OPTION_LIST;
        }

        @JvmStatic
        public static /* synthetic */ void getStandardOptionList$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

