/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildView;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskDebugRunner;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.NamedColorUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForkedDebuggerThread
extends Thread {
    @NotNull
    private final ProcessHandler myMainProcessHandler;
    @NotNull
    private final ServerSocket mySocket;
    @NotNull
    private final Project myProject;
    @NotNull
    private final RunContentDescriptor myMainRunContentDescriptor;
    @NotNull
    private final ExecutionEnvironment myMainExecutionEnvironment;
    @NotNull
    private final ExternalSystemRunnableState myMainRunnableState;

    ForkedDebuggerThread(@NotNull ProcessHandler mainProcessHandler, @NotNull RunContentDescriptor mainRunContentDescriptor, @NotNull ServerSocket socket, @NotNull ExecutionEnvironment mainExecutionEnvironment, @NotNull ExternalSystemRunnableState mainRunnableState) {
        if (mainProcessHandler == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(0);
        }
        if (mainRunContentDescriptor == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(1);
        }
        if (socket == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(2);
        }
        if (mainExecutionEnvironment == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(3);
        }
        if (mainRunnableState == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(4);
        }
        super("external task forked debugger runner");
        this.setDaemon(true);
        this.mySocket = socket;
        this.myProject = mainExecutionEnvironment.getProject();
        this.myMainProcessHandler = mainProcessHandler;
        this.myMainRunContentDescriptor = mainRunContentDescriptor;
        this.myMainExecutionEnvironment = mainExecutionEnvironment;
        this.myMainRunnableState = mainRunnableState;
        this.myMainProcessHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.closeSocket();
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.closeSocket();
            }

            void closeSocket() {
                try {
                    if (!ForkedDebuggerThread.this.mySocket.isClosed()) {
                        ForkedDebuggerThread.this.mySocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void run() {
        while (!(this.myMainProcessHandler.isProcessTerminated() || this.myMainProcessHandler.isProcessTerminating() || this.mySocket.isClosed())) {
            try {
                if (ExternalSystemTaskDebugRunner.LOG.isDebugEnabled()) {
                    int port = this.mySocket.getLocalPort();
                    String host = this.mySocket.getInetAddress().getHostAddress();
                    String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                    ExternalSystemTaskDebugRunner.LOG.debug(String.format("%s wait for debug process signal on '%s:%d'", productName, host, port));
                }
                this.handleForkedProcessSignal(this.mySocket.accept());
            }
            catch (EOFException port) {
            }
            catch (SocketException e) {
                ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
            }
            catch (IOException e) {
                ExternalSystemTaskDebugRunner.LOG.warn((Throwable)e);
            }
        }
        try {
            if (!this.mySocket.isClosed()) {
                this.mySocket.close();
            }
        }
        catch (IOException e) {
            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
        }
    }

    private void handleForkedProcessSignal(final Socket accept) throws IOException {
        final DataInputStream stream = new DataInputStream(accept.getInputStream());
        String debuggerId = stream.readUTF();
        String processName = stream.readUTF();
        String processParameters = stream.readUTF();
        if (ExternalSystemTaskDebugRunner.LOG.isDebugEnabled()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String logMessage = "%s received debug process signal ID='%s', PROC_NAME='%s', PARAMS='%s'";
            ExternalSystemTaskDebugRunner.LOG.debug(String.format(logMessage, productName, debuggerId, processName, processParameters));
        }
        if (processParameters.startsWith("FINISH_PARAMS")) {
            this.removeTerminatedForks(processName, accept, stream);
            return;
        }
        this.myMainProcessHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                StreamUtil.closeStream((Closeable)stream);
                StreamUtil.closeStream((Closeable)accept);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$2", "processTerminated"));
            }
        });
        this.attachRemoteDebugger(debuggerId, processName, processParameters, accept, stream);
    }

    private void attachRemoteDebugger(@NotNull String debuggerId, @NotNull String processName, @NotNull String processParameters, @NotNull Socket accept, @NotNull DataInputStream inputStream) {
        DebuggerBackendExtension extension;
        if (debuggerId == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(5);
        }
        if (processName == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(6);
        }
        if (processParameters == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(7);
        }
        if (accept == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(8);
        }
        if (inputStream == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(9);
        }
        if ((extension = (DebuggerBackendExtension)DebuggerBackendExtension.EP_NAME.findFirstSafe(it -> it.id().equals(debuggerId))) != null) {
            RunnerAndConfigurationSettings settings = extension.debugConfigurationSettings(this.myProject, processName, processParameters);
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (this.myMainRunnableState.isReattachDebugProcess()) {
                if (runConfiguration instanceof RemoteConfiguration) {
                    this.reattachRemoteDebugger((RemoteConfiguration)runConfiguration, debugProcess -> {
                        this.stopForkedProcessWhenMainProcessTerminated(debugProcess.getProcessHandler());
                        this.initTerminateForkedProcessHandler(debugProcess.getProcessHandler());
                        ForkedDebuggerThread.unblockRemote(accept, inputStream);
                    });
                    return;
                }
                ExternalSystemTaskDebugRunner.LOG.warn("Unsupported reattach child debugger process into main process");
            }
            ForkedDebuggerThread.runDebugConfiguration(settings, descriptor -> {
                descriptor.setSelectContentWhenAdded(false);
                this.stopForkedProcessWhenMainProcessTerminated(descriptor.getProcessHandler());
                this.removeRunContentWhenProcessIsTerminated(descriptor);
                this.initForkedProcessLogger(descriptor, processName);
                this.initTerminateForkedProcessHandler(descriptor.getProcessHandler());
                ForkedDebuggerThread.unblockRemote(accept, inputStream);
            });
        }
    }

    private void reattachRemoteDebugger(@NotNull RemoteConfiguration runConfiguration, @NotNull Consumer<? super DebugProcess> callback) {
        DebuggerManager debuggerManager;
        DebugProcess debugProcess;
        if (runConfiguration == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(11);
        }
        if ((debugProcess = (debuggerManager = DebuggerManager.getInstance((Project)this.myProject)).getDebugProcess(this.myMainProcessHandler)) instanceof DebugProcessImpl) {
            RemoteConnection connection = runConfiguration.createRemoteConnection();
            DefaultDebugEnvironment environment = new DefaultDebugEnvironment(this.myMainExecutionEnvironment, (RunProfileState)this.myMainRunnableState, connection, true);
            ApplicationManager.getApplication().invokeAndWait(() -> ForkedDebuggerThread.lambda$reattachRemoteDebugger$4(debugProcess, (DebugEnvironment)environment, callback));
        }
    }

    private static void unblockRemote(Socket socket, DataInputStream inputStream) {
        try {
            socket.getOutputStream().write(0);
            inputStream.close();
        }
        catch (IOException e) {
            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
        }
    }

    private void stopForkedProcessWhenMainProcessTerminated(final @Nullable ProcessHandler processHandler) {
        if (processHandler != null) {
            this.myMainProcessHandler.addProcessListener(new ProcessListener(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ForkedDebuggerThread.this.myMainProcessHandler.removeProcessListener((ProcessListener)this);
                    ForkedDebuggerThread.this.terminateForkedProcess(processHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$3", "processWillTerminate"));
                }
            });
        }
    }

    private void removeRunContentWhenProcessIsTerminated(final @NotNull RunContentDescriptor descriptor) {
        ProcessHandler processHandler;
        if (descriptor == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(12);
        }
        if ((processHandler = descriptor.getProcessHandler()) != null) {
            processHandler.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    ToolWindowManager toolWindowManager;
                    ToolWindow window;
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((window = (toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject)).getToolWindow("Debug")) != null) {
                        ContentManager contentManager = window.getContentManager();
                        Content content = descriptor.getAttachedContent();
                        if (content != null) {
                            ApplicationManager.getApplication().invokeLater(() -> contentManager.removeContent(content, true));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$4", "processTerminated"));
                }
            });
        }
    }

    private void initForkedProcessLogger(@NotNull RunContentDescriptor descriptor, @NotNull String processName) {
        ProcessHandler processHandler;
        if (descriptor == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(13);
        }
        if (processName == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(14);
        }
        if ((processHandler = descriptor.getProcessHandler()) != null) {
            processHandler.addProcessListener((ProcessListener)new MyForkedProcessListener(descriptor, processName));
        }
    }

    private void initTerminateForkedProcessHandler(@Nullable ProcessHandler processHandler) {
        if (processHandler != null) {
            processHandler.addProcessListener(new ProcessListener(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!willBeDestroyed) {
                        ForkedDebuggerThread.this.terminateForkedProcess(event.getProcessHandler());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$5", "processWillTerminate"));
                }
            });
        }
    }

    private void removeTerminatedForks(@NotNull String processName, @NotNull Socket socket, @NotNull DataInputStream inputStream) {
        if (processName == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(15);
        }
        if (socket == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(16);
        }
        if (inputStream == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ProcessHandler handler;
            RunContentDescriptor descriptor;
            ContentManager contentManager;
            Content content;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow window = toolWindowManager.getToolWindow("Debug");
            if (window != null && (content = (contentManager = window.getContentManager()).findContent(processName)) != null && (descriptor = (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) != null && (handler = descriptor.getProcessHandler()) != null) {
                handler.destroyProcess();
            }
            ForkedDebuggerThread.unblockRemote(socket, inputStream);
        });
    }

    private static void runDebugConfiguration(@NotNull RunnerAndConfigurationSettings runSettings, ProgramRunner.Callback callback) {
        if (runSettings == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(18);
        }
        try {
            runSettings.setActivateToolWindowBeforeRun(false);
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runSettings).contentToReuse(null).dataContext(null).activeTarget();
            ForkedDebuggerThread.buildWithRuntimeModuleDir(runSettings, builder);
            ExecutionEnvironment environment = builder.build();
            ApplicationManager.getApplication().invokeAndWait(() -> ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)environment, (boolean)true, (boolean)true, (ProgramRunner.Callback)callback));
        }
        catch (ExecutionException e) {
            ExternalSystemTaskDebugRunner.LOG.error((Throwable)e);
        }
    }

    private static void buildWithRuntimeModuleDir(@NotNull RunnerAndConfigurationSettings runSettings, ExecutionEnvironmentBuilder builder) {
        String moduleDir;
        RunConfiguration configuration;
        if (runSettings == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(19);
        }
        if ((configuration = runSettings.getConfiguration()) instanceof UserDataHolder && (moduleDir = (String)((UserDataHolder)configuration).getUserData(DebuggerBackendExtension.RUNTIME_MODULE_DIR_KEY)) != null) {
            builder.modulePath(moduleDir);
        }
    }

    private void terminateForkedProcess(@NotNull ProcessHandler processHandler) {
        DebugProcess debugProcess;
        if (processHandler == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(20);
        }
        if ((debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(processHandler)) != null) {
            debugProcess.getManagerThread().invokeCommand(new DebuggerCommand(){

                public void action() {
                    VirtualMachineProxyImpl virtualMachineProxy = VirtualMachineProxyImpl.getCurrent();
                    if (virtualMachineProxy.canBeModified()) {
                        virtualMachineProxy.exit(0);
                    } else {
                        debugProcess.stop(true);
                    }
                }

                public void commandCancelled() {
                    debugProcess.stop(true);
                }
            });
        } else {
            processHandler.destroyProcess();
        }
    }

    private static /* synthetic */ void lambda$reattachRemoteDebugger$4(DebugProcess debugProcess, DebugEnvironment environment, Consumer callback) {
        ((DebugProcessImpl)debugProcess).reattach(environment, true, () -> callback.accept(debugProcess));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainProcessHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainRunContentDescriptor";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainExecutionEnvironment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainRunnableState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accept";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "attachRemoteDebugger";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reattachRemoteDebugger";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRunContentWhenProcessIsTerminated";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "initForkedProcessLogger";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTerminatedForks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "runDebugConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "buildWithRuntimeModuleDir";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "terminateForkedProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyForkedProcessListener
    implements ProcessListener {
        @NotNull
        private final RunContentDescriptor myDescriptor;
        @NotNull
        private final String myProcessName;
        @Nullable
        private RangeHighlighter myHyperlink;

        MyForkedProcessListener(@NotNull RunContentDescriptor descriptor, String processName) {
            if (descriptor == null) {
                MyForkedProcessListener.$$$reportNull$$$0(0);
            }
            if (processName == null) {
                MyForkedProcessListener.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor;
            this.myProcessName = processName;
        }

        public void startNotified(@NotNull ProcessEvent event) {
            if (event == null) {
                MyForkedProcessListener.$$$reportNull$$$0(2);
            }
            this.postLink();
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyForkedProcessListener.$$$reportNull$$$0(3);
            }
            this.removeLink();
        }

        private void postLink() {
            ConsoleViewImpl mainConsoleView = this.getMainConsoleView();
            if (mainConsoleView != null) {
                ProcessHandler handler = this.myDescriptor.getProcessHandler();
                Object addressDisplayName = "";
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ForkedDebuggerThread.this.myProject).getDebugProcess(handler);
                if (debugProcess instanceof DebugProcessImpl) {
                    addressDisplayName = "(" + JavaDebuggerBundle.getAddressDisplayName((RemoteConnection)((DebugProcessImpl)debugProcess).getConnection()) + ")";
                }
                String statusText = ExternalSystemBundle.message((String)"debugger.status.connected", (Object[])new Object[]{this.myProcessName, addressDisplayName});
                String linkText = ExternalSystemBundle.message((String)"debugger.open.session.tab", (Object[])new Object[0]);
                String debuggerAttachedStatusMessage = statusText + " " + linkText + "\n";
                mainConsoleView.print(debuggerAttachedStatusMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
                mainConsoleView.performWhenNoDeferredOutput(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int messageOffset = mainConsoleView.getText().indexOf(debuggerAttachedStatusMessage);
                    int linkStartOffset = messageOffset + debuggerAttachedStatusMessage.indexOf(linkText);
                    this.myHyperlink = hyperlinkSupport.createHyperlink(linkStartOffset, linkStartOffset + linkText.length(), null, project -> {
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject);
                        ContentManager contentManager = toolWindowManager.getToolWindow("Debug").getContentManager();
                        Content content = this.myDescriptor.getAttachedContent();
                        if (content != null) {
                            contentManager.setSelectedContent(content, true, true);
                        }
                    });
                });
            }
        }

        private void removeLink() {
            ConsoleViewImpl mainConsoleView;
            if (this.myHyperlink != null && (mainConsoleView = this.getMainConsoleView()) != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int startOffset = this.myHyperlink.getStartOffset();
                    int endOffset = this.myHyperlink.getEndOffset();
                    TextAttributes attributes = this.myHyperlink.getTextAttributes(mainConsoleView.getEditor().getColorsScheme());
                    TextAttributes inactiveTextAttributes = attributes != null ? attributes.clone() : TextAttributes.ERASE_MARKER.clone();
                    inactiveTextAttributes.setForegroundColor(NamedColorUtil.getInactiveTextColor());
                    inactiveTextAttributes.setEffectColor(NamedColorUtil.getInactiveTextColor());
                    inactiveTextAttributes.setFontType(2);
                    hyperlinkSupport.removeHyperlink(this.myHyperlink);
                    hyperlinkSupport.addHighlighter(startOffset, endOffset, inactiveTextAttributes, 5800);
                }, ForkedDebuggerThread.this.myProject.getDisposed());
            }
        }

        @Nullable
        private ConsoleViewImpl getMainConsoleView() {
            BuildView buildView;
            ExecutionConsole consoleView;
            ExecutionConsole executionConsole = ForkedDebuggerThread.this.myMainRunContentDescriptor.getExecutionConsole();
            if (executionConsole instanceof ConsoleViewImpl) {
                return (ConsoleViewImpl)executionConsole;
            }
            if (executionConsole instanceof BuildView && (consoleView = (buildView = (BuildView)executionConsole).getConsoleView()) instanceof ConsoleViewImpl) {
                ConsoleViewImpl o = (ConsoleViewImpl)consoleView;
                return o;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$MyForkedProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNotified";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

