/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.ConfigurationsCollector;
import com.intellij.testIntegration.RecentTestsDataKt;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestCollector;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SingleTestInfo;
import com.intellij.testIntegration.SuiteEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/testIntegration/RecentTestsData;", "", "<init>", "()V", "runConfigurationSuites", "Ljava/util/HashMap;", "", "Lcom/intellij/testIntegration/RunConfigurationEntry;", "Lkotlin/collections/HashMap;", "testsWithoutSuites", "Ljava/util/ArrayList;", "Lcom/intellij/testIntegration/SingleTestInfo;", "Lkotlin/collections/ArrayList;", "addSuite", "", "suite", "Lcom/intellij/testIntegration/SuiteEntry;", "moveSuiteTestsToSuite", "addTest", "test", "Lcom/intellij/testIntegration/SingleTestEntry;", "findRunConfigurationSuite", "url", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getTestsToShow", "", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "getFailedTests", "allConfigurations", "", "intellij.java.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRecentTestsData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentTestsData.kt\ncom/intellij/testIntegration/RecentTestsData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1915#2,2:108\n1915#2,2:110\n1915#2,2:112\n777#2:114\n873#2,2:115\n1586#2:117\n1661#2,3:118\n777#2:121\n873#2,2:122\n1080#2:124\n1915#2,2:125\n777#2:127\n873#2,2:128\n*S KotlinDebug\n*F\n+ 1 RecentTestsData.kt\ncom/intellij/testIntegration/RecentTestsData\n*L\n45#1:108,2\n71#1:110,2\n86#1:112,2\n87#1:114\n87#1:115,2\n89#1:117\n89#1:118,3\n89#1:121\n89#1:122,2\n91#1:124\n96#1:125,2\n97#1:127\n97#1:128,2\n*E\n"})
public final class RecentTestsData {
    @NotNull
    private final HashMap<String, RunConfigurationEntry> runConfigurationSuites = new HashMap();
    @NotNull
    private ArrayList<SingleTestInfo> testsWithoutSuites = new ArrayList();

    public final void addSuite(@NotNull SuiteEntry suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        this.moveSuiteTestsToSuite(suite);
        String string = suite.getRunConfiguration().getUniqueID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueID(...)");
        String id = string;
        RunConfigurationEntry entry = this.runConfigurationSuites.get(id);
        if (entry != null) {
            entry.addSuite(suite);
        } else {
            RunConfigurationEntry configurationEntry = new RunConfigurationEntry(suite.getRunConfiguration());
            configurationEntry.addSuite(suite);
            this.runConfigurationSuites.put(id, configurationEntry);
        }
    }

    private final void moveSuiteTestsToSuite(SuiteEntry suite) {
        RunnerAndConfigurationSettings suiteConfiguration = suite.getRunConfiguration();
        ArrayList<SingleTestInfo> filteredTests = new ArrayList<SingleTestInfo>();
        Iterable $this$forEach$iv = this.testsWithoutSuites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleTestInfo it = (SingleTestInfo)element$iv;
            boolean bl = false;
            if (RecentTestsDataKt.isMyTest(suite, it.getTest()) && Intrinsics.areEqual((Object)suiteConfiguration.getName(), (Object)it.getRunConfigurationName())) {
                suite.addTest(it.getTest());
                continue;
            }
            filteredTests.add(it);
        }
        this.testsWithoutSuites = filteredTests;
    }

    public final void addTest(@NotNull SingleTestEntry test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        SuiteEntry suiteEntry = this.findRunConfigurationSuite(test.getUrl(), test.getRunConfiguration());
        if (suiteEntry != null) {
            suiteEntry.addTest(test);
        } else {
            String string = test.getRunConfiguration().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.testsWithoutSuites.add(new SingleTestInfo(test, string));
        }
    }

    private final SuiteEntry findRunConfigurationSuite(String url, RunnerAndConfigurationSettings runConfiguration) {
        RunConfigurationEntry runConfigurationEntry = this.runConfigurationSuites.get(runConfiguration.getUniqueID());
        if (runConfigurationEntry == null) {
            return null;
        }
        RunConfigurationEntry pack = runConfigurationEntry;
        String string = VirtualFileManager.extractPath((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractPath(...)");
        String testName = string;
        Iterable $this$forEach$iv = pack.getSuites();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SuiteEntry it = (SuiteEntry)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)testName, (String)it.getSuiteName(), (boolean)false, (int)2, null)) continue;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RecentTestsPopupEntry> getTestsToShow() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv2;
        Object element$iv2;
        Collection<RunConfigurationEntry> collection = this.runConfigurationSuites.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<RunConfigurationEntry> allConfigurations = collection;
        List<SingleTestEntry> failedTests = this.getFailedTests(allConfigurations);
        ConfigurationsCollector configsCollector = new ConfigurationsCollector();
        Iterable $this$forEach$iv = allConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            RunConfigurationEntry it = (RunConfigurationEntry)element$iv2;
            boolean bl = false;
            it.accept(configsCollector);
        }
        Iterable $this$filter$iv2 = configsCollector.getEntries();
        boolean $i$f$filter22 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RecentTestsPopupEntry it = (RecentTestsPopupEntry)element$iv$iv;
            boolean bl = false;
            if (!(!it.getFailed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List passedConfigurations = (List)destination$iv$iv;
        Iterable $i$f$filter22 = this.testsWithoutSuites;
        Collection collection2 = CollectionsKt.plus((Collection)failedTests, (Iterable)passedConfigurations);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SingleTestInfo bl = (SingleTestInfo)item$iv$iv;
            Collection collection3 = destination$iv$iv2;
            boolean bl2 = false;
            collection3.add(it.getTest());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleTestEntry it = (SingleTestEntry)element$iv$iv;
            boolean bl = false;
            if (!it.getFailed()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List entriesToShow = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv2));
        Iterable $this$sortedByDescending$iv = entriesToShow;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RecentTestsPopupEntry it = (RecentTestsPopupEntry)b;
                boolean bl = false;
                Comparable comparable = it.getRunDate();
                it = (RecentTestsPopupEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getRunDate());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<SingleTestEntry> getFailedTests(Collection<RunConfigurationEntry> allConfigurations) {
        void $this$filterTo$iv$iv;
        SingleTestCollector testsCollector = new SingleTestCollector();
        Iterable $this$forEach$iv = allConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunConfigurationEntry it = (RunConfigurationEntry)element$iv;
            boolean bl = false;
            it.accept(testsCollector);
        }
        Iterable $this$filter$iv = testsCollector.getTests();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleTestEntry it = (SingleTestEntry)element$iv$iv;
            boolean bl = false;
            if (!it.getFailed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

