/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import com.intellij.testIntegration.RecentTestsData;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Unmodifiable;

public final class RecentTestsListProvider {
    private final Map<String, TestStateStorage.Record> myRecords;
    private final ConfigurationByRecordProvider myConfigurationProvider;

    public RecentTestsListProvider(ConfigurationByRecordProvider configurationProvider, Map<String, TestStateStorage.Record> records) {
        this.myRecords = records;
        this.myConfigurationProvider = configurationProvider;
    }

    public @Unmodifiable List<RecentTestsPopupEntry> getTestsToShow() {
        if (this.myRecords == null) {
            return ContainerUtil.emptyList();
        }
        RecentTestsData data = new RecentTestsData();
        for (Map.Entry<String, TestStateStorage.Record> entry : this.myRecords.entrySet()) {
            String url = entry.getKey();
            TestStateStorage.Record record = entry.getValue();
            if (!TestLocator.canLocate(url)) continue;
            this.handleUrl(data, url, record);
        }
        return data.getTestsToShow();
    }

    private void handleUrl(RecentTestsData data, String url, TestStateStorage.Record record) {
        TestStateInfo.Magnitude magnitude = RecentTestsListProvider.getMagnitude(record.magnitude);
        if (magnitude == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfiguration = this.myConfigurationProvider.getConfiguration(record);
        if (runConfiguration == null) {
            return;
        }
        if (TestLocator.isSuite(url)) {
            SuiteEntry entry = new SuiteEntry(url, record.date, runConfiguration);
            data.addSuite(entry);
        } else {
            SingleTestEntry entry = new SingleTestEntry(url, record.date, runConfiguration, magnitude);
            data.addTest(entry);
        }
    }

    private static TestStateInfo.Magnitude getMagnitude(int magnitude) {
        for (TestStateInfo.Magnitude m : TestStateInfo.Magnitude.values()) {
            if (m.getValue() != magnitude) continue;
            return m;
        }
        return null;
    }
}

