/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/testIntegration/SelectConfigurationStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "items", "", "runner", "Lcom/intellij/testIntegration/RecentTestRunner;", "<init>", "(Ljava/util/List;Lcom/intellij/testIntegration/RecentTestRunner;)V", "getTextFor", "", "value", "getIconFor", "Ljavax/swing/Icon;", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "", "intellij.java.execution.impl"})
public final class SelectConfigurationStep
extends BaseListPopupStep<RecentTestsPopupEntry> {
    @NotNull
    private final RecentTestRunner runner;

    public SelectConfigurationStep(@NotNull List<? extends RecentTestsPopupEntry> items, @NotNull RecentTestRunner runner) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        super(null, items);
        this.runner = runner;
    }

    @NotNull
    public String getTextFor(@NotNull RecentTestsPopupEntry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Ref.ObjectRef presentation = new Ref.ObjectRef();
        presentation.element = value.getPresentation();
        value.accept(new TestEntryVisitor((Ref.ObjectRef<String>)presentation){
            final /* synthetic */ Ref.ObjectRef<String> $presentation;
            {
                this.$presentation = $presentation;
            }

            public void visitSuite(SuiteEntry suite) {
                Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
                Object[] objectArray = new Object[]{this.$presentation.element};
                String string = JavaBundle.message((String)"list.item.suite", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.$presentation.element = string;
            }

            public void visitRunConfiguration(RunConfigurationEntry configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Object[] objectArray = new Object[]{this.$presentation.element};
                String string = JavaBundle.message((String)"list.item.configuration", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.$presentation.element = string;
            }
        });
        return (String)presentation.element;
    }

    @NotNull
    public Icon getIconFor(@Nullable RecentTestsPopupEntry value) {
        Icon icon = AllIcons.RunConfigurations.Junit;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Junit");
        return icon;
    }

    @Nullable
    public PopupStep<RecentTestsPopupEntry> onChosen(@NotNull RecentTestsPopupEntry selectedValue, boolean finalChoice) {
        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
        if (finalChoice) {
            this.runner.run(selectedValue);
        }
        return null;
    }
}

