/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"isPrettierFormattingAllowedFor", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkIsInContent", "findPrettierScopeRootFor", "intellij.prettierJS"})
public final class PrettierFormattingScopeKt {
    public static final boolean isPrettierFormattingAllowedFor(@NotNull Project project, @NotNull VirtualFile file, boolean checkIsInContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)prettierConfiguration, (String)"getInstance(...)");
        PrettierConfiguration config = prettierConfiguration;
        if (checkIsInContent && !ProjectFileIndex.getInstance((Project)project).isInContent(file)) {
            return false;
        }
        if (!GlobPatternUtil.isFileMatchingGlobPattern((Project)project, (String)config.getFilesPattern(), (VirtualFile)file)) {
            return false;
        }
        if (!config.getFormatFilesOutsideDependencyScope()) {
            return PrettierFormattingScopeKt.findPrettierScopeRootFor(project, file) != null;
        }
        return true;
    }

    public static /* synthetic */ boolean isPrettierFormattingAllowedFor$default(Project project, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return PrettierFormattingScopeKt.isPrettierFormattingAllowedFor(project, virtualFile, bl);
    }

    @Nullable
    public static final VirtualFile findPrettierScopeRootFor(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile startDir;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = startDir = file.isDirectory() ? file : file.getParent();
        if (startDir == null) {
            return null;
        }
        VirtualFile virtualFile2 = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(file);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile baseDir = virtualFile2;
        for (VirtualFile currentDir = startDir; currentDir != null && currentDir.isValid() && currentDir.isDirectory(); currentDir = currentDir.getParent()) {
            VirtualFile prettierConfigFile;
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)currentDir);
            if (packageJson != null) {
                PackageJsonData data;
                Intrinsics.checkNotNullExpressionValue((Object)PackageJsonData.getOrCreate((VirtualFile)packageJson), (String)"getOrCreate(...)");
                if (data.isDependencyOfAnyType("prettier")) {
                    return currentDir;
                }
            }
            if ((prettierConfigFile = PrettierUtil.findChildConfigFile(currentDir)) != null) {
                return currentDir;
            }
            if (Intrinsics.areEqual((Object)baseDir, (Object)currentDir)) break;
        }
        return null;
    }
}

