/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AbstractFunctionReferenceLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.common.lower.UpgradeCallableReferencesKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.BoundValue;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.IndyCallData;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArguments;
import org.jetbrains.kotlin.backend.jvm.lower.indy.LambdaMetafactoryArgumentsBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.indy.MetafactoryArgumentsResult;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBlock;
import org.jetbrains.kotlin.backend.jvm.lower.indy.SamDelegatingLambdaBuilder;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrTypeParameterBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMetadataSourceOwner;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0002-.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u001c\u001a\u00020\f*\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\fH\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0018\u0010\u0010\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "crossinlineLambdas", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "isInlineLambda", "", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;)Z", "isSuspendLambda", "isIgnored", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldGenerateIndySamConversions", "shouldGenerateIndyLambdas", "getShouldGenerateIndyLambdas", "()Z", "shouldGenerateLightweightLambdas", "getShouldGenerateLightweightLambdas", "isJavaSamConversionWithEqualsHashCode", "isSamConversion", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "setIndyDataIfPossible", "plainLambda", "getDeclarationParentForDelegatingLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "canGenerateIndySamConversionOnFunctionalExpression", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "FunctionReferenceBuilder", "Companion", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n+ 2 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocatorKt\n+ 3 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,635:1\n265#2,2:636\n281#2,2:638\n47#3,4:640\n2792#4,3:644\n245#5:647\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering\n*L\n70#1:636,2\n70#1:638,2\n75#1:640,4\n88#1:644,3\n116#1:647\n*E\n"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashSet<IrSimpleFunction> crossinlineLambdas;
    private final boolean shouldGenerateIndySamConversions;
    private final boolean isJavaSamConversionWithEqualsHashCode;

    public FunctionReferenceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.crossinlineLambdas = new HashSet();
        this.shouldGenerateIndySamConversions = this.context.getConfig().getSamConversionsScheme() == JvmClosureGenerationScheme.INDY;
        this.isJavaSamConversionWithEqualsHashCode = this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.JavaSamConversionEqualsHashCode);
    }

    private final boolean isInlineLambda(IrRichFunctionReference $this$isInlineLambda) {
        return Intrinsics.areEqual((Object)$this$isInlineLambda.getOrigin(), (Object)IrStatementOrigin.Companion.getINLINE_LAMBDA());
    }

    private final boolean isSuspendLambda(IrRichFunctionReference $this$isSuspendLambda) {
        return $this$isSuspendLambda.getInvokeFunction().isSuspend() && IrUtilsKt.isLambda((IrStatementOrigin)$this$isSuspendLambda.getOrigin()) && IrTypeUtilsKt.isSuspendFunctionOrKFunction((IrType)$this$isSuspendLambda.getType());
    }

    private final boolean isIgnored(IrRichFunctionReference $this$isIgnored) {
        return this.isSuspendLambda($this$isIgnored) || this.isInlineLambda($this$isIgnored);
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrFile irFile) {
        void this_$iv;
        IrElementTransformerVoidWithContext $this$findRichInlineLambdas$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrFile irFile2 = irFile;
        JvmBackendContext context$iv = this.context;
        boolean $i$f$findRichInlineLambdas = false;
        $this$findRichInlineLambdas$iv.accept((IrVisitor)new IrInlineReferenceLocator(context$iv, this){
            final /* synthetic */ FunctionReferenceLowering this$0;
            {
                this.this$0 = functionReferenceLowering;
                super($context);
            }

            public void visitInlineLambda(IrFunctionReference argument, IrFunction callee, IrValueParameter parameter, IrDeclaration scope) {
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            }

            /*
             * WARNING - void declaration
             */
            public void visitInlineLambda(IrRichFunctionReference argument, IrFunction callee, IrValueParameter parameter, IrDeclaration scope) {
                void parameter2;
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                IrValueParameter irValueParameter = parameter;
                IrRichFunctionReference argument2 = argument;
                boolean bl = false;
                if (parameter2.isCrossinline()) {
                    FunctionReferenceLowering.access$getCrossinlineLambdas$p(this.this$0).add(argument2.getInvokeFunction());
                }
            }
        }, null);
        $this$findRichInlineLambdas$iv = this;
        IrSymbolOwner declaration$iv = (IrSymbolOwner)irFile;
        boolean $i$f$withinScope = false;
        IrElementTransformerVoidWithContext.access$unsafeEnterScope((IrElementTransformerVoidWithContext)this_$iv, (IrSymbolOwner)declaration$iv);
        boolean bl = false;
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        Unit result$iv = Unit.INSTANCE;
        IrElementTransformerVoidWithContext.access$unsafeLeaveScope((IrElementTransformerVoidWithContext)this_$iv);
        this.crossinlineLambdas.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldGenerateIndyLambdas() {
        IrMetadataSourceOwner irMetadataSourceOwner;
        if (this.context.getConfig().getLambdasScheme() != JvmClosureGenerationScheme.INDY) return false;
        Iterable $this$none$iv = this.getAllScopes();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ScopeWithIr it = (ScopeWithIr)element$iv;
            boolean bl = false;
            IrElement irElement = it.getIrElement();
            irMetadataSourceOwner = irElement instanceof IrMetadataSourceOwner ? (IrMetadataSourceOwner)irElement : null;
        } while (!((irMetadataSourceOwner != null ? irMetadataSourceOwner.getMetadata() : null) instanceof MetadataSource.CodeFragment));
        return false;
    }

    private final boolean getShouldGenerateLightweightLambdas() {
        return this.getShouldGenerateIndyLambdas() && this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.LightweightLambdas);
    }

    private final boolean isSamConversion(IrRichFunctionReference $this$isSamConversion) {
        return !IrTypeUtilsKt.isFunctionOrKFunction((IrType)$this$isSamConversion.getType()) && !IrTypeUtilsKt.isSuspendFunctionOrKFunction((IrType)$this$isSamConversion.getType());
    }

    @NotNull
    public IrExpression visitRichFunctionReference(@NotNull IrRichFunctionReference expression2) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        if (this.isIgnored(expression2)) {
            return (IrExpression)expression2;
        }
        for (IrValueParameter parameter : expression2.getInvokeFunction().getParameters()) {
            if (!Intrinsics.areEqual((Object)parameter.getOrigin(), (Object)UpgradeCallableReferencesKt.getLAMBDA_EXTENSION_RECEIVER())) continue;
            parameter.setOrigin(IrDeclarationOrigin.Companion.getDEFINED());
        }
        if (this.getShouldGenerateIndyLambdas() && IrUtilsKt.isLambda((IrStatementOrigin)expression2.getOrigin()) && !this.isSamConversion(expression2) && this.setIndyDataIfPossible(expression2, true)) {
            return (IrExpression)expression2;
        }
        if (this.shouldGenerateIndySamConversions && this.isSamConversion(expression2) && this.setIndyDataIfPossible(expression2, false)) {
            return (IrExpression)expression2;
        }
        boolean condition$iv = this.isSamConversion(expression2);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            irType = JvmIrUtilsKt.rawType(IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expression2.getType()), this.context);
        } else {
            irType = null;
        }
        IrType samSuperType = irType;
        return new FunctionReferenceBuilder(this, expression2, samSuperType).build();
    }

    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isFun() || IrTypeUtilsKt.isSuspendFunction((IrClassifierSymbol)((IrClassifierSymbol)declaration.getSymbol())) || IrTypeUtilsKt.isKSuspendFunction((IrClassifierSymbol)((IrClassifierSymbol)declaration.getSymbol()))) {
            AbstractFunctionReferenceLoweringKt.setDeclarationsAtFunctionReferenceLowering((IrClass)declaration, (List)CollectionsKt.toList((Iterable)declaration.getDeclarations()));
        }
        this.transformChildrenVoid((IrElement)declaration);
        return (IrStatement)declaration;
    }

    private final boolean setIndyDataIfPossible(IrRichFunctionReference expression2, boolean plainLambda) {
        boolean bl;
        MetafactoryArgumentsResult lambdaMetafactoryArguments = new LambdaMetafactoryArgumentsBuilder(this.context, (Set<? extends IrSimpleFunction>)this.crossinlineLambdas).getLambdaMetafactoryArguments(expression2, plainLambda, false);
        if (lambdaMetafactoryArguments instanceof LambdaMetafactoryArguments) {
            FunctionReferenceLoweringKt.access$setIndyCallData(expression2, new IndyCallData(((LambdaMetafactoryArguments)lambdaMetafactoryArguments).getShouldBeSerializable(), plainLambda));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final IrDeclarationParent getDeclarationParentForDelegatingLambda() {
        for (ScopeWithIr s : CollectionsKt.asReversedMutable((List)this.getAllScopes())) {
            IrSymbolOwner scopeOwner = s.getScope().getScopeOwnerSymbol().getOwner();
            if (!(scopeOwner instanceof IrDeclarationParent)) continue;
            return (IrDeclarationParent)scopeOwner;
        }
        throw new AssertionError((Object)("No IrDeclarationParent found in scopes:\n" + CollectionsKt.joinToString$default((Iterable)this.getAllScopes(), (CharSequence)"\n", null, null, (int)0, null, FunctionReferenceLowering::getDeclarationParentForDelegatingLambda$lambda$0, (int)30, null)));
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid((IrElement)expression2);
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return (IrExpression)expression2;
        }
        IrType samSuperType = expression2.getTypeOperand();
        IrExpression invokable = expression2.getArgument();
        if (this.shouldGenerateIndySamConversions && this.canGenerateIndySamConversionOnFunctionalExpression(samSuperType)) {
            SamDelegatingLambdaBuilder samDelegatingLambdaBuilder = new SamDelegatingLambdaBuilder(this.context);
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            SamDelegatingLambdaBlock lambdaBlock = samDelegatingLambdaBuilder.build(invokable, samSuperType, scopeWithIr.getScope().getScopeOwnerSymbol(), this.getDeclarationParentForDelegatingLambda());
            if (this.setIndyDataIfPossible(lambdaBlock.getRef(), false)) {
                IrExpression argument;
                IndyCallData indyCallData = FunctionReferenceLoweringKt.getIndyCallData(lambdaBlock.getRef());
                boolean bl = indyCallData != null ? indyCallData.getForceSerializability() : false;
                if (bl && invokable instanceof IrTypeOperatorCall && ((IrTypeOperatorCall)invokable).getOperator() == IrTypeOperator.IMPLICIT_CAST && (argument = ((IrTypeOperatorCall)invokable).getArgument()) instanceof IrRichFunctionReference) {
                    IndyCallData indyCallData2 = FunctionReferenceLoweringKt.getIndyCallData((IrRichFunctionReference)argument);
                    FunctionReferenceLoweringKt.access$setIndyCallData((IrRichFunctionReference)argument, indyCallData2 != null ? IndyCallData.copy$default(indyCallData2, true, false, 2, null) : null);
                }
                return lambdaBlock.getRootExpression();
            }
        }
        return (IrExpression)expression2;
    }

    private final boolean canGenerateIndySamConversionOnFunctionalExpression(IrType samSuperType) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)samSuperType);
        if (irClassSymbol == null) {
            throw new AssertionError((Object)("Class type expected: " + RenderIrElementKt.render$default((IrType)samSuperType, null, (int)1, null)));
        }
        IrClassSymbol samClass = irClassSymbol;
        return IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)samClass.getOwner())) && !this.isJavaSamConversionWithEqualsHashCode;
    }

    private static final CharSequence getDeclarationParentForDelegatingLambda$lambda$0(ScopeWithIr it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + RenderIrElementKt.render$default((IrElement)((IrElement)it.getScope().getScopeOwnerSymbol().getOwner()), null, (int)1, null);
    }

    public static final /* synthetic */ HashSet access$getCrossinlineLambdas$p(FunctionReferenceLowering $this) {
        return $this.crossinlineLambdas;
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0019\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "<init>", "()V", "calculateOwnerKClass", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "calculateOwnerKClass$backend_jvm_lower", "getReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getReceiverField$backend_jvm_lower", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,635:1\n75#2,4:636\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion\n*L\n618#1:636,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm_lower(@NotNull JvmIrBuilder $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$calculateOwnerKClass), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            return (IrExpression)JvmIrUtilsKt.kClassReference($this$calculateOwnerKClass, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(irContainer, $this$calculateOwnerKClass.getBackendContext()));
        }

        @NotNull
        public final IrField getReceiverField$backend_jvm_lower(@NotNull IrClass $this$getReceiverField, @NotNull JvmBackendContext context) {
            IrField irField;
            Intrinsics.checkNotNullParameter((Object)$this$getReceiverField, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            IrFactory $this$buildField$iv = context.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$getReceiverField_u24lambda_u240 = $this$buildField_u24lambda_u241$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"receiver");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            $this$getReceiverField_u24lambda_u240.setName(name);
            $this$getReceiverField_u24lambda_u240.setType(context.getIrBuiltIns().getAnyNType());
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
            $this$getReceiverField_u24lambda_u240.setVisibility(descriptorVisibility);
            IrField $this$getReceiverField_u24lambda_u241 = irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u241$iv);
            boolean bl3 = false;
            $this$getReceiverField_u24lambda_u241.setParent((IrDeclarationParent)$this$getReceiverField);
            return irField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u00182\u0006\u0010*\u001a\u00020!H\u0002J\u0006\u0010+\u001a\u00020\u0016J\u001a\u0010,\u001a\u00020-*\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0018H\u0002J\b\u00101\u001a\u000202H\u0002J3\u00103\u001a\u00020-*\u00020.2\u0006\u00104\u001a\u0002052\u001d\u00106\u001a\u0019\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001607\u00a2\u0006\u0002\b:H\u0002J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020\u001bH\u0002J\b\u0010=\u001a\u000209H\u0002J\u0016\u0010>\u001a\u00020\r2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u0018H\u0002J\u0014\u0010E\u001a\u00020\u0016*\u00020.2\u0006\u0010F\u001a\u00020GH\u0002J\u0014\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020J0IH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010A\u001a\u00020B*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isLambda", "", "isLightweightLambda", "isHeavyweightLambda", "isSuspend", "boundReceivers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "parameterTypes", "", "argumentTypes", "adaptedReferenceOriginalTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isFunInterfaceConstructorReference", "constructedFunInterfaceSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isAdaptedReference", "samInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isKotlinFunInterface", "needToGenerateSamEqualsHashCodeMethods", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "functionReferenceClass", "createFakeFormalTypeParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "sourceTypeParameters", "irClass", "build", "generateSamEqualsHashCodeMethods", "", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "boundReceiverVars", "Lorg/jetbrains/kotlin/backend/jvm/lower/BoundValue$StoredInVariable;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "generateConstructorCallArguments", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateBoundReceiver", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getFunctionReferenceFlags", "callableReferenceTarget", "getAdaptedCallableReferenceFlags", "createInvokeMethod", "boundValues", "Lorg/jetbrains/kotlin/backend/jvm/lower/BoundValue;", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "createFakeBoundReceiverForJvmStaticInObject", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nFunctionReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 9 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,635:1\n1586#2:636\n1661#2,3:637\n1586#2:645\n1661#2,2:646\n1663#2:652\n1300#2,2:653\n1315#2,4:655\n1586#2:659\n1661#2,3:660\n1586#2:678\n1661#2,3:679\n1586#2:682\n1661#2,3:683\n1586#2:732\n1661#2,3:733\n1586#2:736\n1661#2,3:737\n1586#2:740\n1661#2,3:741\n1586#2:744\n1661#2,3:745\n1596#2:748\n1629#2,4:749\n245#3:640\n290#3:753\n51#4,4:641\n406#4,4:648\n321#4:687\n315#4,13:688\n281#4:720\n275#4:721\n269#4,10:722\n363#4,4:766\n409#5,13:663\n453#5,5:713\n448#5,10:754\n133#6:676\n134#6:686\n1#7:677\n351#8,12:701\n351#8,12:770\n76#9,2:718\n76#9,2:764\n*S KotlinDebug\n*F\n+ 1 FunctionReferenceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder\n*L\n211#1:636\n211#1:637,3\n297#1:645\n297#1:646,2\n297#1:652\n303#1:653,2\n303#1:655,4\n306#1:659\n306#1:660,3\n322#1:678\n322#1:679,3\n329#1:682\n329#1:683,3\n492#1:732\n492#1:733,3\n493#1:736\n493#1:737,3\n508#1:740\n508#1:741,3\n509#1:744\n509#1:745,3\n514#1:748\n514#1:749,4\n241#1:640\n530#1:753\n253#1:641,4\n298#1:648,4\n368#1:687\n368#1:688,13\n474#1:720\n474#1:721\n474#1:722,10\n598#1:766,4\n313#1:663,13\n406#1:713,5\n531#1:754,10\n313#1:676\n313#1:686\n399#1:701,12\n357#1:770,12\n406#1:718,2\n531#1:764,2\n*E\n"})
    private final class FunctionReferenceBuilder {
        @NotNull
        private final IrRichFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        @NotNull
        private final IrSimpleFunction callee;
        private final boolean isLambda;
        private final boolean isLightweightLambda;
        private final boolean isHeavyweightLambda;
        private final boolean isSuspend;
        @NotNull
        private final Map<IrValueParameter, IrExpression> boundReceivers;
        @NotNull
        private final List<IrType> parameterTypes;
        @NotNull
        private final List<IrType> argumentTypes;
        @Nullable
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isFunInterfaceConstructorReference;
        @Nullable
        private final IrClassSymbol constructedFunInterfaceSymbol;
        private final boolean isAdaptedReference;
        @Nullable
        private final IrClass samInterface;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        @Nullable
        private final IrSimpleType superClass;
        @NotNull
        private final IrClass functionReferenceClass;
        final /* synthetic */ FunctionReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@NotNull FunctionReferenceLowering this$0, @Nullable IrRichFunctionReference irFunctionReference, IrType samSuperType) {
            boolean bl;
            void $this$functionReferenceClass_u24lambda_u241_u240;
            List list;
            void $this$functionReferenceClass_u24lambda_u241;
            void $this$functionReferenceClass_u24lambda_u240;
            IrSimpleType irSimpleType;
            void condition$iv;
            IrClassSymbol irClassSymbol;
            Object object;
            IrFunctionSymbol $this$mapTo$iv$iv;
            void $this$map$iv22;
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.callee = this.irFunctionReference.getInvokeFunction();
            this.isLambda = IrUtilsKt.isLambda((IrStatementOrigin)this.irFunctionReference.getOrigin());
            this.isLightweightLambda = this.isLambda && this.this$0.getShouldGenerateLightweightLambdas() && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)this.callee), (FqName)JvmStandardClassIds.JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME);
            this.isHeavyweightLambda = this.isLambda && !this.isLightweightLambda;
            this.isSuspend = IrUtilsKt.isSuspend((IrSymbol)((IrSymbol)this.irFunctionReference.getOverriddenFunctionSymbol()));
            this.boundReceivers = JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)this.callee) ? MapsKt.mapOf(this.createFakeBoundReceiverForJvmStaticInObject()) : MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.irFunctionReference.getInvokeFunction().getParameters(), (Iterable)this.irFunctionReference.getBoundValues()));
            IrType irType = this.irFunctionReference.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Iterable iterable = ((IrSimpleType)irType).getArguments();
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map = false;
            void var7_15 = $this$map$iv22;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrType irType2;
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var14_28 = it;
                if (var14_28 instanceof IrTypeProjection) {
                    irType2 = ((IrTypeProjection)it).getType();
                } else if (var14_28 instanceof IrStarProjection) {
                    irType2 = functionReferenceLowering.context.getIrBuiltIns().getAnyNType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(irType2);
            }
            functionReferenceBuilder.parameterTypes = (List)destination$iv$iv;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            FunctionReferenceBuilder functionReferenceBuilder2 = this;
            IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)this.irFunctionReference.getReflectionTargetSymbol();
            if (irFunctionSymbol != null && (irFunctionSymbol = irFunctionSymbol.getOwner()) != null) {
                $this$mapTo$iv$iv = $i$f$map = irFunctionSymbol;
                functionReferenceBuilder = functionReferenceBuilder2;
                boolean bl3 = false;
                boolean bl4 = Intrinsics.areEqual((Object)this.irFunctionReference.getInvokeFunction().getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE());
                functionReferenceBuilder2 = functionReferenceBuilder;
                object = bl4 ? $i$f$map : null;
            } else {
                object = null;
            }
            functionReferenceBuilder2.adaptedReferenceOriginalTarget = object;
            this.isFunInterfaceConstructorReference = Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_FUN_INTERFACE_CONSTRUCTOR());
            if (this.isFunInterfaceConstructorReference) {
                irClassSymbol = IrTypesKt.getClassOrNull((IrType)this.callee.getReturnType());
                if (irClassSymbol == null) {
                    throw new AssertionError((Object)("Fun interface type expected: " + RenderIrElementKt.render$default((IrType)this.callee.getReturnType(), null, (int)1, null)));
                }
            } else {
                irClassSymbol = null;
            }
            this.constructedFunInterfaceSymbol = irClassSymbol;
            this.isAdaptedReference = this.isFunInterfaceConstructorReference || Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getADAPTER_FOR_CALLABLE_REFERENCE());
            IrType irType3 = this.samSuperType;
            this.samInterface = irType3 != null ? IrTypesKt.getClass((IrType)irType3) : null;
            this.isKotlinFunInterface = this.samInterface != null && !IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)this.samInterface));
            this.needToGenerateSamEqualsHashCodeMethods = !(!this.isKotlinFunInterface && !this.this$0.isJavaSamConversionWithEqualsHashCode || !this.isAdaptedReference && this.isLambda);
            FunctionReferenceBuilder functionReferenceBuilder3 = this;
            boolean $this$map$iv22 = this.samSuperType == null;
            functionReferenceLowering = this.this$0;
            boolean $i$f$runIf = false;
            if (condition$iv != false) {
                functionReferenceBuilder = functionReferenceBuilder3;
                boolean bl5 = false;
                irSimpleType = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)(this.isLightweightLambda ? functionReferenceLowering.context.getIrBuiltIns().getAnyClass() : (this.isHeavyweightLambda ? functionReferenceLowering.context.getSymbols().getLambdaClass() : (this.isFunInterfaceConstructorReference ? functionReferenceLowering.context.getSymbols().getFunInterfaceConstructorReferenceClass() : (this.isAdaptedReference ? functionReferenceLowering.context.getSymbols().getAdaptedFunctionReference() : functionReferenceLowering.context.getSymbols().getFunctionReferenceImpl()))))));
                functionReferenceBuilder3 = functionReferenceBuilder;
            } else {
                irSimpleType = null;
            }
            functionReferenceBuilder3.superClass = irSimpleType;
            IrFactory $this$buildClass$iv = this.this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl6 = false;
            IrClassBuilder bl3 = $this$buildClass_u24lambda_u241$iv;
            functionReferenceBuilder = this;
            boolean $i$a$-buildClass-FunctionReferenceLowering$FunctionReferenceBuilder$functionReferenceClass$22 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$functionReferenceClass_u24lambda_u240), (IrElement)((IrElement)this.irFunctionReference));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
            $this$functionReferenceClass_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$functionReferenceClass_u24lambda_u240.setOrigin(this.isLambda ? JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL() : JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL());
            $this$functionReferenceClass_u24lambda_u240.setName(SpecialNames.NO_NAME_PROVIDED);
            IrClass irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            FunctionReferenceLowering functionReferenceLowering2 = this.this$0;
            $this$buildClass_u24lambda_u241$iv = irClass;
            boolean bl7 = false;
            IrDeclarationParent irDeclarationParent = functionReferenceLowering2.getCurrentDeclarationParent();
            if (irDeclarationParent == null) {
                throw new IllegalStateException(("No current declaration parent at " + DumpIrTreeKt.dump$default((IrElement)((IrElement)this.irFunctionReference), null, (int)1, null)).toString());
            }
            $this$functionReferenceClass_u24lambda_u241.setParent(irDeclarationParent);
            List $i$a$-buildClass-FunctionReferenceLowering$FunctionReferenceBuilder$functionReferenceClass$22 = list = CollectionsKt.createListBuilder();
            Iterator iterator2 = $this$functionReferenceClass_u24lambda_u241;
            boolean bl8 = false;
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)((Collection)$this$functionReferenceClass_u24lambda_u241_u240), (Object)this.superClass);
            if (this.samSuperType != null) {
                bl = $this$functionReferenceClass_u24lambda_u241_u240.add(this.samSuperType);
            } else {
                IrClassSymbol functionClassSymbol = this.irFunctionReference.getInvokeFunction().isSuspend() ? functionReferenceLowering2.context.getIrBuiltIns().suspendFunctionN(this.argumentTypes.size()).getSymbol() : functionReferenceLowering2.context.getIrBuiltIns().functionN(this.argumentTypes.size()).getSymbol();
                bl = $this$functionReferenceClass_u24lambda_u241_u240.add(IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)functionClassSymbol), this.parameterTypes));
            }
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                $this$functionReferenceClass_u24lambda_u241_u240.add(IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)functionReferenceLowering2.context.getSymbols().getFunctionAdapter())));
            }
            iterator2.setSuperTypes(CollectionsKt.build((List)list));
            if (this.samInterface != null && Intrinsics.areEqual((Object)$this$functionReferenceClass_u24lambda_u241.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL())) {
                $this$functionReferenceClass_u24lambda_u241.setTypeParameters(this.createFakeFormalTypeParameters(this.samInterface.getTypeParameters(), (IrClass)$this$functionReferenceClass_u24lambda_u241));
            }
            IrUtilsKt.createThisReceiverParameter((IrClass)$this$functionReferenceClass_u24lambda_u241);
            IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$functionReferenceClass_u24lambda_u241), (IrElement)((IrElement)this.irFunctionReference), (boolean)false, (int)2, null);
            if (this.isHeavyweightLambda) {
                $this$functionReferenceClass_u24lambda_u241.setMetadata(this.callee.getMetadata());
            }
            functionReferenceBuilder.functionReferenceClass = irClass;
        }

        public /* synthetic */ FunctionReferenceBuilder(FunctionReferenceLowering functionReferenceLowering, IrRichFunctionReference irRichFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(functionReferenceLowering, irRichFunctionReference, irType);
        }

        @NotNull
        public final IrRichFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrTypeParameter> createFakeFormalTypeParameters(List<? extends IrTypeParameter> sourceTypeParameters, IrClass irClass) {
            Iterable $this$associateWithTo$iv$iv;
            IrTypeParameterBuilder $this$buildTypeParameter_u24lambda_u241$iv;
            IrTypeParametersContainer parent$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            if (sourceTypeParameters.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = sourceTypeParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                parent$iv = (IrTypeParametersContainer)irClass;
                boolean $i$f$buildTypeParameter = false;
                $this$buildTypeParameter_u24lambda_u241$iv = new IrTypeParameterBuilder();
                boolean bl2 = false;
                IrTypeParameterBuilder $this$createFakeFormalTypeParameters_u24lambda_u240_u240 = $this$buildTypeParameter_u24lambda_u241$iv;
                boolean bl3 = false;
                $this$createFakeFormalTypeParameters_u24lambda_u240_u240.updateFrom((IrTypeParameter)it);
                $this$createFakeFormalTypeParameters_u24lambda_u240_u240.setName(it.getName());
                collection.add(DeclarationBuildersKt.buildTypeParameter((IrFactory)parent$iv.getFactory(), (IrTypeParameterBuilder)$this$buildTypeParameter_u24lambda_u241$iv, (IrDeclarationParent)((IrDeclarationParent)parent$iv)));
            }
            List fakeTypeParameters = (List)destination$iv$iv;
            Iterable $this$associateWith$iv = sourceTypeParameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $i$f$mapTo22 = $this$associateWith$iv;
            Map destination$iv$iv2 = result$iv;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                parent$iv = (IrTypeParameter)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl = false;
                IrTypeParameter irTypeParameter = (IrTypeParameter)fakeTypeParameters.get(it.getIndex());
                map.put(t, irTypeParameter);
            }
            Map map = destination$iv$iv2;
            IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(map);
            for (IrTypeParameter fakeTypeParameter : fakeTypeParameters) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                IrTypeParameter sourceTypeParameter = sourceTypeParameters.get(fakeTypeParameter.getIndex());
                $this$associateWithTo$iv$iv = sourceTypeParameter.getSuperTypes();
                collection = fakeTypeParameter;
                boolean $i$f$map2 = false;
                void $i$f$associateWithTo2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    $this$buildTypeParameter_u24lambda_u241$iv = (IrType)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl = false;
                    collection2.add(typeRemapper.remapType((IrType)it));
                }
                collection.setSuperTypes((List)destination$iv$iv3);
            }
            return fakeTypeParameters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            List boundValues;
            Collection collection;
            Object $this$map$iv;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            JvmBackendContext jvmBackendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder $this$build_u24lambda_u240 = JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr);
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$build_u24lambda_u240;
            int n = this.irFunctionReference.getStartOffset();
            int endOffset$iv = this.irFunctionReference.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$build_u24lambda_u240_u240 = this_$iv$iv;
            boolean bl2 = false;
            IrConstructor constructor = this.createConstructor();
            if (!(this.irFunctionReference.getBoundValues().size() <= 1)) {
                boolean $i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$build$1$1$22 = false;
                String $i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$build$1$1$22 = "Function references with multiple bound values are not supported yet";
                throw new IllegalArgumentException($i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$build$1$1$22.toString());
            }
            $this$build_u24lambda_u240_u240.unaryPlus((IrStatement)this.functionReferenceClass);
            if (this.samSuperType != null) {
                void $this$mapTo$iv$iv;
                $this$map$iv = this.irFunctionReference.getBoundValues();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new BoundValue.StoredInVariable(ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$build_u24lambda_u240_u240), (IrExpression)it, null, null, (boolean)false, null, (int)30, null)));
                }
                boundValues = (List)destination$iv$iv;
                this.createInvokeMethod(boundValues);
                if (this.needToGenerateSamEqualsHashCodeMethods) {
                    this.generateSamEqualsHashCodeMethods($this$build_u24lambda_u240, boundValues);
                }
                $this$build_u24lambda_u240_u240.unaryPlus((IrStatement)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$build_u24lambda_u240_u240), (IrConstructorSymbol)constructor.getSymbol()));
            } else {
                void $this$build_u24lambda_u240_u240_u243;
                $this$map$iv = this.irFunctionReference.getBoundValues();
                boolean $i$f$map22 = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IrExpression it = (IrExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(new BoundValue.StoredInField(Companion.getReceiverField$backend_jvm_lower(this.functionReferenceClass, $this$build_u24lambda_u240.getBackendContext())));
                }
                boundValues = (List)destination$iv$iv;
                this.createInvokeMethod(boundValues);
                $this$map$iv = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$build_u24lambda_u240_u240), (IrConstructorSymbol)constructor.getSymbol());
                Iterable $i$f$map22 = $this$map$iv;
                collection = $this$build_u24lambda_u240_u240;
                boolean bl5 = false;
                AddToStdlibKt.assignFrom((List)((List)$this$build_u24lambda_u240_u240_u243.getArguments()), (Collection)this.irFunctionReference.getBoundValues());
                collection.unaryPlus((IrStatement)$this$map$iv);
            }
            if (this.isKotlinFunInterface) {
                Map map = MapsKt.createMapBuilder();
                $this$map$iv = map;
                IrTypeSystemContext irTypeSystemContext = $this$build_u24lambda_u240.getBackendContext().getTypeSystem();
                collection = this.functionReferenceClass;
                boolean bl6 = false;
                Object object = this.samInterface;
                if (object != null && (object = AbstractFunctionReferenceLoweringKt.getDeclarationsAtFunctionReferenceLowering((IrClass)object)) != null) {
                    void $this$build_u24lambda_u240_u240_u244;
                    Object it = object;
                    boolean bl7 = false;
                    $this$build_u24lambda_u240_u240_u244.put(this.samInterface, it);
                }
                Unit unit = Unit.INSTANCE;
                IrUtilsKt.addFakeOverrides((IrClass)collection, (IrTypeSystemContext)irTypeSystemContext, (Map)MapsKt.build((Map)map));
            }
            return (IrExpression)this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, List<BoundValue.StoredInVariable> boundReceiverVars) {
            if (this.samSuperType == null) {
                boolean bl = false;
                String string = "equals/hashCode can only be generated for fun interface wrappers: " + RenderIrElementKt.render$default((IrElement)((IrElement)this.callee), null, (int)1, null);
                throw new IllegalStateException(string.toString());
            }
            new SamEqualsHashCodeMethodsGenerator((CommonBackendContext)$this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (arg_0, arg_1) -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$1(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVars, arg_0, arg_1)).generate();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$createConstructor_u24lambda_u241_u241;
            IrConstructor it;
            int found$iv;
            Object single$iv;
            Object $this$single$iv;
            IrConstructor irConstructor;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
            int n = 0;
            IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
            boolean bl = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$createConstructor_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_MEMBER_IN_CALLABLE_REFERENCE());
            $this$createConstructor_u24lambda_u240.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)this.functionReferenceClass));
            $this$createConstructor_u24lambda_u240.setPrimary(true);
            $this$addConstructor_u24lambda_u240$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
            IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u241$iv$iv);
            boolean bl3 = false;
            $this$addConstructor$iv.getDeclarations().add(constructor$iv);
            constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
            IrFactory irFactory = $this$buildConstructor$iv$iv;
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            IrFactory $this$createConstructor_u24lambda_u241 = irFactory;
            boolean bl4 = false;
            if (this.samSuperType == null) {
                n = ((Collection)this.boundReceivers.entrySet()).size();
                for (int index = 0; index < n; ++index) {
                    DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$createConstructor_u24lambda_u241), (String)("receiver" + index), (IrType)functionReferenceLowering.context.getIrBuiltIns().getAnyNType(), null, (int)4, null);
                }
            }
            if (this.isFunInterfaceConstructorReference) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getSymbols().getFunInterfaceConstructorReferenceClass().getOwner())));
            } else if (this.samSuperType != null) {
                irConstructor = (IrConstructor)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClass)((IrClass)functionReferenceLowering.context.getIrBuiltIns().getAnyClass().getOwner())));
            } else {
                int expectedArity = this.isLightweightLambda && !this.isAdaptedReference ? 0 : (this.isHeavyweightLambda && !this.isAdaptedReference ? 1 : 1 + this.boundReceivers.size() + 4);
                IrSimpleType irSimpleType = this.superClass;
                Object object = irSimpleType != null ? IrTypesKt.getClass((IrType)((IrType)irSimpleType)) : null;
                Intrinsics.checkNotNull((Object)object);
                $this$single$iv = IrUtilsKt.getConstructors((IrClass)object);
                boolean $i$f$single = false;
                single$iv = null;
                found$iv = 0;
                for (Object element$iv : $this$single$iv) {
                    it = (IrConstructor)element$iv;
                    boolean bl5 = false;
                    if (!(it.getParameters().size() == expectedArity)) continue;
                    if (found$iv != 0) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = 1;
                }
                if (found$iv == 0) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor = (IrConstructor)single$iv;
            }
            IrConstructor constructor = irConstructor;
            $this$single$iv = JvmIrBuilderKt.createJvmIrBuilder$default(functionReferenceLowering.context, (IrSymbol)$this$createConstructor_u24lambda_u241.getSymbol(), 0, 0, 6, null);
            IrFactory irFactory2 = $this$createConstructor_u24lambda_u241;
            boolean bl6 = false;
            single$iv = (IrBuilderWithScope)$this$createConstructor_u24lambda_u241_u241;
            found$iv = $this$createConstructor_u24lambda_u241_u241.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u241_u241.getEndOffset();
            boolean $i$f$irBlockBody = false;
            it = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$createConstructor_u24lambda_u241_u241_u240 = this_$iv$iv;
            boolean bl7 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)((IrBuilder)$this$createConstructor_u24lambda_u241_u241_u240), (IrConstructor)constructor);
            void var20_27 = $this$createConstructor_u24lambda_u241_u241_u240;
            boolean bl8 = false;
            if (this.samSuperType == null) {
                void call;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$createConstructor_u24lambda_u241_u241, (IrFunctionAccessExpression)call, (Function2<? super IrBuilder, ? super Integer, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> FunctionReferenceBuilder.createConstructor$lambda$1$1$0$0$0((IrConstructor)$this$createConstructor_u24lambda_u241, arg_0, arg_1)));
            }
            var20_27.unaryPlus((IrStatement)irDelegatingConstructorCall);
            $this$createConstructor_u24lambda_u241_u241_u240.unaryPlus((IrStatement)BuildersKt.IrInstanceInitializerCallImpl((int)$this$createConstructor_u24lambda_u241_u241_u240.getStartOffset(), (int)$this$createConstructor_u24lambda_u241_u241_u240.getEndOffset(), (IrClassSymbol)this.functionReferenceClass.getSymbol(), (IrType)$this$createConstructor_u24lambda_u241_u241_u240.getContext().getIrBuiltIns().getUnitType()));
            irFactory2.setBody((IrBody)this_$iv$iv.doBuild());
            return irFactory;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call, Function2<? super IrBuilder, ? super Integer, ? extends IrExpression> generateBoundReceiver) {
            if (this.isFunInterfaceConstructorReference) {
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                IrClassSymbol irClassSymbol = this.constructedFunInterfaceSymbol;
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrClassReference funInterfaceKClassRef = JvmIrUtilsKt.kClassReference(irBuilderWithScope, (IrType)IrUtilsKt.getDefaultType((IrClass)((IrClass)irClassSymbol.getOwner())));
                IrCall funInterfaceJavaClassRef = JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, (IrExpression)funInterfaceKClassRef);
                call.getArguments().set(0, (Object)funInterfaceJavaClassRef);
            } else {
                int index = 0;
                if (!this.isLightweightLambda) {
                    call.getArguments().set(index++, (Object)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$generateConstructorCallArguments), (int)(this.irFunctionReference.getInvokeFunction().getParameters().size() - this.irFunctionReference.getBoundValues().size() + (this.isSuspend ? 1 : 0)), null, (int)2, null));
                }
                int n = ((Collection)this.boundReceivers.entrySet()).size();
                for (int it = 0; it < n; ++it) {
                    call.getArguments().set(index++, generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments, (Object)it));
                }
                if (!this.isLambda) {
                    Object object = this.adaptedReferenceOriginalTarget;
                    if (object == null) {
                        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)this.irFunctionReference.getReflectionTargetSymbol();
                        object = irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null;
                        if (object == null) {
                            object = (IrFunction)this.callee;
                        }
                    }
                    IrFunction callableReferenceTarget = object;
                    IrExpression owner = Companion.calculateOwnerKClass$backend_jvm_lower($this$generateConstructorCallArguments, callableReferenceTarget.getParent());
                    call.getArguments().set(index++, (Object)JvmIrUtilsKt.kClassToJavaClass($this$generateConstructorCallArguments, owner));
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = call.getArguments();
                    int n2 = index++;
                    IrBuilder irBuilder = (IrBuilder)$this$generateConstructorCallArguments;
                    String string = this.getOriginalName(callableReferenceTarget).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    valueArgumentsList.set(n2, (Object)ExpressionHelpersKt.irString((IrBuilder)irBuilder, (String)string));
                    call.getArguments().set(index++, (Object)this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                    call.getArguments().set(index, (Object)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$generateConstructorCallArguments), (int)this.getFunctionReferenceFlags(callableReferenceTarget), null, (int)2, null));
                }
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = JvmIrUtilsKt.getCallableReferenceTopLevelFlag((IrDeclaration)callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.irFunctionReference.getHasVarargConversion() ? 1 : 0;
            int isSuspendConvertedBit = this.irFunctionReference.getHasSuspendConversion() ? 1 : 0;
            int isCoercedToUnitBit = this.irFunctionReference.getHasUnitConversion() ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(List<? extends BoundValue> boundValues) {
            IrBody transformedBody2;
            void $this$createInvokeMethod_u24lambda_u241_u247;
            IrValueParameter invokeParameter;
            void this_$iv$iv;
            DeclarationIrBuilder declarationIrBuilder;
            void $this$applyIf$iv;
            Object object;
            Map superParameter;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            IrTypeSubstitutor irTypeSubstitutor;
            Iterable<IrType> iterable;
            Iterable iterable2;
            Iterable destination$iv$iv;
            IrSimpleFunction irSimpleFunction;
            void $this$addFunction$iv$iv;
            IrSimpleFunction superFunction = (IrSimpleFunction)this.irFunctionReference.getOverriddenFunctionSymbol().getOwner();
            IrSimpleFunction invokeFunction = this.irFunctionReference.getInvokeFunction();
            boolean isLambda = IrUtilsKt.isLambda((IrStatementOrigin)this.irFunctionReference.getOrigin());
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory irFactory = $this$addFunction$iv.getFactory();
            IrDeclarationContainer klass$iv$iv = (IrDeclarationContainer)$this$addFunction$iv;
            boolean $i$f$addFunction2 = false;
            void $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv$iv$iv = new IrFunctionBuilder();
            boolean bl5 = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$createInvokeMethod_u24lambda_u240), (IrElement)(isLambda ? (IrElement)invokeFunction : (IrElement)this.irFunctionReference));
            $this$createInvokeMethod_u24lambda_u240.setName(superFunction.getName());
            $this$createInvokeMethod_u24lambda_u240.setReturnType(invokeFunction.getReturnType());
            $this$createInvokeMethod_u24lambda_u240.setOperator(superFunction.isOperator());
            $this$createInvokeMethod_u24lambda_u240.setSuspend(superFunction.isSuspend());
            IrSimpleFunction function$iv$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv$iv$iv);
            boolean bl3 = false;
            klass$iv$iv.getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)klass$iv$iv);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            FunctionReferenceLowering functionReferenceLowering = this.this$0;
            IrSimpleFunction $this$createInvokeMethod_u24lambda_u241 = irSimpleFunction2;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)this.irFunctionReference.getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getDEFAULT_VALUE_OF_INLINABLE_PARAMETER())) {
                $this$createInvokeMethod_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getINVOKE_OF_DEFAULT_VALUE_OF_INLINABLE_PARAMETER());
            }
            $this$createInvokeMethod_u24lambda_u241.setAnnotations(invokeFunction.getAnnotations());
            $this$createInvokeMethod_u24lambda_u241.setMetadata(this.functionReferenceClass.getMetadata());
            $this$createInvokeMethod_u24lambda_u241.setParameters(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u241.getParameters(), (Object)IrUtilsKt.createDispatchReceiverParameterWithClassParent$default((IrFunction)((IrFunction)$this$createInvokeMethod_u24lambda_u241), null, (int)1, null)));
            if (!superFunction.getTypeParameters().isEmpty()) {
                boolean $i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$createInvokeMethod$2$22 = false;
                String $i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$createInvokeMethod$2$22 = "Fun interface abstract function can't have type parameters";
                throw new IllegalArgumentException($i$a$-require-FunctionReferenceLowering$FunctionReferenceBuilder$createInvokeMethod$2$22.toString());
            }
            if (this.samSuperType == null) {
                IrTypeArgument it;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrDeclarationParent)IrTypesKt.getClassOrFail((IrType)this.irFunctionReference.getType()).getOwner()));
                boolean $i$f$map = false;
                Iterable bl5 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv2) {
                    IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl6 = false;
                    iterable2.add(it.getSymbol());
                }
                List list = (List)destination$iv$iv;
                IrType irType = this.irFunctionReference.getType();
                Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                $this$map$iv = ((IrSimpleType)irType).getArguments();
                iterable2 = list;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv2) {
                    IrType irType2;
                    it = (IrTypeArgument)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl7 = false;
                    IrTypeArgument irTypeArgument = it;
                    if (irTypeArgument instanceof IrTypeProjection && IrTypePredicatesKt.isNothing((IrType)((IrTypeProjection)it).getType())) {
                        irType2 = functionReferenceLowering.context.getIrBuiltIns().getAnyNType();
                    } else if (irTypeArgument instanceof IrTypeProjection) {
                        irType2 = ((IrTypeProjection)it).getType();
                    } else if (irTypeArgument instanceof IrStarProjection) {
                        irType2 = functionReferenceLowering.context.getIrBuiltIns().getAnyNType();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    iterable.add((IrType)irType2);
                }
                boolean bl8 = true;
                List list2 = (List)destination$iv$iv;
                Iterable iterable3 = iterable2;
                irTypeSubstitutor = new IrTypeSubstitutor((List)iterable3, list2, bl8);
            } else {
                IrTypeParameter it;
                List typeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrDeclarationParent)IrTypesKt.getClassOrFail((IrType)this.samSuperType).getOwner()));
                Iterable $this$map$iv = typeParameters;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IrTypeParameter bl7 = (IrTypeParameter)item$iv$iv;
                    iterable2 = destination$iv$iv2;
                    boolean bl9 = false;
                    iterable2.add(it.getSymbol());
                }
                $this$map$iv = typeParameters;
                iterable2 = (List)destination$iv$iv2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (IrTypeParameter)item$iv$iv;
                    iterable = destination$iv$iv2;
                    boolean bl10 = false;
                    iterable.add(JvmIrUtilsKt.rawType(IrTypeErasureUtilsKt.getErasedUpperBound((IrTypeParameter)it), functionReferenceLowering.context));
                }
                boolean bl11 = true;
                List list = (List)destination$iv$iv2;
                Iterable iterable4 = iterable2;
                irTypeSubstitutor = new IrTypeSubstitutor((List)iterable4, list, bl11);
            }
            IrTypeSubstitutor typeSubstitutor2 = irTypeSubstitutor;
            Iterable $this$mapIndexed$iv = IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)superFunction));
            boolean $i$f$mapIndexed22 = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                IrValueParameter irValueParameter;
                void i;
                int bl10;
                if ((bl10 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                int n = bl10;
                collection = destination$iv$iv3;
                boolean bl12 = false;
                IrValueParameter oldParameter = (IrValueParameter)invokeFunction.getParameters().get((int)(i + this.irFunctionReference.getBoundValues().size()));
                int n2 = isLambda ? oldParameter.getStartOffset() : -1;
                int n3 = isLambda ? oldParameter.getEndOffset() : -1;
                Name name = oldParameter.getName();
                IrDeclarationOrigin irDeclarationOrigin = oldParameter.getOrigin();
                object = IrTypesKt.mergeNullability((IrType)typeSubstitutor2.substitute(superParameter.getType()), (IrType)((IrValueParameter)invokeFunction.getParameters().get((int)(i + boundValues.size()))).getType());
                IrValueParameter $this$createInvokeMethod_u24lambda_u241_u245_u240 = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)superParameter, (IrFunction)((IrFunction)$this$createInvokeMethod_u24lambda_u241), (IrDeclarationOrigin)irDeclarationOrigin, (int)n2, (int)n3, (Name)name, null, (IrType)object, null, null, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16032, null);
                boolean bl13 = false;
                IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)$this$createInvokeMethod_u24lambda_u241_u245_u240), (IrAnnotationContainer)((IrAnnotationContainer)oldParameter));
                collection.add(irValueParameter);
            }
            List nonDispatchParameters = (List)destination$iv$iv3;
            $this$createInvokeMethod_u24lambda_u241.setParameters(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u241.getParameters(), (Iterable)nonDispatchParameters));
            $this$createInvokeMethod_u24lambda_u241.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$createInvokeMethod_u24lambda_u241.getOverriddenSymbols(), (Object)superFunction.getSymbol()));
            DeclarationIrBuilder $i$f$mapIndexed22 = LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)functionReferenceLowering.context), (IrSymbol)((IrSymbol)$this$createInvokeMethod_u24lambda_u241.getSymbol()), (int)0, (int)0, (int)6, null);
            boolean if$iv = isLambda;
            boolean $i$f$applyIf = false;
            if (if$iv) {
                void $this$createInvokeMethod_u24lambda_u241_u246 = $this$applyIf$iv;
                boolean bl14 = false;
                IrBuilder irBuilder = (IrBuilder)$this$createInvokeMethod_u24lambda_u241_u246;
                IrBody irBody = invokeFunction.getBody();
                Intrinsics.checkNotNull((Object)irBody);
                declarationIrBuilder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)irBuilder, (IrElement)((IrElement)irBody));
            } else {
                declarationIrBuilder = $this$applyIf$iv;
            }
            void builder = declarationIrBuilder;
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)builder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder bl14 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void item$iv$iv = this_$iv$iv;
            collection = $this$createInvokeMethod_u24lambda_u241;
            boolean bl15 = false;
            Map $this$createInvokeMethod_u24lambda_u241_u247_u240 = superParameter = MapsKt.createMapBuilder();
            boolean bl16 = false;
            Iterator iterator2 = ((Iterable)boundValues).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                IrVariable irVariable;
                int index = n++;
                BoundValue capturedValue = (BoundValue)iterator2.next();
                invokeParameter = (IrValueParameter)invokeFunction.getParameters().get(index);
                object = capturedValue;
                if (object instanceof BoundValue.StoredInVariable) {
                    irVariable = ((BoundValue.StoredInVariable)capturedValue).getSymbol();
                } else if (object instanceof BoundValue.StoredInField) {
                    IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$createInvokeMethod_u24lambda_u241_u247;
                    IrBuilder irBuilder = (IrBuilder)$this$createInvokeMethod_u24lambda_u241_u247;
                    IrBuilder irBuilder2 = (IrBuilder)$this$createInvokeMethod_u24lambda_u241_u247;
                    IrBuilder irBuilder3 = (IrBuilder)$this$createInvokeMethod_u24lambda_u241_u247;
                    IrValueParameter irValueParameter = $this$createInvokeMethod_u24lambda_u241.getDispatchReceiverParameter();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    irVariable = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)irStatementsBuilder, (IrExpression)((IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilder)irBuilder, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilder)irBuilder2, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter))), (IrField)((BoundValue.StoredInField)capturedValue).getSymbol(), null, (int)4, null)), (IrType)invokeParameter.getType())), null, null, (boolean)false, null, (int)30, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                IrVariable capturedValueLocal = irVariable;
                $this$createInvokeMethod_u24lambda_u241_u247_u240.put(invokeParameter, capturedValueLocal);
            }
            iterator2 = ((Iterable)nonDispatchParameters).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                IrValueParameter parameter = (IrValueParameter)iterator2.next();
                invokeParameter = (IrValueParameter)invokeFunction.getParameters().get(index + boundValues.size());
                IrDeclaration irDeclaration = !Intrinsics.areEqual((Object)parameter.getType(), (Object)invokeParameter.getType()) ? (IrDeclaration)$this$createInvokeMethod_u24lambda_u241_u247_u240.put(invokeParameter, ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$createInvokeMethod_u24lambda_u241_u247), (IrExpression)IrExpressionsKt.implicitCastTo((IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createInvokeMethod_u24lambda_u241_u247), (IrValueDeclaration)((IrValueDeclaration)parameter))), (IrType)invokeParameter.getType()), null, null, (boolean)false, null, (int)30, null)) : (IrDeclaration)$this$createInvokeMethod_u24lambda_u241_u247_u240.put(invokeParameter, parameter);
            }
            Map variablesMapping = MapsKt.build((Map)superParameter);
            IrBody irBody = invokeFunction.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            IrBody irBody2 = transformedBody2 = irBody.transform((IrTransformer)new VariableRemapper(variablesMapping, invokeFunction, $this$createInvokeMethod_u24lambda_u241){
                final /* synthetic */ IrSimpleFunction $invokeFunction;
                final /* synthetic */ IrSimpleFunction $this_apply;
                {
                    this.$invokeFunction = $invokeFunction;
                    this.$this_apply = $this_apply;
                    super($variablesMapping);
                }

                public IrExpression visitReturn(IrReturn expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$invokeFunction.getSymbol())) {
                        expression2.setReturnTargetSymbol((IrReturnTargetSymbol)this.$this_apply.getSymbol());
                    }
                    return super.visitReturn(expression2);
                }

                public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$invokeFunction)) {
                        declaration.setParent((IrDeclarationParent)this.$this_apply);
                    }
                    return super.visitDeclaration(declaration);
                }
            }, null);
            if (irBody2 instanceof IrBlockBody) {
                $this$createInvokeMethod_u24lambda_u241_u247.unaryPlus(((IrBlockBody)transformedBody2).getStatements());
            } else if (irBody2 instanceof IrExpressionBody) {
                $this$createInvokeMethod_u24lambda_u241_u247.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$createInvokeMethod_u24lambda_u241_u247), (IrExpression)((IrExpressionBody)transformedBody2).getExpression()));
            } else {
                throw new IllegalStateException(("Unexpected body type: " + Reflection.getOrCreateKotlinClass(transformedBody2.getClass()).getSimpleName()).toString());
            }
            collection.setBody((IrBody)this_$iv$iv.doBuild());
            return irSimpleFunction2;
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            MetadataSource metadataSource = $this$originalName.getMetadata();
            if (metadataSource == null || (metadataSource = metadataSource.getName()) == null) {
                metadataSource = $this$originalName.getName();
            }
            return metadataSource;
        }

        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            IrCall irCall;
            IrCall $this$generateSignature_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$generateSignature), (IrSimpleFunctionSymbol)$this$generateSignature.getBackendContext().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            $this$generateSignature_u24lambda_u240.getArguments().set(0, (Object)BuildersKt.IrRawFunctionReferenceImpl((int)-1, (int)-1, (IrType)this.irFunctionReference.getType(), (IrFunctionSymbol)target));
            return (IrExpression)irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrClass objectClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.callee));
            IrDeclaration declaration$iv = (IrDeclaration)this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240 = $this$buildValueParameter_u24lambda_u241$iv;
            boolean bl2 = false;
            Name name = Name.identifier((String)"$this");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240.setName(name);
            $this$createFakeBoundReceiverForJvmStaticInObject_u24lambda_u240.setType((IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter((IrFactory)declaration$iv.getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((IrDeclarationParent)declaration$iv)), (Object)BuildersKt.IrGetObjectValueImpl((int)-1, (int)-1, (IrType)((IrType)IrTypesKt.typeWith((IrClass)objectClass, (IrType[])new IrType[0])), (IrClassSymbol)objectClass.getSymbol()));
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$1$1$0(List $boundReceiverVars, IrBuilder $this$generateConstructorCallArguments, int it) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            return (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$generateConstructorCallArguments, (IrValueDeclaration)((IrValueDeclaration)((BoundValue.StoredInVariable)$boundReceiverVars.get(it)).getSymbol()));
        }

        private static final IrExpression generateSamEqualsHashCodeMethods$lambda$1(FunctionReferenceBuilder this$0, JvmIrBuilder $this_generateSamEqualsHashCodeMethods, List $boundReceiverVars, IrBuilderWithScope $this$SamEqualsHashCodeMethodsGenerator, IrExpression it) {
            IrConstructorCall irConstructorCall;
            Intrinsics.checkNotNullParameter((Object)$this$SamEqualsHashCodeMethodsGenerator, (String)"$this$SamEqualsHashCodeMethodsGenerator");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            IrClassSymbol internalClass = this$0.isAdaptedReference ? $this_generateSamEqualsHashCodeMethods.getBackendContext().getSymbols().getAdaptedFunctionReference() : $this_generateSamEqualsHashCodeMethods.getBackendContext().getSymbols().getFunctionReferenceImpl();
            Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)((IrClass)internalClass.getOwner()));
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it2 = (IrConstructor)element$iv;
                boolean bl = false;
                if (!(it2.getParameters().size() == 1 + this$0.boundReceivers.size() + 4)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrConstructor constructor = single$iv;
            IrConstructorCall $this$generateSamEqualsHashCodeMethods_u24lambda_u241_u241 = irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilder)((IrBuilder)$this$SamEqualsHashCodeMethodsGenerator), (IrConstructorSymbol)constructor.getSymbol(), (List)CollectionsKt.emptyList());
            boolean bl = false;
            this$0.generateConstructorCallArguments($this_generateSamEqualsHashCodeMethods, (IrFunctionAccessExpression)$this$generateSamEqualsHashCodeMethods_u24lambda_u241_u241, (Function2<? super IrBuilder, ? super Integer, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> FunctionReferenceBuilder.generateSamEqualsHashCodeMethods$lambda$1$1$0($boundReceiverVars, arg_0, arg_1)));
            return (IrExpression)irConstructorCall;
        }

        private static final IrExpression createConstructor$lambda$1$1$0$0$0(IrConstructor $this_apply, IrBuilder $this$generateConstructorCallArguments, int it) {
            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$this$generateConstructorCallArguments");
            return (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$generateConstructorCallArguments, (IrValueDeclaration)((IrValueDeclaration)CollectionsKt.first((List)$this_apply.getParameters())));
        }
    }
}

