/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.lower.IndyLambdaMetafactoryLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RecordEnclosingMethodsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class RecordEnclosingMethodsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RecordEnclosingMethodsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept((IrVisitor)new IrVisitor<Unit, IrFunction>(this){
            private final List<IrClass> classStack;
            final /* synthetic */ RecordEnclosingMethodsLowering this$0;
            {
                this.this$0 = $receiver;
                this.classStack = new ArrayList<E>();
            }

            public void visitClass(IrClass declaration, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.classStack.add(declaration);
                super.visitClass(declaration, (Object)data);
                CollectionsKt.removeLast(this.classStack);
            }

            public void visitElement(IrElement element, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitor irVisitor = this;
                IrFunction irFunction = element instanceof IrFunction ? (IrFunction)element : null;
                if (irFunction == null) {
                    irFunction = data;
                }
                element.acceptChildren(irVisitor, (Object)irFunction);
            }

            public void visitCall(IrCall expression2, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (!(data != null)) {
                    boolean bl = false;
                    String string = "function call not in a method: " + RenderIrElementKt.render$default((IrElement)((IrElement)expression2), null, (int)1, null);
                    throw new IllegalArgumentException(string.toString());
                }
                IrRawFunctionReference irRawFunctionReference = IndyLambdaMetafactoryLowering.Companion.getLambdaMetafactoryIndyImplFunctionRefOrNull(this.this$0.getContext().getSymbols(), expression2);
                if (irRawFunctionReference != null) {
                    IrRawFunctionReference reference = irRawFunctionReference;
                    boolean bl = false;
                    this.recordEnclosingMethodOverride(reference.getSymbol().getOwner(), data);
                }
                super.visitCall(expression2, (Object)data);
            }

            public void visitRichFunctionReference(IrRichFunctionReference expression2, IrFunction data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (!(data != null)) {
                    boolean bl = false;
                    String string = "inline lambda not in a method: " + RenderIrElementKt.render$default((IrElement)((IrElement)expression2), null, (int)1, null);
                    throw new IllegalArgumentException(string.toString());
                }
                this.recordEnclosingMethodOverride((IrFunction)expression2.getInvokeFunction(), data);
                super.visitRichFunctionReference(expression2, (Object)data);
            }

            private final void recordEnclosingMethodOverride(IrFunction from, IrFunction to) {
                IrFunction old = JvmIrAttributesKt.getEnclosingMethodOverride(from);
                if (old != null) {
                    IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)CollectionsKt.last(this.classStack)));
                    if (irConstructor != null) {
                        IrConstructor it = irConstructor;
                        boolean bl = false;
                        JvmIrAttributesKt.setEnclosingMethodOverride(from, (IrFunction)it);
                    }
                } else {
                    JvmIrAttributesKt.setEnclosingMethodOverride(from, to);
                }
            }
        }, null);
    }
}

