/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.mapping;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.Printer;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u001b\u001a\u00020\u001cH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/mapping/IrCallableMethod;", "", "owner", "Lorg/jetbrains/org/objectweb/asm/Type;", "invokeOpcode", "", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "isInterfaceMethod", "", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/Type;ILorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;ZLorg/jetbrains/kotlin/ir/types/IrType;)V", "getOwner", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getInvokeOpcode", "()I", "getSignature", "()Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "()Z", "getReturnType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "asmMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getAsmMethod", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "toString", "", "backend.jvm"})
public final class IrCallableMethod {
    @NotNull
    private final Type owner;
    private final int invokeOpcode;
    @NotNull
    private final JvmMethodSignature signature;
    private final boolean isInterfaceMethod;
    @NotNull
    private final IrType returnType;
    @NotNull
    private final Method asmMethod;

    public IrCallableMethod(@NotNull Type owner, int invokeOpcode, @NotNull JvmMethodSignature signature, boolean isInterfaceMethod, @NotNull IrType returnType) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        this.owner = owner;
        this.invokeOpcode = invokeOpcode;
        this.signature = signature;
        this.isInterfaceMethod = isInterfaceMethod;
        this.returnType = returnType;
        Method method = this.signature.getAsmMethod();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getAsmMethod(...)");
        this.asmMethod = method;
    }

    @NotNull
    public final Type getOwner() {
        return this.owner;
    }

    public final int getInvokeOpcode() {
        return this.invokeOpcode;
    }

    @NotNull
    public final JvmMethodSignature getSignature() {
        return this.signature;
    }

    public final boolean isInterfaceMethod() {
        return this.isInterfaceMethod;
    }

    @NotNull
    public final IrType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final Method getAsmMethod() {
        return this.asmMethod;
    }

    @NotNull
    public String toString() {
        return Printer.OPCODES[this.invokeOpcode] + ' ' + this.owner + '.' + this.asmMethod + (this.isInterfaceMethod ? " (itf)" : "");
    }
}

