/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassITableGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FuncSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ModuleReferencedDeclarations;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.RttiGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmServiceImportExportKind;
import org.jetbrains.kotlin.ir.declarations.IdSignatureRetriever;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J \u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContextWithExport;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmFileFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "idSignatureRetriever", "Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;", "moduleReferencedDeclarations", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ModuleReferencedDeclarations;)V", "defineFunction", "", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "referenceFunction", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/FuncSymbol;", "referenceGlobalVTable", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VTableGlobalSymbol;", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "referenceGlobalClassITable", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassITableGlobalSymbol;", "referenceRttiGlobal", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/RttiGlobalSymbol;", "defineGlobalVTable", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineGlobalClassITable", "defineRttiGlobal", "global", "irSuperClass", "exportDeclarationGlobal", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "prefix", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmServiceImportExportKind;", "backend.wasm"})
public final class WasmFileCodegenContextWithExport
extends WasmFileCodegenContext {
    @NotNull
    private final ModuleReferencedDeclarations moduleReferencedDeclarations;

    public WasmFileCodegenContextWithExport(@NotNull WasmCompiledFileFragment wasmFileFragment, @NotNull IdSignatureRetriever idSignatureRetriever, @NotNull ModuleReferencedDeclarations moduleReferencedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)wasmFileFragment, (String)"wasmFileFragment");
        Intrinsics.checkNotNullParameter((Object)idSignatureRetriever, (String)"idSignatureRetriever");
        Intrinsics.checkNotNullParameter((Object)moduleReferencedDeclarations, (String)"moduleReferencedDeclarations");
        super(wasmFileFragment, idSignatureRetriever);
        this.moduleReferencedDeclarations = moduleReferencedDeclarations;
    }

    @Override
    public void defineFunction(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)wasmFunction, (String)"wasmFunction");
        super.defineFunction(irFunction, wasmFunction);
        IrFunction owner = irFunction.getOwner();
        if (IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)((IrDeclarationWithVisibility)owner))) {
            return;
        }
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)owner);
        String string = WasmServiceImportExportKind.FUNC.getPrefix() + signature;
        this.addExport((WasmExport)new WasmExport.Function(string, wasmFunction));
    }

    @Override
    @NotNull
    public FuncSymbol referenceFunction(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        this.moduleReferencedDeclarations.getReferencedFunction().add(this.getReferenceKey((IrSymbol)irFunction));
        return super.referenceFunction(irFunction);
    }

    @Override
    @NotNull
    public VTableGlobalSymbol referenceGlobalVTable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.moduleReferencedDeclarations.getReferencedGlobalVTable().add(this.getReferenceKey((IrSymbol)irClass));
        return super.referenceGlobalVTable(irClass);
    }

    @Override
    @NotNull
    public ClassITableGlobalSymbol referenceGlobalClassITable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.moduleReferencedDeclarations.getReferencedGlobalClassITable().add(this.getReferenceKey((IrSymbol)irClass));
        return super.referenceGlobalClassITable(irClass);
    }

    @Override
    @NotNull
    public RttiGlobalSymbol referenceRttiGlobal(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.moduleReferencedDeclarations.getReferencedRttiGlobal().add(this.getReferenceKey((IrSymbol)irClass));
        return super.referenceRttiGlobal(irClass);
    }

    @Override
    public void defineGlobalVTable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        super.defineGlobalVTable(irClass, wasmGlobal);
        this.exportDeclarationGlobal((IrDeclarationWithVisibility)irClass.getOwner(), WasmServiceImportExportKind.VTABLE, wasmGlobal);
    }

    @Override
    public void defineGlobalClassITable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)wasmGlobal, (String)"wasmGlobal");
        super.defineGlobalClassITable(irClass, wasmGlobal);
        this.exportDeclarationGlobal((IrDeclarationWithVisibility)irClass.getOwner(), WasmServiceImportExportKind.ITABLE, wasmGlobal);
    }

    @Override
    public void defineRttiGlobal(@NotNull WasmGlobal global, @NotNull IrClassSymbol irClass, @Nullable IrClassSymbol irSuperClass) {
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        super.defineRttiGlobal(global, irClass, irSuperClass);
        this.exportDeclarationGlobal((IrDeclarationWithVisibility)irClass.getOwner(), WasmServiceImportExportKind.RTTI, global);
    }

    private final void exportDeclarationGlobal(IrDeclarationWithVisibility declaration, WasmServiceImportExportKind prefix, WasmGlobal global) {
        if (IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)declaration)) {
            return;
        }
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration);
        this.addExport((WasmExport)new WasmExport.Global(prefix.getPrefix() + signature, global));
    }
}

