/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.BackendWasmSymbols;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012J\f\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\u0012J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0012H\u0002J\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u0016\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u001a\u001a\u00020\u0011*\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00110\u0018j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0011`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "getWasmFileCodegenContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/BackendWasmSymbols;", "toWasmResultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toWasmBlockResultType", "toWasmGcRefType", "toBoxedInlineClassType", "toWasmFieldType", "irBuiltInToWasmType", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "toWasmValueType", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nTypeTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeTransformer.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class WasmTypeTransformer {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final BackendWasmSymbols symbols;
    @NotNull
    private final HashMap<IrType, WasmType> irBuiltInToWasmType;

    public WasmTypeTransformer(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFileCodegenContext, (String)"wasmFileCodegenContext");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.builtIns = this.backendContext.getIrBuiltIns();
        this.symbols = this.backendContext.getWasmSymbols();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.builtIns.getBooleanType(), (Object)WasmI32.INSTANCE), TuplesKt.to((Object)this.builtIns.getByteType(), (Object)WasmI32.INSTANCE), TuplesKt.to((Object)this.builtIns.getShortType(), (Object)WasmI32.INSTANCE), TuplesKt.to((Object)this.builtIns.getIntType(), (Object)WasmI32.INSTANCE), TuplesKt.to((Object)this.builtIns.getCharType(), (Object)WasmI32.INSTANCE), TuplesKt.to((Object)this.builtIns.getLongType(), (Object)WasmI64.INSTANCE), TuplesKt.to((Object)this.builtIns.getFloatType(), (Object)WasmF32.INSTANCE), TuplesKt.to((Object)this.builtIns.getDoubleType(), (Object)WasmF64.INSTANCE), TuplesKt.to((Object)this.builtIns.getNothingNType(), (Object)WasmRefNullrefType.INSTANCE), TuplesKt.to((Object)this.builtIns.getNothingType(), (Object)WasmAnyRef.INSTANCE)};
        this.irBuiltInToWasmType = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmFileCodegenContext getWasmFileCodegenContext() {
        return this.wasmFileCodegenContext;
    }

    @Nullable
    public final WasmType toWasmResultType(@NotNull IrType $this$toWasmResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmResultType, (String)"<this>");
        IrType irType = $this$toWasmResultType;
        return Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getUnitType()) || Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType()) ? null : this.toWasmValueType($this$toWasmResultType);
    }

    @Nullable
    public final WasmType toWasmBlockResultType(@NotNull IrType $this$toWasmBlockResultType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmBlockResultType, (String)"<this>");
        IrType irType = $this$toWasmBlockResultType;
        return Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getNothingType()) ? (WasmType)WasmUnreachableType.INSTANCE : (Intrinsics.areEqual((Object)irType, (Object)this.symbols.getVoidType()) ? null : this.toWasmValueType($this$toWasmBlockResultType));
    }

    private final WasmType toWasmGcRefType(IrType $this$toWasmGcRefType) {
        return (WasmType)new WasmRefNullType((WasmHeapType)this.wasmFileCodegenContext.referenceHeapType(TypeTransformerKt.getRuntimeClass($this$toWasmGcRefType, this.backendContext.getIrBuiltIns()).getSymbol()));
    }

    @NotNull
    public final WasmType toBoxedInlineClassType(@NotNull IrType $this$toBoxedInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$toBoxedInlineClassType, (String)"<this>");
        return this.toWasmGcRefType($this$toBoxedInlineClassType);
    }

    @NotNull
    public final WasmType toWasmFieldType(@NotNull IrType $this$toWasmFieldType) {
        Intrinsics.checkNotNullParameter((Object)$this$toWasmFieldType, (String)"<this>");
        IrType irType = $this$toWasmFieldType;
        return Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) || Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType()) ? (WasmType)WasmI8.INSTANCE : (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType()) || Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType()) ? (WasmType)WasmI16.INSTANCE : this.toWasmValueType($this$toWasmFieldType));
    }

    @NotNull
    public final WasmType toWasmValueType(@NotNull IrType $this$toWasmValueType) {
        WasmType wasmType;
        block22: {
            block23: {
                IrClass klass;
                block21: {
                    Intrinsics.checkNotNullParameter((Object)$this$toWasmValueType, (String)"<this>");
                    WasmType wasmType2 = this.irBuiltInToWasmType.get($this$toWasmValueType);
                    if (wasmType2 != null) {
                        WasmType it = wasmType2;
                        boolean bl = false;
                        return it;
                    }
                    if (Intrinsics.areEqual((Object)$this$toWasmValueType, (Object)this.symbols.getVoidType())) {
                        throw new IllegalStateException("Void type can't be used as a value".toString());
                    }
                    klass = IrTypeErasureUtilsKt.getErasedUpperBound((IrType)$this$toWasmValueType);
                    if (!klass.isExternal()) break block21;
                    wasmType = !Intrinsics.areEqual((Object)klass.getName().getIdentifier(), (Object)"JsStringRef") ? (WasmType)WasmExternRef.INSTANCE : (WasmType)new WasmRefType((WasmHeapType)WasmHeapType.Simple.Extern.INSTANCE);
                    break block22;
                }
                if (!TypeTransformerKt.isBuiltInWasmRefType($this$toWasmValueType)) break block23;
                String string = klass.getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                switch (string) {
                    case "anyref": {
                        wasmType = (WasmType)WasmAnyRef.INSTANCE;
                        break block22;
                    }
                    case "eqref": {
                        wasmType = (WasmType)WasmEqRef.INSTANCE;
                        break block22;
                    }
                    case "structref": {
                        wasmType = (WasmType)new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Struct.INSTANCE);
                        break block22;
                    }
                    case "i31ref": {
                        wasmType = (WasmType)WasmI31Ref.INSTANCE;
                        break block22;
                    }
                    case "funcref": {
                        wasmType = (WasmType)new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Func.INSTANCE);
                        break block22;
                    }
                    default: {
                        String name;
                        throw new IllegalStateException(("Unknown reference type " + name).toString());
                    }
                }
            }
            IrClass ic = this.backendContext.getInlineClassesUtils().getInlinedClass($this$toWasmValueType);
            wasmType = ic != null ? this.toWasmValueType(this.backendContext.getInlineClassesUtils().getInlineClassUnderlyingType(ic)) : this.toWasmGcRefType($this$toWasmValueType);
        }
        return wasmType;
    }
}

