/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.eval;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactory;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fB=\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J!\u0010\u001a\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004J\b\u0010#\u001a\u00020$H\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/ReadValueInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessValueInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "target", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "receiverValues", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "_outputValue", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;Ljava/util/Map;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "factory", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValueFactory;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;Ljava/util/Map;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValueFactory;)V", "inputValues", "", "getInputValues", "()Ljava/util/List;", "outputValue", "getOutputValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "toString", "", "createCopy", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionImpl;", "cfg"})
public final class ReadValueInstruction
extends AccessValueInstruction
implements InstructionWithValue {
    @Nullable
    private PseudoValue _outputValue;

    private ReadValueInstruction(KtElement element, BlockScope blockScope, AccessTarget target, Map<PseudoValue, ? extends ReceiverValue> receiverValues, PseudoValue _outputValue) {
        super(element, blockScope, target, receiverValues);
        this._outputValue = _outputValue;
    }

    public ReadValueInstruction(@NotNull KtElement element, @NotNull BlockScope blockScope, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues, @NotNull PseudoValueFactory factory) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)blockScope, (String)"blockScope");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(receiverValues, (String)"receiverValues");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this(element, blockScope, target, receiverValues, (PseudoValue)null);
        this._outputValue = factory.newValue(element, this);
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.toList((Iterable)this.getReceiverValues().keySet());
    }

    @Override
    @NotNull
    public PseudoValue getOutputValue() {
        PseudoValue pseudoValue = this._outputValue;
        Intrinsics.checkNotNull((Object)pseudoValue);
        return pseudoValue;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitReadValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitReadValue(this);
    }

    @NotNull
    public String toString() {
        String inVal = this.getReceiverValues().isEmpty() ? "" : '|' + CollectionsKt.joinToString$default((Iterable)this.getReceiverValues().keySet(), null, null, null, (int)0, null, null, (int)63, null);
        AccessTarget accessTarget = this.getTarget();
        CallableDescriptor callableDescriptor = accessTarget instanceof AccessTarget.Declaration ? (CallableDescriptor)((AccessTarget.Declaration)this.getTarget()).getDescriptor() : (accessTarget instanceof AccessTarget.Call ? ((AccessTarget.Call)this.getTarget()).getResolvedCall().getResultingDescriptor() : null);
        String targetName = callableDescriptor != null && (accessTarget = callableDescriptor.getName()) != null ? accessTarget.asString() : null;
        String elementText = this.render((PsiElement)this.getElement());
        String description = targetName != null && !Intrinsics.areEqual((Object)targetName, (Object)elementText) ? elementText + ", " + targetName : elementText;
        return "r(" + description + inVal + ") -> " + this.getOutputValue();
    }

    @Override
    @NotNull
    protected InstructionImpl createCopy() {
        return new ReadValueInstruction(this.getElement(), this.getBlockScope(), this.getTarget(), this.getReceiverValues(), this.getOutputValue());
    }
}

