/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000fJ\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0016J!\u0010(\u001a\u0002H+\"\u0004\b\u0000\u0010+2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H+0,H\u0016\u00a2\u0006\u0002\u0010-J\n\u0010.\u001a\u00020/H\u0096\u0080\u0004J\b\u00100\u001a\u000201H\u0014J\u0014\u00102\u001a\u00020\u000f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000704J\u0016\u00100\u001a\u0002012\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0013\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/NondeterministicJumpInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstructionImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/JumpInstruction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "targetLabels", "", "Lorg/jetbrains/kotlin/cfg/Label;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "inputValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "_next", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "_resolvedTargets", "", "getTargetLabels", "()Ljava/util/List;", "resolvedTargets", "", "getResolvedTargets", "()Ljava/util/Map;", "setResolvedTarget", "", "label", "resolvedTarget", "value", "next", "getNext", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "setNext", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;)V", "nextInstructions", "", "getNextInstructions", "()Ljava/util/Collection;", "inputValues", "getInputValues", "accept", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "toString", "", "createCopy", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionImpl;", "copy", "newTargetLabels", "", "cfg"})
public final class NondeterministicJumpInstruction
extends KtElementInstructionImpl
implements JumpInstruction {
    @Nullable
    private final PseudoValue inputValue;
    @Nullable
    private Instruction _next;
    @NotNull
    private final Map<Label, Instruction> _resolvedTargets;
    @NotNull
    private final List<Label> targetLabels;

    public NondeterministicJumpInstruction(@NotNull KtElement element, @NotNull List<? extends Label> targetLabels, @NotNull BlockScope blockScope, @Nullable PseudoValue inputValue) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(targetLabels, (String)"targetLabels");
        Intrinsics.checkNotNullParameter((Object)blockScope, (String)"blockScope");
        super(element, blockScope);
        this.inputValue = inputValue;
        this._resolvedTargets = new LinkedHashMap();
        this.targetLabels = new ArrayList(targetLabels);
    }

    @NotNull
    public final List<Label> getTargetLabels() {
        return this.targetLabels;
    }

    private final Map<Label, Instruction> getResolvedTargets() {
        return this._resolvedTargets;
    }

    public final void setResolvedTarget(@NotNull Label label, @NotNull Instruction resolvedTarget) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)resolvedTarget, (String)"resolvedTarget");
        Instruction instruction = this.outgoingEdgeTo(resolvedTarget);
        Intrinsics.checkNotNull((Object)instruction);
        this._resolvedTargets.put(label, instruction);
    }

    @NotNull
    public final Instruction getNext() {
        Instruction instruction = this._next;
        Intrinsics.checkNotNull((Object)instruction);
        return instruction;
    }

    public final void setNext(@NotNull Instruction value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._next = this.outgoingEdgeTo(value);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        ArrayList<Instruction> targetInstructions = new ArrayList<Instruction>(this.getResolvedTargets().values());
        targetInstructions.add(this.getNext());
        return targetInstructions;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.listOfNotNull((Object)this.inputValue);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitNondeterministicJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitNondeterministicJump(this);
    }

    @NotNull
    public String toString() {
        String inVal = this.inputValue != null ? "" + '|' + this.inputValue : "";
        String labels = CollectionsKt.joinToString$default((Iterable)this.targetLabels, (CharSequence)", ", null, null, (int)0, null, NondeterministicJumpInstruction::toString$lambda$0, (int)30, null);
        return "jmp?(" + labels + inVal + ')';
    }

    @Override
    @NotNull
    protected InstructionImpl createCopy() {
        return this.createCopy(this.targetLabels);
    }

    @NotNull
    public final Instruction copy(@NotNull List<Label> newTargetLabels) {
        Intrinsics.checkNotNullParameter(newTargetLabels, (String)"newTargetLabels");
        return this.updateCopyInfo(this.createCopy(newTargetLabels));
    }

    private final InstructionImpl createCopy(List<? extends Label> newTargetLabels) {
        return new NondeterministicJumpInstruction(this.getElement(), newTargetLabels, this.getBlockScope(), this.inputValue);
    }

    private static final CharSequence toString$lambda$0(Label it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

