/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.BackendJsSymbols;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/ir/backend/js/BackendJsSymbols;", "longAsBigInt", "", "longLowGetter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "longHighGetter", "longLowField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "longHighField", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "doNotIntrinsify", "insertNumberConversionInDateConstructorCall", "transformFieldAccess", "access", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nBoxedLongCallsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxedLongCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n351#2,12:101\n351#2,12:113\n1#3:125\n777#4:126\n873#4,2:127\n*S KotlinDebug\n*F\n+ 1 BoxedLongCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer\n*L\n34#1:101,12\n35#1:113,12\n70#1:126\n70#1:127,2\n*E\n"})
public final class BoxedLongCallsTransformer
implements CallsTransformer {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final BackendJsSymbols symbols;
    private final boolean longAsBigInt;
    @Nullable
    private final IrSimpleFunctionSymbol longLowGetter;
    @Nullable
    private final IrSimpleFunctionSymbol longHighGetter;
    @NotNull
    private final IrFieldSymbol longLowField;
    @NotNull
    private final IrFieldSymbol longHighField;

    public BoxedLongCallsTransformer(@NotNull JsIrBackendContext context) {
        IrFieldSymbol it;
        Sequence $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.irBuiltIns = context.getIrBuiltIns();
        this.symbols = context.getSymbols();
        this.longAsBigInt = JSConfigurationKeysKt.getCompileLongAsBigint((CompilerConfiguration)context.getConfiguration());
        this.longLowGetter = AdditionalIrUtilsKt.getPropertyGetter((IrClassSymbol)this.irBuiltIns.getLongClass(), (String)"low");
        this.longHighGetter = AdditionalIrUtilsKt.getPropertyGetter((IrClassSymbol)this.irBuiltIns.getLongClass(), (String)"high");
        Sequence sequence = IrUtilsKt.getFields((IrClassSymbol)this.irBuiltIns.getLongClass());
        BoxedLongCallsTransformer boxedLongCallsTransformer = this;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrFieldSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrField)it.getOwner()).getName().asString(), (Object)"low")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        boxedLongCallsTransformer.longLowField = single$iv;
        $this$single$iv = IrUtilsKt.getFields((IrClassSymbol)this.irBuiltIns.getLongClass());
        boxedLongCallsTransformer = this;
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrFieldSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrField)it.getOwner()).getName().asString(), (Object)"high")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        boxedLongCallsTransformer.longHighField = single$iv;
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (Intrinsics.areEqual((Object)call.getSymbol(), (Object)this.symbols.getJsLongToString())) {
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call, (IrSimpleFunctionSymbol)this.symbols.getLongToStringImpl(), null, null, (int)12, null);
        }
        if (this.longAsBigInt) {
            IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)this.irBuiltIns.getLongClass().getOwner()));
            if (Intrinsics.areEqual((Object)call.getSymbol(), (Object)(irConstructor != null ? irConstructor.getSymbol() : null))) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getLongFromTwoInts();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, null, null, (int)12, null);
            }
        }
        if (this.longAsBigInt) {
            IrSimpleFunction irSimpleFunction = IrJsUtilsKt.getPrimaryConstructorReplacement((IrClass)this.irBuiltIns.getLongClass().getOwner());
            if (Intrinsics.areEqual((Object)call.getSymbol(), (Object)(irSimpleFunction != null ? irSimpleFunction.getSymbol() : null))) {
                IrCall irCall;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getLongFromTwoInts();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                IrCall $this$transformFunctionAccess_u24lambda_u240 = irCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)call, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, null, null, (int)12, null);
                boolean bl = false;
                AddToStdlibKt.assignFrom((List)((List)$this$transformFunctionAccess_u24lambda_u240.getArguments()), (Collection)CollectionsKt.drop((Iterable)((Iterable)call.getArguments()), (int)1));
                return (IrExpression)irCall;
            }
        }
        if (this.longAsBigInt && Intrinsics.areEqual((Object)call.getSymbol(), (Object)this.longLowGetter)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getLongLowBits();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, null, null, (int)12, null);
        }
        if (this.longAsBigInt && Intrinsics.areEqual((Object)call.getSymbol(), (Object)this.longHighGetter)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getLongHighBits();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, null, null, (int)12, null);
        }
        IrExpression irExpression = this.insertNumberConversionInDateConstructorCall(call);
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            return it;
        }
        return (IrExpression)call;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression insertNumberConversionInDateConstructorCall(IrFunctionAccessExpression call) {
        void $this$filterTo$iv$iv;
        if (!this.longAsBigInt) {
            return null;
        }
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)((IrFunctionSymbol)call.getSymbol()).getOwner()));
        if (!Intrinsics.areEqual((Object)(irClass != null && (irClass = AdditionalIrUtilsKt.getClassId((IrClass)irClass)) != null ? irClass.getOutermostClassId() : null), (Object)JsStandardClassIds.Date)) {
            return null;
        }
        Iterable $this$filter$iv = ((IrFunctionSymbol)call.getSymbol()).getOwner().getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrValueParameter it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)this.irBuiltIns.getNumberType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parametersWithNumberType = (List)destination$iv$iv;
        if (parametersWithNumberType.isEmpty()) {
            return null;
        }
        for (IrValueParameter numberParameter : parametersWithNumberType) {
            void $this$insertNumberConversionInDateConstructorCall_u24lambda_u241;
            IrCall irCall;
            IrExpression arg;
            PrimitiveType argPrimitiveType;
            if (call.getArguments().get(numberParameter) == null || CollectionsKt.contains((Iterable)PrimitiveType.NUMBER_TYPES, (Object)(argPrimitiveType = IrTypePredicatesKt.getPrimitiveType((IrType)arg.getType()))) && argPrimitiveType != PrimitiveType.LONG) continue;
            IrCall irCall2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.symbols.getJsNumberToDouble(), null, null, null, null, 0, 0, 126, null);
            IrValueParameter irValueParameter = numberParameter;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = call.getArguments();
            boolean bl = false;
            $this$insertNumberConversionInDateConstructorCall_u24lambda_u241.getArguments().set(0, (Object)arg);
            Unit unit = Unit.INSTANCE;
            valueArgumentsList.set(irValueParameter, (IrExpression)irCall);
        }
        return (IrExpression)call;
    }

    @Override
    @NotNull
    public IrExpression transformFieldAccess(@NotNull IrFieldAccessExpression access) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (this.symbols.getLongLowBits() != null && Intrinsics.areEqual((Object)access.getSymbol(), (Object)this.longLowField)) {
            IrCallImpl irCallImpl;
            IrCallImpl $this$transformFieldAccess_u24lambda_u240 = irCallImpl = BuildersKt.IrCallImpl$default((int)access.getStartOffset(), (int)access.getEndOffset(), (IrType)((IrField)this.longLowField.getOwner()).getType(), (IrSimpleFunctionSymbol)this.symbols.getLongLowBits(), (int)0, null, null, (int)112, null);
            boolean bl = false;
            $this$transformFieldAccess_u24lambda_u240.getArguments().set(0, (Object)access.getReceiver());
            return (IrExpression)irCallImpl;
        }
        if (this.symbols.getLongHighBits() != null && Intrinsics.areEqual((Object)access.getSymbol(), (Object)this.longHighField)) {
            IrCallImpl irCallImpl;
            IrCallImpl $this$transformFieldAccess_u24lambda_u241 = irCallImpl = BuildersKt.IrCallImpl$default((int)access.getStartOffset(), (int)access.getEndOffset(), (IrType)((IrField)this.longHighField.getOwner()).getType(), (IrSimpleFunctionSymbol)this.symbols.getLongHighBits(), (int)0, null, null, (int)112, null);
            boolean bl = false;
            $this$transformFieldAccess_u24lambda_u241.getArguments().set(0, (Object)access.getReceiver());
            return (IrExpression)irCallImpl;
        }
        return (IrExpression)access;
    }
}

