/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ExternalPropertyOverridingLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SwitchOptimizer;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0003H\u0016J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014*\b\u0012\u0004\u0012\u00020\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u0003H\u0016J.\u0010\"\u001a\u00020\u0002*\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00032\u0018\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%\u0012\u0004\u0012\u00020\u00020$H\u0002J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020(2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020.2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u0002002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002022\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002042\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002062\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020;2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010?\u001a\u00020\u00022\u0006\u0010=\u001a\u00020@2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "context", "visitReturnableBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "wrapInCommentsInlineFunctionCall", "", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "maybeOptimizeIntoSwitch", "transformer", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitDoWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrElementToJsStatementTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n+ 2 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n28#2:255\n29#2:257\n1#3:256\n1#3:274\n1586#4:258\n1661#4,3:259\n1586#4:262\n1661#4,3:263\n1586#4:266\n1661#4,3:267\n1586#4:270\n1661#4,3:271\n*S KotlinDebug\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n*L\n37#1:255\n37#1:257\n37#1:256\n43#1:258\n43#1:259,3\n55#1:262\n55#1:263,3\n68#1:266\n68#1:267,3\n84#1:270\n84#1:271,3\n*E\n"})
public final class IrElementToJsStatementTransformer
extends BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @NotNull
    public JsStatement visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data) {
        IrExceptionBuilder irExceptionBuilder;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String message$iv = "All functions must be already lowered";
        boolean $i$f$irError = false;
        IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
        boolean bl = false;
        IrExceptionBuilder $this$visitFunction_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$visitFunction_u24lambda_u240.withIrEntry("declaration", (IrElement)declaration);
        IrExceptionBuilder builder$iv = irExceptionBuilder;
        throw new IllegalStateException(builder$iv.buildString().toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = body.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it.accept((IrVisitor)this, (Object)context));
        }
        List list = MemoryOptimizedCollectionUtilKt.toSmartList((Collection)((List)destination$iv$iv));
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(list), (IrElement)body, context, null, (IrDeclaration)context.getCurrentFunction(), 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsStatement visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        Object object;
        JsGenerationContext newContext;
        JsGenerationContext jsGenerationContext;
        IrInlinedFunctionBlock inlinedBlock;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object2 = CollectionsKt.singleOrNull((List)expression2.getStatements());
        IrInlinedFunctionBlock irInlinedFunctionBlock = inlinedBlock = object2 instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)object2 : null;
        if (inlinedBlock != null) {
            IrFunctionSymbol irFunctionSymbol = inlinedBlock.getInlinedFunctionSymbol();
            jsGenerationContext = context.newInlineFunction(inlinedBlock.getInlinedFunctionFileEntry(), (IrFunction)(irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null));
        } else {
            jsGenerationContext = newContext = context;
        }
        if ((object = inlinedBlock) == null || (object = object.getStatements()) == null) {
            object = expression2.getStatements();
        }
        Object container = object;
        Iterable $this$map$iv = (Iterable)container;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it.accept((IrVisitor)this, (Object)newContext));
        }
        List statements = MemoryOptimizedCollectionUtilKt.toSmartList((Collection)((List)destination$iv$iv));
        JsName label = context.getNameForReturnableBlock(expression2);
        List<JsStatement> wrappedStatements = this.wrapInCommentsInlineFunctionCall(statements, inlinedBlock);
        return (JsStatement)JsAstUtilsKt.withSource$default(label != null ? (JsNode)new JsLabel(label, new JsBlock(wrappedStatements)) : (JsNode)new JsCompositeBlock((List<? extends JsStatement>)wrappedStatements), (IrElement)expression2, context, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsStatement visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = expression2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it.accept((IrVisitor)this, (Object)context));
        }
        List statements = MemoryOptimizedCollectionUtilKt.toSmartList((Collection)((List)destination$iv$iv));
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(statements), (IrElement)expression2, context, null, null, 12, null);
    }

    private final List<JsStatement> wrapInCommentsInlineFunctionCall(List<? extends JsStatement> $this$wrapInCommentsInlineFunctionCall, IrInlinedFunctionBlock inlinedBlock) {
        IrElement owner;
        IrInlinedFunctionBlock irInlinedFunctionBlock = inlinedBlock;
        if (irInlinedFunctionBlock == null || (irInlinedFunctionBlock = irInlinedFunctionBlock.getInlinedFunctionSymbol()) == null || (irInlinedFunctionBlock = irInlinedFunctionBlock.getOwner()) == null) {
            return $this$wrapInCommentsInlineFunctionCall;
        }
        IrInlinedFunctionBlock inlinedFunction = irInlinedFunctionBlock;
        IrSimpleFunction irSimpleFunction = inlinedFunction instanceof IrSimpleFunction ? (IrSimpleFunction)inlinedFunction : null;
        Object correspondingProperty = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        IrPropertySymbol irPropertySymbol = correspondingProperty;
        IrElement irElement = owner = irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? (IrElement)irPropertySymbol : (IrElement)inlinedFunction;
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)owner));
        if (fqName == null) {
            fqName = ((IrDeclarationWithName)owner).getName();
        }
        FqName funName = fqName;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsSingleLineComment(" Inline function '" + funName + "' call")), (Iterable)$this$wrapInCommentsInlineFunctionCall);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (expression2.getStatements().isEmpty()) {
            jsStatement = JsEmpty.INSTANCE;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expression2.getStatements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrStatement irStatement = (IrStatement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((JsStatement)it.accept((IrVisitor)this, (Object)context));
            }
            List list = MemoryOptimizedCollectionUtilKt.toSmartList((Collection)((List)destination$iv$iv));
            jsStatement = (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(list), (IrElement)expression2, context, null, null, 12, null);
        }
        return jsStatement;
    }

    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsStatement jsStatement = ((JsExpression)expression2.accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsStatement jsStatement = ((JsFunction)expression2.getFunction().accept((IrVisitor)new IrFunctionToJsTransformer(), (Object)context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBreak(jsNameRef2), (IrElement)jump, context, null, null, 12, null);
    }

    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsContinue(jsNameRef2), (IrElement)jump, context, null, null, 12, null);
    }

    private final JsStatement maybeOptimizeIntoSwitch(IrExpression $this$maybeOptimizeIntoSwitch, JsGenerationContext context, Function1<? super Function0<? extends JsExpression>, ? extends JsStatement> transformer2) {
        Function1 stmtTransformer;
        JsStatement jsStatement;
        if ($this$maybeOptimizeIntoSwitch instanceof IrWhen && (jsStatement = new SwitchOptimizer(context, true, (Function1<? super Function0<? extends JsStatement>, ? extends JsStatement>)(stmtTransformer = arg_0 -> IrElementToJsStatementTransformer.maybeOptimizeIntoSwitch$lambda$0(transformer2, $this$maybeOptimizeIntoSwitch, arg_0))).tryOptimize((IrWhen)$this$maybeOptimizeIntoSwitch)) != null) {
            JsStatement it = jsStatement;
            boolean bl = false;
            return it;
        }
        return (JsStatement)transformer2.invoke(() -> IrElementToJsStatementTransformer.maybeOptimizeIntoSwitch$lambda$2($this$maybeOptimizeIntoSwitch, context));
    }

    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName fieldName = context.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrElementToJsExpressionTransformer expressionTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(fieldName, irExpression != null ? (JsExpression)irExpression.accept((IrVisitor)expressionTransformer, (Object)context) : null);
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)arg_0 -> IrElementToJsStatementTransformer.visitSetField$lambda$0(dest, expression2, context, arg_0)));
    }

    @NotNull
    public JsStatement visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context.getNameForValueDeclaration((IrDeclarationWithName)owner));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)arg_0 -> IrElementToJsStatementTransformer.visitSetValue$lambda$0(ref, expression2, context, arg_0)));
    }

    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrReturnTargetSymbol targetSymbol = expression2.getReturnTargetSymbol();
        if (targetSymbol instanceof IrReturnableBlockSymbol) {
            function1 = arg_0 -> IrElementToJsStatementTransformer.visitReturn$lambda$0(context, targetSymbol, expression2, arg_0);
        } else if (targetSymbol instanceof IrFunctionSymbol) {
            function1 = IrElementToJsStatementTransformer::visitReturn$lambda$1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function1 lastStatementTransformer = function1;
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)lastStatementTransformer), (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)IrElementToJsStatementTransformer::visitThrow$lambda$0)), (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext context) {
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName varName = context.getNameForValueDeclaration((IrDeclarationWithName)declaration);
        IrExpression value = declaration.getInitializer();
        if (value instanceof IrWhen) {
            JsNameRef jsNameRef = varName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            JsNameRef varRef = jsNameRef;
            Function1 transformer2 = arg_0 -> IrElementToJsStatementTransformer.visitVariable$lambda$0(varRef, arg_0);
            object = new SwitchOptimizer(context, true, (Function1<? super Function0<? extends JsStatement>, ? extends JsStatement>)transformer2).tryOptimize((IrWhen)value);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                JsStatement[] jsStatementArray = new JsStatement[]{new JsVars(JsVars.Variant.Var, new JsVars.JsVar(varName, null, 2, null)), it};
                return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(jsStatementArray), (IrElement)declaration, context, null, null, 12, null);
            }
        }
        IrExpression irExpression = value;
        JsExpression jsInitializer = irExpression != null ? (JsExpression)irExpression.accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context) : null;
        object = declaration.getOrigin();
        boolean syntheticVariable = Intrinsics.areEqual((Object)object, (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) ? true : (Intrinsics.areEqual((Object)object, (Object)ExternalPropertyOverridingLoweringKt.getEXTERNAL_SUPER_ACCESSORS_ORIGIN()) ? true : (Intrinsics.areEqual((Object)object, (Object)ES6ConstructorLoweringKt.getES6_DELEGATING_CONSTRUCTOR_CALL_REPLACEMENT()) ? true : IrInlineUtilsKt.isTmpForInline((IrVariable)declaration)));
        JsVars.JsVar $this$visitVariable_u24lambda_u242 = sourceInfoAwareJsNode = new JsVars.JsVar(varName, jsInitializer);
        boolean bl = false;
        JsAstUtilsKt.withSource$default($this$visitVariable_u24lambda_u242, (IrElement)declaration, context, (IrDeclarationWithName)declaration, null, 8, null);
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u242, syntheticVariable);
        MetadataProperties.setWasMovedFromItsDeclarationPlace($this$visitVariable_u24lambda_u242, JsIrAttributesKt.getWasMovedFromItsDeclarationPlace(declaration));
        JsVars.JsVar variable = sourceInfoAwareJsNode;
        SourceInfoAwareJsNode $this$visitVariable_u24lambda_u243 = sourceInfoAwareJsNode = new JsVars(JsVars.Variant.Var, variable);
        boolean bl2 = false;
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u243, syntheticVariable);
        return (JsStatement)((Object)sourceInfoAwareJsNode);
    }

    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (IrTypePredicatesKt.isAny((IrType)IrUtilsKt.getConstructedClassType((IrConstructor)((IrConstructor)expression2.getSymbol().getOwner())))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (IrJsUtilsKt.isUnitInstanceFunction((IrFunctionSymbol)expression2.getSymbol(), data.getStaticContext().getBackendContext())) {
            return JsEmpty.INSTANCE;
        }
        if (data.checkIfJsCode((IrFunctionSymbol)expression2.getSymbol()) || data.checkIfHasAssociatedJsCode((IrFunctionSymbol)expression2.getSymbol())) {
            return new JsCallTransformer(expression2, data).generateStatement();
        }
        JsStatement jsStatement = ((JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.translateCall(expression2, data, new IrElementToJsExpressionTransformer()), (IrElement)expression2, data, null, null, 12, null)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return JsEmpty.INSTANCE;
    }

    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context) {
        JsCatch jsCatch;
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept((IrVisitor)this, (Object)context));
        IrCatch irCatch = (IrCatch)CollectionsKt.singleOrNull((List)aTry.getCatches());
        if (irCatch != null) {
            IrCatch it = irCatch;
            boolean bl = false;
            JsName name = context.getNameForValueDeclaration((IrDeclarationWithName)it.getCatchParameter());
            JsStatement jsCatchBlock = (JsStatement)it.getResult().accept((IrVisitor)this, (Object)context);
            jsCatch = (JsCatch)JsAstUtilsKt.withSource$default(new JsCatch(JsGenerationContextKt.getEmptyScope(), name.getIdent(), jsCatchBlock), (IrElement)it, context, null, null, 12, null);
        } else {
            jsCatch = null;
        }
        JsCatch jsCatch2 = jsCatch;
        Object object = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = object != null && (object = (JsStatement)object.accept((IrVisitor)this, (Object)context)) != null ? JsAstUtilsKt.asBlock((JsStatement)object) : null;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock), (IrElement)aTry, context, null, null, 12, null);
    }

    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsStatement jsStatement = new SwitchOptimizer(context).tryOptimize(expression2);
        if (jsStatement == null && (jsStatement = (JsStatement)JsAstUtilsKt.toJsNode$default(expression2, this, context, visitWhen.1.INSTANCE, null, 8, null)) == null) {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName label = context.getNameForLoop((IrLoop)loop);
        JsExpression jsExpression = (JsExpression)loop.getCondition().accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context);
        Object object = loop.getBody();
        if (object == null || (object = (JsStatement)object.accept((IrVisitor)this, (Object)context)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsWhile loopStatement = new JsWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName label = context.getNameForLoop((IrLoop)loop);
        JsExpression jsExpression = (JsExpression)loop.getCondition().accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context);
        Object object = loop.getBody();
        if (object == null || (object = (JsStatement)object.accept((IrVisitor)this, (Object)context)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsDoWhile loopStatement = new JsDoWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    private static final JsExpression maybeOptimizeIntoSwitch$lambda$0$0(Function0 $it, IrExpression $this_maybeOptimizeIntoSwitch) {
        JsStatement stmt = (JsStatement)$it.invoke();
        boolean bl = stmt instanceof JsExpressionStatement;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = RenderIrElementKt.render$default((IrElement)((IrElement)$this_maybeOptimizeIntoSwitch), null, (int)1, null) + " is not a statement " + stmt;
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)stmt, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
        JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
        return jsExpression;
    }

    private static final JsStatement maybeOptimizeIntoSwitch$lambda$0(Function1 $transformer, IrExpression $this_maybeOptimizeIntoSwitch, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JsStatement)$transformer.invoke(() -> IrElementToJsStatementTransformer.maybeOptimizeIntoSwitch$lambda$0$0(it, $this_maybeOptimizeIntoSwitch));
    }

    private static final JsExpression maybeOptimizeIntoSwitch$lambda$2(IrExpression $this_maybeOptimizeIntoSwitch, JsGenerationContext $context) {
        return (JsExpression)$this_maybeOptimizeIntoSwitch.accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)$context);
    }

    private static final JsStatement visitSetField$lambda$0(JsExpression $dest, IrSetField $expression, JsGenerationContext $context, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment($dest, (JsExpression)it.invoke()), (IrElement)$expression, $context, null, null, 12, null)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    private static final JsStatement visitSetValue$lambda$0(JsNameRef $ref, IrSetValue $expression, JsGenerationContext $context, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment($ref, (JsExpression)it.invoke()), (IrElement)$expression, $context, null, null, 12, null)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    private static final JsStatement visitReturn$lambda$0(JsGenerationContext $context, IrReturnTargetSymbol $targetSymbol, IrReturn $expression, Function0 it) {
        JsStatement jsStatement;
        JsName jsName;
        JsName jsName2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsName it2 = jsName2 = $context.getNameForReturnableBlock((IrReturnableBlock)((IrReturnableBlockSymbol)$targetSymbol).getOwner());
        boolean bl = false;
        JsName jsName3 = jsName = !IrJsUtilsKt.isTheLastReturnStatementIn($expression, (IrReturnableBlockSymbol)$targetSymbol) ? jsName2 : null;
        if (jsName != null) {
            JsName $this$visitReturn_u24lambda_u240_u241 = jsName;
            boolean bl2 = false;
            jsStatement = new JsBreak($this$visitReturn_u24lambda_u240_u241.makeRef());
        } else {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    private static final JsStatement visitReturn$lambda$1(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new JsReturn((JsExpression)it.invoke());
    }

    private static final JsStatement visitThrow$lambda$0(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new JsThrow((JsExpression)it.invoke());
    }

    private static final JsStatement visitVariable$lambda$0(JsNameRef $varRef, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.invoke();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
        JsExpression jsExpression = ((JsExpressionStatement)object).getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
        JsExpression expr = jsExpression;
        JsStatement jsStatement = new JsBinaryOperation(JsBinaryOperator.ASG, $varRef, expr).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }
}

