/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.antlr;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.parser.CodePosition;
import org.jetbrains.kotlin.js.parser.antlr.generated.JavaScriptParser;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\fH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0011*\u00020\fH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\fH\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0011*\u00020\fH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\n\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0018"}, d2={"startPosition", "Lorg/jetbrains/kotlin/js/parser/CodePosition;", "Lorg/antlr/v4/runtime/ParserRuleContext;", "getStartPosition", "(Lorg/antlr/v4/runtime/ParserRuleContext;)Lorg/jetbrains/kotlin/js/parser/CodePosition;", "Lorg/antlr/v4/runtime/tree/TerminalNode;", "(Lorg/antlr/v4/runtime/tree/TerminalNode;)Lorg/jetbrains/kotlin/js/parser/CodePosition;", "stopPosition", "getStopPosition", "Lorg/antlr/v4/runtime/Token;", "(Lorg/antlr/v4/runtime/Token;)Lorg/jetbrains/kotlin/js/parser/CodePosition;", "unwrapStringLiteral", "", "literalValue", "toStringLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsStringLiteral;", "toDecimalLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsNumberLiteral;", "toHexLiteral", "toOctalLiteral", "toVarVariant", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$Variant;", "Lorg/jetbrains/kotlin/js/parser/antlr/generated/JavaScriptParser$VarModifierContext;", "toBinaryLiteral", "js.parser"})
@SourceDebugExtension(value={"SMAP\nJsAstExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAstExtensions.kt\norg/jetbrains/kotlin/js/parser/antlr/JsAstExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class JsAstExtensionsKt {
    @NotNull
    public static final CodePosition getStartPosition(@NotNull ParserRuleContext $this$startPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$startPosition, (String)"<this>");
        Token token = $this$startPosition.start;
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"start");
        return JsAstExtensionsKt.getStartPosition(token);
    }

    @NotNull
    public static final CodePosition getStartPosition(@NotNull TerminalNode $this$startPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$startPosition, (String)"<this>");
        Token token = $this$startPosition.getSymbol();
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"getSymbol(...)");
        return JsAstExtensionsKt.getStartPosition(token);
    }

    @NotNull
    public static final CodePosition getStopPosition(@NotNull ParserRuleContext $this$stopPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$stopPosition, (String)"<this>");
        Token token = $this$stopPosition.stop;
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"stop");
        return JsAstExtensionsKt.getStopPosition(token);
    }

    @NotNull
    public static final CodePosition getStopPosition(@NotNull TerminalNode $this$stopPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$stopPosition, (String)"<this>");
        Token token = $this$stopPosition.getSymbol();
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"getSymbol(...)");
        return JsAstExtensionsKt.getStopPosition(token);
    }

    @NotNull
    public static final CodePosition getStartPosition(@NotNull Token $this$startPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$startPosition, (String)"<this>");
        return new CodePosition($this$startPosition.getLine() - 1, $this$startPosition.getCharPositionInLine());
    }

    @NotNull
    public static final CodePosition getStopPosition(@NotNull Token $this$stopPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$stopPosition, (String)"<this>");
        String string = $this$stopPosition.getText();
        if (string == null) {
            string = "";
        }
        String text = string;
        List lines = StringsKt.lines((CharSequence)text);
        int endLine = JsAstExtensionsKt.getStartPosition($this$stopPosition).getLine() + lines.size() - 1;
        int it = ((String)CollectionsKt.last((List)lines)).length();
        boolean bl = false;
        int endColumn = lines.size() > 1 ? it : JsAstExtensionsKt.getStartPosition($this$stopPosition).getOffset() + it;
        return new CodePosition(endLine, endColumn);
    }

    @NotNull
    public static final String unwrapStringLiteral(@NotNull String literalValue) {
        Intrinsics.checkNotNullParameter((Object)literalValue, (String)"literalValue");
        String $this$unwrapStringLiteral_u24lambda_u240 = literalValue;
        boolean bl = false;
        if (StringsKt.startsWith$default((String)$this$unwrapStringLiteral_u24lambda_u240, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$unwrapStringLiteral_u24lambda_u240, (String)"'", (boolean)false, (int)2, null)) {
            return StringsKt.removeSurrounding((String)$this$unwrapStringLiteral_u24lambda_u240, (CharSequence)"'");
        }
        if (StringsKt.startsWith$default((String)$this$unwrapStringLiteral_u24lambda_u240, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$unwrapStringLiteral_u24lambda_u240, (String)"\"", (boolean)false, (int)2, null)) {
            return StringsKt.removeSurrounding((String)$this$unwrapStringLiteral_u24lambda_u240, (CharSequence)"\"");
        }
        return $this$unwrapStringLiteral_u24lambda_u240;
    }

    @NotNull
    public static final JsStringLiteral toStringLiteral(@NotNull String $this$toStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringLiteral, (String)"<this>");
        return new JsStringLiteral(JsAstExtensionsKt.unwrapStringLiteral($this$toStringLiteral));
    }

    @NotNull
    public static final JsNumberLiteral toDecimalLiteral(@NotNull String $this$toDecimalLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toDecimalLiteral, (String)"<this>");
        Integer intValue = StringsKt.toIntOrNull((String)$this$toDecimalLiteral);
        if (intValue != null) {
            return new JsIntLiteral(intValue);
        }
        return new JsDoubleLiteral(Double.parseDouble($this$toDecimalLiteral));
    }

    @NotNull
    public static final JsNumberLiteral toHexLiteral(@NotNull String $this$toHexLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexLiteral, (String)"<this>");
        String cleanHex = StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$toHexLiteral, (CharSequence)"0x"), (CharSequence)"0X");
        long longValue = Long.parseLong(cleanHex, CharsKt.checkRadix((int)16));
        return (Integer.MIN_VALUE <= longValue ? longValue <= Integer.MAX_VALUE : false) ? (JsNumberLiteral)new JsIntLiteral((int)longValue) : (JsNumberLiteral)new JsDoubleLiteral(longValue);
    }

    @NotNull
    public static final JsNumberLiteral toOctalLiteral(@NotNull String $this$toOctalLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toOctalLiteral, (String)"<this>");
        long longValue = Long.parseLong(StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$toOctalLiteral, (CharSequence)"0"), (CharSequence)"O"), (CharSequence)"o"), CharsKt.checkRadix((int)8));
        return (Integer.MIN_VALUE <= longValue ? longValue <= Integer.MAX_VALUE : false) ? (JsNumberLiteral)new JsIntLiteral((int)longValue) : (JsNumberLiteral)new JsDoubleLiteral(longValue);
    }

    @Nullable
    public static final JsVars.Variant toVarVariant(@NotNull JavaScriptParser.VarModifierContext $this$toVarVariant) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toVarVariant), (String)"<this>");
        return $this$toVarVariant.Var() != null ? JsVars.Variant.Var : ($this$toVarVariant.let_() != null ? JsVars.Variant.Let : ($this$toVarVariant.Const() != null ? JsVars.Variant.Const : null));
    }

    @NotNull
    public static final JsNumberLiteral toBinaryLiteral(@NotNull String $this$toBinaryLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryLiteral, (String)"<this>");
        long longValue = Long.parseLong(StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$toBinaryLiteral, (CharSequence)"0b"), (CharSequence)"0B"), CharsKt.checkRadix((int)2));
        return (Integer.MIN_VALUE <= longValue ? longValue <= Integer.MAX_VALUE : false) ? (JsNumberLiteral)new JsIntLiteral((int)longValue) : (JsNumberLiteral)new JsDoubleLiteral(longValue);
    }
}

