/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryResolutionResultsCache;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache;", "parentCache", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache;)V", "innerCache", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCacheImpl;", "record", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "deferredComputation", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "resolutionTrace", "Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;", "get", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache$CachedData;", "commit", "frontend"})
public final class TemporaryResolutionResultsCache
implements ResolutionResultsCache {
    @NotNull
    private final ResolutionResultsCache parentCache;
    @NotNull
    private final ResolutionResultsCacheImpl innerCache;

    public TemporaryResolutionResultsCache(@NotNull ResolutionResultsCache parentCache) {
        Intrinsics.checkNotNullParameter((Object)parentCache, (String)"parentCache");
        this.parentCache = parentCache;
        this.innerCache = new ResolutionResultsCacheImpl();
    }

    public void record(@NotNull Call call, @NotNull OverloadResolutionResultsImpl<? extends CallableDescriptor> results, @NotNull BasicCallResolutionContext deferredComputation, @NotNull TracingStrategy tracing, @NotNull DelegatingBindingTrace resolutionTrace) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)deferredComputation, (String)"deferredComputation");
        Intrinsics.checkNotNullParameter((Object)tracing, (String)"tracing");
        Intrinsics.checkNotNullParameter((Object)resolutionTrace, (String)"resolutionTrace");
        this.innerCache.record(call, results, deferredComputation, tracing, resolutionTrace);
    }

    @Override
    @Nullable
    public ResolutionResultsCache.CachedData get(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        ResolutionResultsCache.CachedData cachedData = this.innerCache.get(call);
        if (cachedData == null) {
            cachedData = this.parentCache.get(call);
        }
        return cachedData;
    }

    public final void commit() {
        ResolutionResultsCache resolutionResultsCache = this.parentCache;
        if (resolutionResultsCache instanceof ResolutionResultsCacheImpl) {
            ((ResolutionResultsCacheImpl)this.parentCache).addData(this.innerCache);
        } else if (resolutionResultsCache instanceof TemporaryResolutionResultsCache) {
            ((TemporaryResolutionResultsCache)this.parentCache).innerCache.addData(this.innerCache);
        }
    }
}

