/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.kotlin.metrics.cyclomaticComplexity;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.qodana.jvm.kotlin.metrics.cyclomaticComplexity.KotlinCyclomaticComplexityMethodVisitor;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.PsiKt;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.VisitorLanguage;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.cyclomaticComplexity.CyclomaticComplexityMethodData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/jvm/kotlin/metrics/cyclomaticComplexity/KotlinCyclomaticComplexityMetricFileVisitor;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMetricFileVisitor;", "<init>", "()V", "language", "", "getLanguage", "()Ljava/lang/String;", "visit", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMethodData;", "file", "Lcom/intellij/psi/PsiFile;", "CyclomaticComplexityMetricFileVisitor", "intellij.qodana.jvm.kotlin"})
public final class KotlinCyclomaticComplexityMetricFileVisitor
implements org.jetbrains.qodana.staticAnalysis.inspections.metrics.inspections.cyclomaticComplexity.CyclomaticComplexityMetricFileVisitor {
    @Override
    @NotNull
    public String getLanguage() {
        return VisitorLanguage.KOTLIN.getId();
    }

    @Override
    @NotNull
    public List<CyclomaticComplexityMethodData> visit(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CyclomaticComplexityMetricFileVisitor fileVisitor = new CyclomaticComplexityMetricFileVisitor();
        PsiKt.iterateFileContents$default(file2, (PsiElementVisitor)fileVisitor, null, null, 6, null);
        return fileVisitor.getMethodDataList();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/qodana/jvm/kotlin/metrics/cyclomaticComplexity/KotlinCyclomaticComplexityMetricFileVisitor$CyclomaticComplexityMetricFileVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "<init>", "()V", "_methodDataList", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/metrics/inspections/cyclomaticComplexity/CyclomaticComplexityMethodData;", "methodDataList", "", "getMethodDataList", "()Ljava/util/List;", "visitCallableElement", "", "callableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "name", "", "resolveName", "ktElement", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClassInitializer", "initializer", "Lorg/jetbrains/kotlin/psi/KtClassInitializer;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "intellij.qodana.jvm.kotlin"})
    private static final class CyclomaticComplexityMetricFileVisitor
    extends KtVisitorVoid {
        @NotNull
        private final List<CyclomaticComplexityMethodData> _methodDataList = new ArrayList();
        @NotNull
        private final List<CyclomaticComplexityMethodData> methodDataList = this._methodDataList;

        @NotNull
        public final List<CyclomaticComplexityMethodData> getMethodDataList() {
            return this.methodDataList;
        }

        private final void visitCallableElement(KtElement callableElement, String name) {
            KotlinCyclomaticComplexityMethodVisitor methodVisitor = new KotlinCyclomaticComplexityMethodVisitor();
            callableElement.acceptChildren((PsiElementVisitor)methodVisitor);
            int cyclomaticComplexityValue = methodVisitor.getCyclomaticComplexityValue();
            int n = callableElement.getTextRange().getStartOffset();
            CyclomaticComplexityMethodData methodData = new CyclomaticComplexityMethodData(name, n, cyclomaticComplexityValue);
            this._methodDataList.add(methodData);
        }

        private final String resolveName(KtElement ktElement) {
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.parents((PsiElement)((PsiElement)ktElement), (boolean)true), CyclomaticComplexityMetricFileVisitor::resolveName$lambda$0), CyclomaticComplexityMetricFileVisitor::resolveName$lambda$1))), (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            if (!function.hasBody()) {
                return;
            }
            String name = "function: " + this.resolveName((KtElement)function);
            this.visitCallableElement((KtElement)function, name);
        }

        public void visitClassInitializer(@NotNull KtClassInitializer initializer) {
            Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
            String name = "init: " + this.resolveName((KtElement)initializer);
            this.visitCallableElement((KtElement)initializer, name);
        }

        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            String name = "secondary constructor: " + this.resolveName((KtElement)constructor);
            this.visitCallableElement((KtElement)constructor, name);
        }

        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
            String name = "lambda: " + this.resolveName((KtElement)lambdaExpression);
            this.visitCallableElement((KtElement)lambdaExpression, name);
        }

        private static final boolean resolveName$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof KtNamedFunction || it instanceof KtClass || it instanceof KtVariableDeclaration;
        }

        private static final String resolveName$lambda$1(PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtNamedFunction ktNamedFunction = element instanceof KtNamedFunction ? (KtNamedFunction)element : null;
            String functionName = ktNamedFunction != null ? ktNamedFunction.getName() : null;
            KtClass ktClass = element instanceof KtClass ? (KtClass)element : null;
            String className = ktClass != null ? ktClass.getName() : null;
            KtVariableDeclaration ktVariableDeclaration = element instanceof KtVariableDeclaration ? (KtVariableDeclaration)element : null;
            String variableName = ktVariableDeclaration != null ? ktVariableDeclaration.getName() : null;
            String string = functionName;
            if (string == null && (string = className) == null) {
                string = variableName;
            }
            return string;
        }
    }
}

