/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.qodana.sarif.model.Notification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.profile.GroupState;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.profile.Thresholds;
import org.jetbrains.qodana.staticAnalysis.sarif.notifications.RuntimeNotificationCollector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/StateWithThreshold;", "Lorg/jetbrains/qodana/staticAnalysis/profile/GroupState;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "inspectionGroup", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;)V", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "thresholds", "Lorg/jetbrains/qodana/staticAnalysis/profile/Thresholds;", "shouldSkip", "", "inspectionId", "", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "onConsumeProblem", "relativePath", "module", "onFinish", "", "getProblemCounters", "Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nthresholds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 thresholds.kt\norg/jetbrains/qodana/staticAnalysis/profile/StateWithThreshold\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,159:1\n2296#2,2:160\n30#3,2:162\n*S KotlinDebug\n*F\n+ 1 thresholds.kt\norg/jetbrains/qodana/staticAnalysis/profile/StateWithThreshold\n*L\n28#1:160,2\n43#1:162,2\n*E\n"})
public final class StateWithThreshold
extends GroupState {
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final Thresholds thresholds;

    public StateWithThreshold(@NotNull QodanaGlobalInspectionContext context, @NotNull NamedInspectionGroup inspectionGroup) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
        super(context, inspectionGroup);
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        this.macroManager = pathMacroManager;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.thresholds = new Thresholds(project, context.getConfig());
    }

    @Override
    public boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file2, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
            QodanaProfile profile2 = this.getContext().getProfile();
            Sequence $this$none$iv = wrappers.getAllWrappers();
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                InspectionToolWrapper it = (InspectionToolWrapper)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)profile2.getIdToEffectiveGroup().get(it.getShortName()), (Object)profile2.getMainGroup())) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            return true;
        }
        String path = this.macroManager.collapsePath(file2.getVirtualFile().getUrl());
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file2);
        String module2 = module != null ? module.getName() : null;
        return this.thresholds.isReached(inspectionId, path, module2);
    }

    @Override
    public boolean onConsumeProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        boolean isThresholdReached = this.thresholds.addProblem(inspectionId, relativePath, module);
        if (isThresholdReached) {
            return false;
        }
        return super.onConsumeProblem(inspectionId, relativePath, module);
    }

    @Override
    public void onFinish() {
        Notification notification = this.thresholds.constructNotification();
        if (notification == null) {
            return;
        }
        Notification sanityNotification = notification;
        Project project = this.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RuntimeNotificationCollector> serviceClass$iv = RuntimeNotificationCollector.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((RuntimeNotificationCollector)object).add(sanityNotification);
    }

    @Nullable
    public final ProblemCounters getProblemCounters(@NotNull String inspectionId) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        return this.thresholds.getProblemCounters().get(inspectionId);
    }
}

