/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.link;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.OriginSupportKt;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.cloud.project.QodanaCloudProjectsPagedLoader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/qodana/ui/link/QodanaCloudProjectRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/qodana/cloud/project/QodanaCloudProjectsPagedLoader$ProjectData;", "<init>", "()V", "teamInsetsLeft", "Lcom/intellij/util/ui/JBInsets;", "projectInsetsLeft", "emptyTopBottomBorder", "Lcom/intellij/util/ui/JBEmptyBorder;", "teamNameComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "teamDescriptionComponent", "teamRenderer", "Ljavax/swing/JPanel;", "projectNameComponent", "projectVcsUrlComponent", "projectProblemsCountComponent", "projectBranchComponent", "projectLastRunComponent", "projectRenderer", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "cloudProject", "index", "", "isSelected", "", "cellHasFocus", "fillProjectComponents", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudProjectRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudProjectRenderer.kt\norg/jetbrains/qodana/ui/link/QodanaCloudProjectRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class QodanaCloudProjectRenderer
implements ListCellRenderer<QodanaCloudProjectsPagedLoader.ProjectData> {
    @NotNull
    private final JBInsets teamInsetsLeft;
    @NotNull
    private final JBInsets projectInsetsLeft;
    @NotNull
    private final JBEmptyBorder emptyTopBottomBorder;
    @NotNull
    private final SimpleColoredComponent teamNameComponent;
    @NotNull
    private final SimpleColoredComponent teamDescriptionComponent;
    @NotNull
    private final JPanel teamRenderer;
    @NotNull
    private final SimpleColoredComponent projectNameComponent;
    @NotNull
    private final SimpleColoredComponent projectVcsUrlComponent;
    @NotNull
    private final SimpleColoredComponent projectProblemsCountComponent;
    @NotNull
    private final SimpleColoredComponent projectBranchComponent;
    @NotNull
    private final SimpleColoredComponent projectLastRunComponent;
    @NotNull
    private final JPanel projectRenderer;

    /*
     * WARNING - void declaration
     */
    public QodanaCloudProjectRenderer() {
        JPanel jPanel;
        JPanel jPanel2;
        void $this$projectRenderer_u24lambda_u240;
        Object $this$projectProblemsCountComponent_u24lambda_u240;
        Object $this$projectNameComponent_u24lambda_u240;
        Object $this$teamRenderer_u24lambda_u240;
        Object $this$teamDescriptionComponent_u24lambda_u240;
        SimpleColoredComponent $this$teamNameComponent_u24lambda_u240;
        Object object;
        JBInsets jBInsets = JBUI.insetsLeft((int)10);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsLeft(...)");
        this.teamInsetsLeft = jBInsets;
        JBInsets jBInsets2 = JBUI.insetsLeft((int)30);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets2, (String)"insetsLeft(...)");
        this.projectInsetsLeft = jBInsets2;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)4, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        this.emptyTopBottomBorder = jBEmptyBorder;
        SimpleColoredComponent simpleColoredComponent = object = new SimpleColoredComponent();
        QodanaCloudProjectRenderer qodanaCloudProjectRenderer = this;
        boolean bl = false;
        $this$teamNameComponent_u24lambda_u240.setIpad((Insets)this.teamInsetsLeft);
        qodanaCloudProjectRenderer.teamNameComponent = object;
        $this$teamNameComponent_u24lambda_u240 = object = new SimpleColoredComponent();
        qodanaCloudProjectRenderer = this;
        boolean bl2 = false;
        $this$teamDescriptionComponent_u24lambda_u240.setIpad((Insets)this.teamInsetsLeft);
        qodanaCloudProjectRenderer.teamDescriptionComponent = object;
        $this$teamDescriptionComponent_u24lambda_u240 = object = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        qodanaCloudProjectRenderer = this;
        boolean bl3 = false;
        $this$teamRenderer_u24lambda_u240.add((Component)this.teamNameComponent);
        $this$teamRenderer_u24lambda_u240.add((Component)this.teamDescriptionComponent);
        $this$teamRenderer_u24lambda_u240.setBorder((Border)this.emptyTopBottomBorder);
        qodanaCloudProjectRenderer.teamRenderer = object;
        $this$teamRenderer_u24lambda_u240 = object = new SimpleColoredComponent();
        qodanaCloudProjectRenderer = this;
        boolean bl4 = false;
        $this$projectNameComponent_u24lambda_u240.setIpad((Insets)this.projectInsetsLeft);
        qodanaCloudProjectRenderer.projectNameComponent = object;
        this.projectVcsUrlComponent = new SimpleColoredComponent();
        $this$projectNameComponent_u24lambda_u240 = object = new SimpleColoredComponent();
        qodanaCloudProjectRenderer = this;
        boolean bl5 = false;
        $this$projectProblemsCountComponent_u24lambda_u240.setIpad((Insets)this.projectInsetsLeft);
        qodanaCloudProjectRenderer.projectProblemsCountComponent = object;
        this.projectBranchComponent = new SimpleColoredComponent();
        this.projectLastRunComponent = new SimpleColoredComponent();
        $this$projectProblemsCountComponent_u24lambda_u240 = object = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        qodanaCloudProjectRenderer = this;
        boolean bl6 = false;
        $this$projectRenderer_u24lambda_u240.setOpaque(true);
        JPanel $this$projectRenderer_u24lambda_u240_u240 = jPanel2 = CollaborationToolsUIUtilKt.HorizontalListPanel$default((int)0, (int)1, null);
        boolean bl7 = false;
        $this$projectRenderer_u24lambda_u240_u240.add((Component)this.projectNameComponent);
        $this$projectRenderer_u24lambda_u240_u240.add((Component)this.projectVcsUrlComponent);
        JPanel projectTitle = jPanel2;
        $this$projectRenderer_u24lambda_u240.add(projectTitle);
        JPanel $this$projectRenderer_u24lambda_u240_u241 = jPanel = CollaborationToolsUIUtilKt.HorizontalListPanel$default((int)0, (int)1, null);
        boolean bl8 = false;
        $this$projectRenderer_u24lambda_u240_u241.add((Component)this.projectProblemsCountComponent);
        $this$projectRenderer_u24lambda_u240_u241.add((Component)this.projectBranchComponent);
        $this$projectRenderer_u24lambda_u240_u241.add((Component)this.projectLastRunComponent);
        JPanel projectDescription = jPanel;
        $this$projectRenderer_u24lambda_u240.add(projectDescription);
        $this$projectRenderer_u24lambda_u240.setBorder((Border)this.emptyTopBottomBorder);
        qodanaCloudProjectRenderer.projectRenderer = object;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends QodanaCloudProjectsPagedLoader.ProjectData> list2, @NotNull QodanaCloudProjectsPagedLoader.ProjectData cloudProject, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel jPanel;
        Object[] objectArray;
        boolean renderWithTeam;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)cloudProject, (String)"cloudProject");
        this.fillProjectComponents(cloudProject);
        ListModel<? extends QodanaCloudProjectsPagedLoader.ProjectData> model = list2.getModel();
        boolean bl = renderWithTeam = index == 0 || !Intrinsics.areEqual((Object)model.getElementAt(index).getTeam(), (Object)model.getElementAt(index - 1).getTeam());
        if (!renderWithTeam) {
            UIUtil.setBackgroundRecursively((Component)this.projectRenderer, (Color)ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, true));
            return this.projectRenderer;
        }
        QodanaCloudProjectsPagedLoader.TeamData team = cloudProject.getTeam();
        String string = team.getName();
        if (string == null) {
            objectArray = new Object[]{team.getId()};
            String string2 = QodanaBundle.message("qodana.link.project.dialog.team.id", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String teamName = string;
        this.teamNameComponent.clear();
        this.teamNameComponent.append(teamName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        objectArray = new Object[]{team.getProjectsCount(), team.getMembersCount()};
        String string3 = QodanaBundle.message("qodana.link.project.dialog.team.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String teamDescription = string3;
        this.teamDescriptionComponent.clear();
        this.teamDescriptionComponent.append(teamDescription, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        JPanel $this$getListCellRendererComponent_u24lambda_u240 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl2 = false;
        $this$getListCellRendererComponent_u24lambda_u240.setOpaque(true);
        $this$getListCellRendererComponent_u24lambda_u240.add(this.teamRenderer);
        $this$getListCellRendererComponent_u24lambda_u240.add(this.projectRenderer);
        UIUtil.setBackgroundRecursively((Component)$this$getListCellRendererComponent_u24lambda_u240, (Color)ListUiUtil.WithTallRow.INSTANCE.background(list2, false, true));
        UIUtil.setBackgroundRecursively((Component)this.projectRenderer, (Color)ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, true));
        return jPanel;
    }

    private final void fillProjectComponents(QodanaCloudProjectsPagedLoader.ProjectData cloudProject) {
        String string;
        SimpleTextAttributes descriptionAttributes;
        block8: {
            block7: {
                Integer problemsCount;
                descriptionAttributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
                this.projectNameComponent.clear();
                this.projectVcsUrlComponent.clear();
                this.projectProblemsCountComponent.clear();
                this.projectBranchComponent.clear();
                this.projectLastRunComponent.clear();
                String string2 = cloudProject.getName();
                if (string2 == null) {
                    Object[] objectArray = new Object[]{cloudProject.getId()};
                    String string3 = QodanaBundle.message("qodana.link.project.dialog.project.id", objectArray);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                }
                String cloudProjectName = string2;
                this.projectNameComponent.append(cloudProjectName);
                String vcsUrl = OriginSupportKt.extractVcsOriginCanonicalPath((String)cloudProject.getVcsUrl());
                if (vcsUrl != null) {
                    this.projectVcsUrlComponent.append(vcsUrl, descriptionAttributes);
                }
                if ((problemsCount = cloudProject.getProblemsCount()) == null) {
                    this.projectProblemsCountComponent.append(QodanaBundle.message("qodana.link.project.dialog.project.no.runs", new Object[0]), descriptionAttributes);
                    return;
                }
                Integer n = cloudProject.getBaselineProblemsCount();
                int baselineProblemsCount = n != null ? n : 0;
                Object[] objectArray = new Object[]{problemsCount, baselineProblemsCount};
                String string4 = QodanaBundle.message("qodana.link.project.dialog.project.problems", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                String problemsCountMessage = string4;
                this.projectProblemsCountComponent.append(problemsCountMessage, descriptionAttributes);
                String branch = cloudProject.getBranch();
                string = branch;
                if (string == null) break block7;
                String it = string;
                boolean bl = false;
                Object object = it.length() > 16 ? branch.subSequence(0, 15) + "..." : branch;
                string = object;
                if (object != null) break block8;
            }
            String string5 = QodanaBundle.message("qodana.link.project.dialog.project.no.branch", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        }
        String branchText = string;
        Icon icon = AllIcons.Vcs.BranchNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BranchNode");
        this.projectBranchComponent.setIcon(IconUtil.resizeSquared((Icon)icon, (int)12));
        this.projectBranchComponent.append(branchText, descriptionAttributes);
        Date lastRunDate = cloudProject.getLastRunDate();
        if (lastRunDate != null) {
            Object[] objectArray = new Object[]{DateFormatUtil.formatPrettyDateTime((Date)lastRunDate)};
            String string6 = QodanaBundle.message("qodana.link.project.last.run", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            String description2 = string6;
            Icon icon2 = AllIcons.Vcs.History;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"History");
            this.projectLastRunComponent.setIcon(IconUtil.resizeSquared((Icon)icon2, (int)11));
            this.projectLastRunComponent.append(description2, descriptionAttributes);
        }
    }
}

