/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.model.impl;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.problem.SarifProblemWithPropertiesAndFile;
import org.jetbrains.qodana.settings.ConfigExcludeItem;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreePath;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.impl.QodanaTreeProblemNodeImplKt;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeProblemNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0002J\u0018\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J$\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030+2\u000e\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030+H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001c\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/model/impl/QodanaTreeProblemNodeImpl;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode;", "primaryData", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;", "sarifProblemProperties", "Lorg/jetbrains/qodana/problem/SarifProblemProperties;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "initExcludedData", "", "Lorg/jetbrains/qodana/settings/ConfigExcludeItem;", "<init>", "(Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;Lorg/jetbrains/qodana/problem/SarifProblemProperties;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Set;)V", "getPrimaryData", "()Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;", "getSarifProblemProperties", "()Lorg/jetbrains/qodana/problem/SarifProblemProperties;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "problemsCount", "", "getProblemsCount", "()I", "excluded", "", "getExcluded", "()Z", "excluded$delegate", "Lkotlin/Lazy;", "excludedData", "getExcludedData", "()Ljava/util/Set;", "excludedData$delegate", "isRelatedToProblem", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "isNodeToExclude", "processTreeEvent", "event", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeEvent;", "pathBuilder", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreePath$Builder;", "toUiNode", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "parent", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaTreeProblemNodeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaTreeProblemNodeImpl.kt\norg/jetbrains/qodana/ui/problemsView/tree/model/impl/QodanaTreeProblemNodeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1807#2,3:62\n*S KotlinDebug\n*F\n+ 1 QodanaTreeProblemNodeImpl.kt\norg/jetbrains/qodana/ui/problemsView/tree/model/impl/QodanaTreeProblemNodeImpl\n*L\n35#1:62,3\n*E\n"})
public final class QodanaTreeProblemNodeImpl
implements QodanaTreeProblemNode {
    @NotNull
    private final QodanaTreeProblemNode.PrimaryData primaryData;
    @NotNull
    private final SarifProblemProperties sarifProblemProperties;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Lazy excluded$delegate;
    @NotNull
    private final Lazy excludedData$delegate;

    public QodanaTreeProblemNodeImpl(@NotNull QodanaTreeProblemNode.PrimaryData primaryData, @NotNull SarifProblemProperties sarifProblemProperties, @NotNull VirtualFile virtualFile, @NotNull Set<ConfigExcludeItem> initExcludedData) {
        Intrinsics.checkNotNullParameter((Object)primaryData, (String)"primaryData");
        Intrinsics.checkNotNullParameter((Object)sarifProblemProperties, (String)"sarifProblemProperties");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(initExcludedData, (String)"initExcludedData");
        this.primaryData = primaryData;
        this.sarifProblemProperties = sarifProblemProperties;
        this.virtualFile = virtualFile;
        this.excluded$delegate = LazyKt.lazy(() -> QodanaTreeProblemNodeImpl.excluded_delegate$lambda$0(this));
        this.excludedData$delegate = LazyKt.lazy(() -> QodanaTreeProblemNodeImpl.excludedData_delegate$lambda$0(this, initExcludedData));
    }

    @Override
    @NotNull
    public QodanaTreeProblemNode.PrimaryData getPrimaryData() {
        return this.primaryData;
    }

    @Override
    @NotNull
    public SarifProblemProperties getSarifProblemProperties() {
        return this.sarifProblemProperties;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public int getProblemsCount() {
        return this.getSarifProblemProperties().isMissing() || this.getSarifProblemProperties().isFixed() || this.getExcluded() ? 0 : 1;
    }

    @Override
    public boolean getExcluded() {
        Lazy lazy = this.excluded$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<ConfigExcludeItem> getExcludedData() {
        Lazy lazy = this.excludedData$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    public boolean isRelatedToProblem(@NotNull SarifProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        return Intrinsics.areEqual((Object)problem, (Object)this.getPrimaryData().getSarifProblem());
    }

    private final boolean isNodeToExclude() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getExcludedData();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConfigExcludeItem item = (ConfigExcludeItem)element$iv;
                    boolean bl2 = false;
                    if (!item.excludesPath(this.getPrimaryData().getSarifProblem().getRelativeNioFile(), this.getPrimaryData().getSarifProblem().getInspectionId())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public QodanaTreeProblemNode processTreeEvent(@NotNull QodanaTreeEvent event, @NotNull QodanaTreePath.Builder pathBuilder) {
        QodanaTreeProblemNode qodanaTreeProblemNode;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)pathBuilder, (String)"pathBuilder");
        QodanaTreeEvent qodanaTreeEvent = event;
        if (qodanaTreeEvent instanceof QodanaTreeProblemEvent) {
            SarifProblemWithPropertiesAndFile sarifProblemWithPropertiesAndFile = (SarifProblemWithPropertiesAndFile)CollectionsKt.firstOrNull((Iterable)((QodanaTreeProblemEvent)event).getSarifProblemsToProperties());
            if (sarifProblemWithPropertiesAndFile == null) {
                return this;
            }
            SarifProblemWithPropertiesAndFile newActualProperties = sarifProblemWithPropertiesAndFile;
            if (Intrinsics.areEqual((Object)newActualProperties.getProperties(), (Object)this.getSarifProblemProperties())) {
                return this;
            }
            qodanaTreeProblemNode = new QodanaTreeProblemNodeImpl(this.getPrimaryData(), newActualProperties.getProperties(), this.getVirtualFile(), this.getExcludedData());
        } else if (qodanaTreeEvent instanceof QodanaTreeExcludeEvent) {
            Set newExcludedData = QodanaTreeProblemNodeImplKt.access$filterExcludedData(this.getPrimaryData(), ((QodanaTreeExcludeEvent)event).getExcludedData());
            if (Intrinsics.areEqual((Object)newExcludedData, this.getExcludedData())) {
                return this;
            }
            qodanaTreeProblemNode = new QodanaTreeProblemNodeImpl(this.getPrimaryData(), this.getSarifProblemProperties(), this.getVirtualFile(), newExcludedData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return qodanaTreeProblemNode;
    }

    @Override
    @NotNull
    public QodanaUiTreeNode<QodanaTreeProblemNode, QodanaTreeProblemNode.PrimaryData> toUiNode(@NotNull QodanaUiTreeNode<?, ?> parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return new QodanaUiTreeProblemNode(parent, this.getPrimaryData());
    }

    private static final boolean excluded_delegate$lambda$0(QodanaTreeProblemNodeImpl this$0) {
        return this$0.isNodeToExclude();
    }

    private static final Set excludedData_delegate$lambda$0(QodanaTreeProblemNodeImpl this$0, Set $initExcludedData) {
        return QodanaTreeProblemNodeImplKt.access$filterExcludedData(this$0.getPrimaryData(), $initExcludedData);
    }
}

