/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class OpenInEditorWithMouseAction
extends AnAction
implements DumbAware {
    @NotNull
    private List<? extends Editor> myEditors = Collections.emptyList();

    public OpenInEditorWithMouseAction() {
        AnAction navigateAction = ActionManager.getInstance().getAction("GotoDeclaration");
        this.setShortcutSet((ShortcutSet)(navigateAction != null ? navigateAction.getShortcutSet() : new CustomShortcutSet(new Shortcut[]{new MouseShortcut(1, 128, 1)})));
    }

    public void install(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(0);
        }
        this.myEditors = editors;
        for (Editor editor : editors) {
            this.registerCustomShortcutSet(this.getShortcutSet(), (JComponent)((EditorGutterComponentEx)editor.getGutter()));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        InputEvent inputEvent;
        if (e == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(2);
        }
        if (!((inputEvent = e.getInputEvent()) instanceof MouseEvent)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getData(DiffDataKeys.DIFF_CONTEXT) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Component component2 = inputEvent.getComponent();
        if (component2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Point point = ((MouseEvent)inputEvent).getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component2, point.x, point.y);
        if (!(componentAt instanceof EditorGutterComponentEx)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = this.getEditor(componentAt);
        if (editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), (MouseEvent)inputEvent, componentAt);
        EditorMouseEventArea area = editor.getMouseEventArea(convertedEvent);
        if (area != EditorMouseEventArea.LINE_NUMBERS_AREA) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        MouseEvent inputEvent;
        Project project;
        if (e == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        InputEvent inputEvent2 = e.getInputEvent();
        if (!(inputEvent2 instanceof MouseEvent) || (inputEvent = (MouseEvent)inputEvent2).getComponent() == null) {
            return;
        }
        Runnable callback = (Runnable)e.getData(DiffDataKeys.NAVIGATION_CALLBACK);
        Component component2 = inputEvent.getComponent();
        Point point = inputEvent.getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component2, point.x, point.y);
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), inputEvent, componentAt);
        Editor editor = this.getEditor(componentAt);
        assert (editor != null);
        int line = editor.xyToLogicalPosition((Point)convertedEvent.getPoint()).line;
        Navigatable navigatable = this.getNavigatable(editor, line);
        if (navigatable == null) {
            return;
        }
        OpenInEditorAction.openEditor(project, navigatable, callback);
    }

    @Nullable
    private Editor getEditor(@NotNull Component component2) {
        if (component2 == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(4);
        }
        for (Editor editor : this.myEditors) {
            if (editor == null || editor.getGutter() != component2) continue;
            return editor;
        }
        return null;
    }

    @Nullable
    protected abstract Navigatable getNavigatable(@NotNull Editor var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

