/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class DiffApplicationBase {
    @NlsSafe
    static final String NULL_PATH = "/dev/null";
    static final Logger LOG = Logger.getInstance(DiffApplicationBase.class);

    private DiffApplicationBase() {
    }

    public static @NotNull List<@Nullable VirtualFile> findFilesOrThrow(@NotNull List<String> filePaths, @Nullable String currentDirectory) throws Exception {
        if (filePaths == null) {
            DiffApplicationBase.$$$reportNull$$$0(0);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            if (NULL_PATH.equals(path)) {
                files.add(null);
                continue;
            }
            VirtualFile virtualFile = DiffApplicationBase.findFile(path, currentDirectory);
            if (virtualFile == null) {
                throw new Exception(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{path}));
            }
            files.add(virtualFile);
        }
        DiffApplicationBase.refreshAndEnsureFilesValid(files);
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            DiffApplicationBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void refreshAndEnsureFilesValid(@NotNull List<? extends VirtualFile> files) throws Exception {
        if (files == null) {
            DiffApplicationBase.$$$reportNull$$$0(2);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(files));
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null || virtualFile.isValid()) continue;
            throw new Exception(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{virtualFile.getPresentableUrl()}));
        }
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path, @Nullable String currentDirectory) {
        if (path == null) {
            DiffApplicationBase.$$$reportNull$$$0(3);
        }
        File file = DiffApplicationBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile findOrCreateFile(@NotNull String path, @Nullable String currentDirectory) throws IOException {
        boolean wasCreated;
        if (path == null) {
            DiffApplicationBase.$$$reportNull$$$0(4);
        }
        File file = DiffApplicationBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null && (wasCreated = file.createNewFile())) {
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        }
        if (virtualFile == null) {
            LOG.warn(String.format("Can't create file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @NotNull
    public static File getFile(@NotNull String path, @Nullable String currentDirectory) {
        File file;
        if (path == null) {
            DiffApplicationBase.$$$reportNull$$$0(5);
        }
        if (!(file = new File(path)).isAbsolute() && currentDirectory != null) {
            file = new File(currentDirectory, path);
        }
        File file2 = file;
        if (file2 == null) {
            DiffApplicationBase.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull VirtualFile> replaceNullsWithEmptyFile(@NotNull List<? extends @Nullable VirtualFile> contents) {
        if (contents == null) {
            DiffApplicationBase.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.mapNotNull(contents, file -> file != null ? file : new LightVirtualFile(NULL_PATH, (FileType)PlainTextFileType.INSTANCE, (CharSequence)""));
        if (list == null) {
            DiffApplicationBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    static Project guessProject(@NotNull List<? extends @Nullable VirtualFile> files) {
        Project project2;
        if (files == null) {
            DiffApplicationBase.$$$reportNull$$$0(9);
        }
        HashSet projects = new HashSet();
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null) continue;
            projects.addAll(ProjectLocator.getInstance().getProjectsForFile(virtualFile));
        }
        if (projects.isEmpty()) {
            Object[] openProjects = ProjectManager.getInstance().getOpenProjects();
            projects.addAll(ContainerUtil.filter((Object[])openProjects, project -> project.isInitialized() && !project.isDisposed()));
        }
        if (projects.isEmpty()) {
            return null;
        }
        Window recentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (recentFocusedWindow instanceof IdeFrame && (project2 = ((IdeFrame)recentFocusedWindow).getProject()) != null && projects.contains(project2)) {
            return project2;
        }
        return (Project)projects.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/DiffApplicationBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesOrThrow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceNullsWithEmptyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFilesOrThrow";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndEnsureFilesValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceNullsWithEmptyFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8 -> new IllegalStateException(string);
        };
    }
}

