/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.ReferenceCopyPasteProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.merge.ProcessorData;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007J(\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u00072\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u000fH\u0002JF\u0010\"\u001a\b\u0012\u0004\u0012\u0002H$0#\"\b\b\u0000\u0010$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J*\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u00072\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/diff/merge/ChangeReferenceProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "files", "", "Lcom/intellij/psi/PsiFile;", "documents", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;Ljava/util/List;)V", "innerDifferencesCache", "", "Lcom/intellij/diff/merge/TextMergeChange;", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "process", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "changes", "newRanges", "Lcom/intellij/openapi/editor/RangeMarker;", "transferReferences", "sourceSide", "Lcom/intellij/diff/util/Side;", "change", "rangeMarker", "processInnerFragments", "", "getSequences", "", "compareInner", "createProcessorData", "Lcom/intellij/diff/merge/ProcessorData;", "T", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "processor", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "psiFile", "startOffset", "", "endOffset", "createReferenceData", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nChangeReferenceProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeReferenceProcessor.kt\ncom/intellij/diff/merge/ChangeReferenceProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1915#2:141\n1915#2,2:142\n1916#2:144\n1915#2,2:145\n812#2,12:147\n1586#2:159\n1661#2,3:160\n*S KotlinDebug\n*F\n+ 1 ChangeReferenceProcessor.kt\ncom/intellij/diff/merge/ChangeReferenceProcessor\n*L\n71#1:141\n90#1:142,2\n71#1:144\n97#1:145,2\n131#1:147,12\n131#1:159\n131#1:160,3\n*E\n"})
public final class ChangeReferenceProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<PsiFile> files;
    @NotNull
    private final List<Document> documents;
    @NotNull
    private final Map<TextMergeChange, MergeInnerDifferences> innerDifferencesCache;
    @NotNull
    private static final Logger LOG;

    public ChangeReferenceProcessor(@NotNull Project project, @NotNull Editor editor, @NotNull List<? extends PsiFile> files, @NotNull List<? extends Document> documents) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.project = project;
        this.editor = editor;
        this.files = files;
        this.documents = documents;
        this.innerDifferencesCache = new ConcurrentHashMap();
    }

    public final void process(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes, @NotNull List<? extends RangeMarker> newRanges) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(newRanges, (String)"newRanges");
        try {
            int n = ((Collection)changes).size();
            for (int i = 0; i < n; ++i) {
                Side sourceSide;
                TextMergeChange change = changes.get(i);
                RangeMarker marker = newRanges.get(i);
                if (side == ThreeSide.BASE && change.isConflict()) {
                    this.transferReferences(Side.LEFT, change, marker, true);
                    this.transferReferences(Side.RIGHT, change, marker, true);
                    continue;
                }
                if ((Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT) == null) {
                    return;
                }
                this.transferReferences(sourceSide, change, marker, false);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private final void transferReferences(Side sourceSide, TextMergeChange change, RangeMarker rangeMarker, boolean processInnerFragments) {
        block6: {
            TextRange sourceRange;
            PsiFile psiFile;
            block5: {
                ThreeSide sourceThreeSide = (ThreeSide)sourceSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
                Document sourceDocument = (Document)sourceThreeSide.select(this.documents);
                psiFile = (PsiFile)sourceSide.select((Object)this.files.get(0), (Object)this.files.get(2));
                sourceRange = DiffUtil.getLinesRange(sourceDocument, change.getStartLine(sourceThreeSide), change.getEndLine(sourceThreeSide));
                if (change.getStartLine(sourceThreeSide) == change.getEndLine(sourceThreeSide)) {
                    return;
                }
                if (!processInnerFragments) break block5;
                MergeInnerDifferences mergeInnerDifferences = this.compareInner(change);
                if (mergeInnerDifferences == null) {
                    return;
                }
                MergeInnerDifferences innerDifferences = mergeInnerDifferences;
                List<TextRange> list = innerDifferences.get(sourceThreeSide);
                if (list == null) break block6;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String text;
                    int offset;
                    String fragmentText;
                    Document baseDocument;
                    TextRange textRange = (TextRange)element$iv;
                    boolean bl = false;
                    if (textRange.isEmpty()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)this.editor.getDocument(), (String)"getDocument(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)baseDocument.getText(rangeMarker.getTextRange()), (String)"getText(...)");
                    int fragmentStartOffset = sourceRange.getStartOffset() + textRange.getStartOffset();
                    TextRange rangeInDocument = new TextRange(fragmentStartOffset, fragmentStartOffset + textRange.getLength());
                    Intrinsics.checkNotNullExpressionValue((Object)sourceDocument.getText(rangeInDocument), (String)"getText(...)");
                    if (StringsKt.isBlank((CharSequence)fragmentText) || (offset = StringsKt.indexOf$default((CharSequence)text, (String)fragmentText, (int)0, (boolean)false, (int)6, null)) == -1) continue;
                    List<ProcessorData<?>> data = this.createReferenceData(psiFile, rangeInDocument.getStartOffset(), rangeInDocument.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)baseDocument.createRangeMarker(rangeMarker.getStartOffset() + offset, rangeMarker.getStartOffset() + offset + fragmentText.length()), (String)"createRangeMarker(...)");
                    Iterable $this$forEach$iv2 = data;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        RangeMarker marker;
                        ProcessorData processorData = (ProcessorData)element$iv2;
                        boolean bl2 = false;
                        processorData.process(this.project, this.editor, marker, 0, (Ref<Boolean>)new Ref((Object)false));
                    }
                }
                break block6;
            }
            List<ProcessorData<?>> data = this.createReferenceData(psiFile, sourceRange.getStartOffset(), sourceRange.getEndOffset());
            Iterable $this$forEach$iv = data;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProcessorData processorData = (ProcessorData)element$iv;
                boolean bl = false;
                processorData.process(this.project, this.editor, rangeMarker, 0, (Ref<Boolean>)new Ref((Object)false));
            }
        }
    }

    private final List<CharSequence> getSequences(TextMergeChange change) {
        return ThreeSide.Companion.map(arg_0 -> ChangeReferenceProcessor.getSequences$lambda$0(change, this, arg_0));
    }

    private final MergeInnerDifferences compareInner(TextMergeChange change) {
        return this.innerDifferencesCache.computeIfAbsent(change, arg_0 -> ChangeReferenceProcessor.compareInner$lambda$1(arg_0 -> ChangeReferenceProcessor.compareInner$lambda$0(this, change, arg_0), arg_0));
    }

    private final <T extends TextBlockTransferableData> ProcessorData<T> createProcessorData(CopyPastePostProcessor<T> processor, Editor editor, PsiFile psiFile, int startOffset, int endOffset) {
        int[] nArray = new int[]{startOffset};
        int[] nArray2 = nArray;
        nArray = new int[]{endOffset};
        List list = processor.collectTransferableData(psiFile, editor, nArray2, nArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectTransferableData(...)");
        List processorData = list;
        return new ProcessorData<T>(processor, processorData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProcessorData<?>> createReferenceData(PsiFile psiFile, int startOffset, int endOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = CopyPastePostProcessor.EP_NAME.getExtensionList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ReferenceCopyPasteProcessor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReferenceCopyPasteProcessor referenceCopyPasteProcessor = (ReferenceCopyPasteProcessor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.codeInsight.editorActions.CopyPastePostProcessor<*>");
            collection.add(this.createProcessorData((CopyPastePostProcessor)it, this.editor, psiFile, startOffset, endOffset));
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence getSequences$lambda$0(TextMergeChange $change, ChangeReferenceProcessor this$0, ThreeSide it) {
        int endLine;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!$change.isChange(it)) {
            return null;
        }
        int startLine = $change.getStartLine(it);
        if (startLine == (endLine = $change.getEndLine(it))) {
            return null;
        }
        return DiffUtil.getLinesContent((Document)it.select(this$0.documents), startLine, endLine);
    }

    private static final MergeInnerDifferences compareInner$lambda$0(ChangeReferenceProcessor this$0, TextMergeChange $change, TextMergeChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DiffUtil.compareThreesideInner(this$0.getSequences($change), ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
    }

    private static final MergeInnerDifferences compareInner$lambda$1(Function1 $tmp0, Object p0) {
        return (MergeInnerDifferences)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(ChangeReferenceProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diff/merge/ChangeReferenceProcessor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

