/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.RollbackLineStatusRangeAction;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupActions;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LineStatusTrackerMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/merge/MergeThreesideLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerMarkerRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;Lcom/intellij/diff/merge/MergeThreesideViewer;)V", "scrollAndShow", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "mousePosition", "Ljava/awt/Point;", "paintGutterMarkers", "ranges", "g", "Ljava/awt/Graphics;", "toString", "", "intellij.platform.diff.impl"})
public final class MergeThreesideLineStatusMarkerRenderer
extends LineStatusTrackerMarkerRenderer {
    @NotNull
    private final LineStatusTrackerBase<?> tracker;
    @NotNull
    private final MergeThreesideViewer viewer;

    public MergeThreesideLineStatusMarkerRenderer(@NotNull LineStatusTrackerBase<?> tracker, @NotNull MergeThreesideViewer viewer) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super((LineStatusTrackerI)tracker, arg_0 -> MergeThreesideLineStatusMarkerRenderer._init_$lambda$0(viewer, arg_0));
        this.tracker = tracker;
        this.viewer = viewer;
    }

    @Override
    public void scrollAndShow(@NotNull Editor editor, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.tracker.isValid()) {
            return;
        }
        Document document = this.tracker.getDocument();
        int line = Math.min(!range.hasLines() ? range.getLine2() : range.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        Object object = new int[]{this.viewer.transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line, line, this.viewer.transferPosition((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT, (LogicalPosition)new LogicalPosition((int)line, (int)0)).line};
        int[] startLines = object;
        object = ThreeSide.getEntries().iterator();
        while (object.hasNext()) {
            ThreeSide side = (ThreeSide)object.next();
            DiffUtil.moveCaret((Editor)this.viewer.getEditor(side), side.select(startLines));
        }
        this.viewer.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.showAfterScroll(editor, range);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
        List list;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List $this$createToolbarActions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createToolbarActions_u24lambda_u240.add(new LineStatusMarkerPopupActions.ShowPrevChangeMarkerAction(editor, (LineStatusTrackerI)this.tracker, range, this));
        $this$createToolbarActions_u24lambda_u240.add(new LineStatusMarkerPopupActions.ShowNextChangeMarkerAction(editor, (LineStatusTrackerI)this.tracker, range, this));
        $this$createToolbarActions_u24lambda_u240.add(new RollbackLineStatusRangeAction(editor, this.tracker, range));
        $this$createToolbarActions_u24lambda_u240.add(new LineStatusMarkerPopupActions.ShowLineStatusRangeDiffAction(editor, (LineStatusTrackerI)this.tracker, range));
        $this$createToolbarActions_u24lambda_u240.add(new LineStatusMarkerPopupActions.CopyLineStatusRangeAction(editor, (LineStatusTrackerI)this.tracker, range));
        $this$createToolbarActions_u24lambda_u240.add(new LineStatusMarkerPopupActions.ToggleByWordDiffAction(editor, (LineStatusMarkerRangesSource)this.tracker, range, mousePosition, this));
        return CollectionsKt.build((List)list);
    }

    @Override
    protected void paintGutterMarkers(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int framingBorder = JBUIScale.scale((int)2);
        LineStatusMarkerDrawUtil.paintDefault(editor, g, ranges, DefaultFlagsProvider.DEFAULT, framingBorder);
    }

    @NotNull
    public String toString() {
        return "MergeThreesideViewer.MyLineStatusMarkerRenderer{myTracker=" + this.tracker + "}";
    }

    private static final boolean _init_$lambda$0(MergeThreesideViewer $viewer, Editor editor) {
        return editor == $viewer.getEditor();
    }
}

