/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.ApplyNonConflictsAction;
import com.intellij.diff.merge.ApplySelectedChangesAction;
import com.intellij.diff.merge.BulkProcessingFinished;
import com.intellij.diff.merge.ChangeProcessed;
import com.intellij.diff.merge.ChangeReferenceProcessor;
import com.intellij.diff.merge.ChangeResolved;
import com.intellij.diff.merge.ChangeSideResolved;
import com.intellij.diff.merge.IgnoreSelectedChangesAction;
import com.intellij.diff.merge.IgnoreSelectedChangesSideAction;
import com.intellij.diff.merge.InitChangeData;
import com.intellij.diff.merge.LangSpecificMergeConflictResolverWrapper;
import com.intellij.diff.merge.MagicResolvedConflictsAction;
import com.intellij.diff.merge.MergeConflictModel;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeEvent;
import com.intellij.diff.merge.MergeImportUtil;
import com.intellij.diff.merge.MergeLineFragmentsWithImportMetadata;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeStatisticsAggregator;
import com.intellij.diff.merge.MergeThreesideLineStatusMarkerRenderer;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.NavigateToChangeMarkerAction;
import com.intellij.diff.merge.ResetResolvedChangeAction;
import com.intellij.diff.merge.ResolveSelectedChangesAction;
import com.intellij.diff.merge.ResolveSelectedConflictsAction;
import com.intellij.diff.merge.ShowDiffWithBaseAction;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.merge.ThreesideMergeHighlighters;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.statistics.MergeAction;
import com.intellij.diff.statistics.MergeResultSource;
import com.intellij.diff.statistics.MergeStatisticsCollector;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.simple.DiffViewerHighlighters;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffBalloons;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictResolutionStrategy;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.MergeRangeUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.SimpleLineStatusTracker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class MergeThreesideViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    protected final ModifierProvider myModifierProvider;
    @NotNull
    protected final MyInnerDiffWorker myInnerDiffWorker;
    @NotNull
    protected final SimpleLineStatusTracker myLineStatusTracker;
    @NotNull
    protected final TextDiffProviderBase myTextDiffProvider;
    @NotNull
    private final MergeConflictModel model;
    @NotNull
    private final Map<TextMergeChange, ThreesideMergeHighlighters> myHighlighters;
    @NotNull
    protected IgnorePolicy myCurrentIgnorePolicy;
    protected boolean myInitialRediffStarted;
    protected boolean myInitialRediffFinished;
    protected boolean myContentModified;
    protected boolean myResolveImportConflicts;
    protected boolean myResolveImportsPossible;
    private List<PsiFile> myPsiFiles;
    private final Action myCancelResolveAction;
    private final Action myLeftResolveAction;
    private final Action myRightResolveAction;
    protected final Action myAcceptResolveAction;
    private MergeStatisticsAggregator myAggregator;
    private ChangeReferenceProcessor myChangeReferenceProcessor;
    @NotNull
    protected final MergeContext myMergeContext;
    @NotNull
    protected final TextMergeRequest myMergeRequest;
    @NotNull
    protected final TextMergeViewer myTextMergeViewer;
    @NotNull
    private final LangSpecificMergeConflictResolverWrapper myConflictResolver;
    private static final Key<Boolean> EXTERNAL_OPERATION_IN_PROGRESS = Key.create((String)"external.resolve.operation");

    public MergeThreesideViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull MergeContext mergeContext, @NotNull TextMergeRequest mergeRequest, @NotNull TextMergeViewer mergeViewer) {
        if (context == null) {
            MergeThreesideViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            MergeThreesideViewer.$$$reportNull$$$0(1);
        }
        if (mergeContext == null) {
            MergeThreesideViewer.$$$reportNull$$$0(2);
        }
        if (mergeRequest == null) {
            MergeThreesideViewer.$$$reportNull$$$0(3);
        }
        if (mergeViewer == null) {
            MergeThreesideViewer.$$$reportNull$$$0(4);
        }
        super(context, request);
        this.myHighlighters = new HashMap<TextMergeChange, ThreesideMergeHighlighters>();
        this.myPsiFiles = new ArrayList<PsiFile>();
        this.myMergeContext = mergeContext;
        this.myMergeRequest = mergeRequest;
        this.myTextMergeViewer = mergeViewer;
        this.model = new MergeConflictModel(this.myProject, this.myMergeRequest);
        this.model.addListener(this::onMergeEvent, (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        this.myInnerDiffWorker = new MyInnerDiffWorker();
        this.myLineStatusTracker = new SimpleLineStatusTracker(this.getProject(), (Document)this.getEditor().getDocument(), (Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer>)((Function1)tracker -> new MergeThreesideLineStatusMarkerRenderer((LineStatusTrackerBase<?>)tracker, this)));
        this.myTextDiffProvider = new TextDiffProviderBase(this.getTextSettings(), () -> {
            this.restartMergeResolveIfNeeded();
            this.myInnerDiffWorker.onSettingsChanged();
        }, (Disposable)this, (IgnorePolicy[])ContainerUtil.ar((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES}), (HighlightPolicy[])ContainerUtil.ar((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD}));
        this.getTextSettings().addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener(){

            @Override
            public void resolveConflictsInImportsChanged() {
                MergeThreesideViewer.this.restartMergeResolveIfNeeded();
            }
        }, (Disposable)this);
        this.myCurrentIgnorePolicy = this.myTextDiffProvider.getIgnorePolicy();
        this.myResolveImportConflicts = this.getTextSettings().isAutoResolveImportConflicts();
        this.myCancelResolveAction = this.getResolveAction(MergeResult.CANCEL);
        this.myLeftResolveAction = this.getResolveAction(MergeResult.LEFT);
        this.myRightResolveAction = this.getResolveAction(MergeResult.RIGHT);
        this.myAcceptResolveAction = this.getResolveAction(MergeResult.RESOLVED);
        DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(this, false), this.myPanel);
        DiffUtil.registerAction((AnAction)new NavigateToChangeMarkerAction(this, true), this.myPanel);
        ProxyUndoRedoAction.register(this.getProject(), (Editor)this.getEditor(), this.myContentPanel);
        this.myConflictResolver = new LangSpecificMergeConflictResolverWrapper(context.getProject(), this.myMergeRequest.getContents());
    }

    @Override
    @NotNull
    protected StatusPanel createStatusPanel() {
        return new MyMergeStatusPanel();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        Disposer.dispose((Disposable)this.model);
        this.myLineStatusTracker.release();
        this.myInnerDiffWorker.disable();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            MergeThreesideViewer.$$$reportNull$$$0(5);
        }
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        ((TextEditorHolder)ThreeSide.BASE.select(holders)).getEditor().putUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG, (Object)true);
        List<TextEditorHolder> list = holders;
        if (list == null) {
            MergeThreesideViewer.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add((AnAction)Separator.create((String)ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_MIDDLE, true));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.RIGHT_MIDDLE, true));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, true));
        diffGroup.add((AnAction)new ShowDiffWithBaseAction(this, ThreeSide.LEFT));
        diffGroup.add((AnAction)new ShowDiffWithBaseAction(this, ThreeSide.BASE));
        diffGroup.add((AnAction)new ShowDiffWithBaseAction(this, ThreeSide.RIGHT));
        group.add((AnAction)diffGroup);
        group.add((AnAction)new Separator(DiffBundle.messagePointer((String)"action.Anonymous.text.apply.non.conflicting.changes", (Object[])new Object[0])));
        group.add((AnAction)new ApplyNonConflictsAction(this, ThreeSide.LEFT, DiffBundle.message((String)"action.merge.apply.non.conflicts.left.text", (Object[])new Object[0])));
        group.add((AnAction)new ApplyNonConflictsAction(this, ThreeSide.BASE, DiffBundle.message((String)"action.merge.apply.non.conflicts.all.text", (Object[])new Object[0])));
        group.add((AnAction)new ApplyNonConflictsAction(this, ThreeSide.RIGHT, DiffBundle.message((String)"action.merge.apply.non.conflicts.right.text", (Object[])new Object[0])));
        group.add((AnAction)new MagicResolvedConflictsAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)this.myEditorSettingsAction);
        AnAction additionalActions = ActionManager.getInstance().getAction("Diff.Conflicts.Additional.Actions");
        if (additionalActions instanceof ActionGroup) {
            group.add(additionalActions);
        }
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            MergeThreesideViewer.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ApplySelectedChangesAction(this, Side.LEFT));
        group.add(new ApplySelectedChangesAction(this, Side.RIGHT));
        group.add(new ResolveSelectedChangesAction(this, Side.LEFT));
        group.add(new ResolveSelectedChangesAction(this, Side.RIGHT));
        group.add(new IgnoreSelectedChangesSideAction(this, Side.LEFT));
        group.add(new IgnoreSelectedChangesSideAction(this, Side.RIGHT));
        group.add(new ResolveSelectedConflictsAction(this));
        group.add(new IgnoreSelectedChangesAction(this));
        group.add(new ResetResolvedChangeAction(this));
        group.add((AnAction)Separator.getInstance());
        group.add(ActionManager.getInstance().getAction("Diff.Conflicts.Additional.Actions"));
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            MergeThreesideViewer.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        return group;
    }

    @Nullable
    public Action getResolveAction(final @NotNull MergeResult result) {
        if (result == null) {
            MergeThreesideViewer.$$$reportNull$$$0(9);
        }
        String caption = MergeUtil.getResolveActionTitle(result, (MergeRequest)this.myMergeRequest, this.myMergeContext);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean confirmationShown = false;
                boolean discardChanges = true;
                switch (result) {
                    case LEFT: 
                    case RIGHT: {
                        confirmationShown = MergeThreesideViewer.this.myContentModified;
                        discardChanges = MergeUtil.showConfirmDiscardChangesDialog(MergeThreesideViewer.this.myPanel.getRootPane(), result == MergeResult.LEFT ? DiffBundle.message((String)"button.merge.resolve.accept.left", (Object[])new Object[0]) : DiffBundle.message((String)"button.merge.resolve.accept.right", (Object[])new Object[0]), MergeThreesideViewer.this.myContentModified);
                        break;
                    }
                    case RESOLVED: {
                        if (MergeThreesideViewer.this.getChangesCount() <= 0 && MergeThreesideViewer.this.getConflictsCount() <= 0) break;
                        confirmationShown = true;
                        discardChanges = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DiffBundle.message((String)"apply.partially.resolved.merge.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.dialog.apply.partially.resolved.changes.confirmation.message", (Object[])new Object[]{MergeThreesideViewer.this.getChangesCount(), MergeThreesideViewer.this.getConflictsCount()})).yesText(DiffBundle.message((String)"apply.changes.and.mark.resolved", (Object[])new Object[0]))).noText(DiffBundle.message((String)"continue.merge", (Object[])new Object[0]))).ask((Component)MergeThreesideViewer.this.myPanel.getRootPane());
                        break;
                    }
                    case CANCEL: {
                        confirmationShown = MergeThreesideViewer.this.myContentModified;
                        discardChanges = MergeUtil.showExitWithoutApplyingChangesDialog(MergeThreesideViewer.this.myTextMergeViewer, (MergeRequest)MergeThreesideViewer.this.myMergeRequest, MergeThreesideViewer.this.myMergeContext, MergeThreesideViewer.this.myContentModified);
                    }
                }
                MergeThreesideViewer.this.logDialogButton(result, confirmationShown, discardChanges, false);
                if (!discardChanges) {
                    return;
                }
                MergeThreesideViewer.this.doFinishMerge(result, MergeResultSource.DIALOG_BUTTON);
            }
        };
    }

    protected void doFinishMerge(@NotNull MergeResult result, @NotNull MergeResultSource source) {
        if (result == null) {
            MergeThreesideViewer.$$$reportNull$$$0(10);
        }
        if (source == null) {
            MergeThreesideViewer.$$$reportNull$$$0(11);
        }
        this.logMergeResult(result, source);
        this.destroyChangedBlocks();
        this.myMergeContext.finishMerge(result);
    }

    private void onMergeEvent(MergeEvent event) {
        if (event instanceof ChangeResolved) {
            ChangeResolved changeResolved = (ChangeResolved)event;
            TextMergeChange change = changeResolved.getChange();
            this.applyForHighlighters(change, highlighters -> {
                if (change.isResolved()) {
                    highlighters.destroyInnerHighlighters();
                }
            });
            this.onChangeResolved(change);
            return;
        }
        if (event instanceof ChangeSideResolved) {
            ChangeSideResolved sideResolved = (ChangeSideResolved)event;
            TextMergeChange change = sideResolved.getChange();
            Side side = sideResolved.getSide();
            this.applyForHighlighters(change, highlighters -> {
                if (change.isResolved()) {
                    highlighters.destroyInnerHighlighters();
                    return;
                }
                DocumentEx document = this.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
                highlighters.destroyInnerHighlighters(document);
            });
            return;
        }
        if (event instanceof ChangeProcessed) {
            ChangeProcessed changeProcessed = (ChangeProcessed)event;
            this.reinstallAllHighlighters(changeProcessed.getChange());
            this.myInnerDiffWorker.scheduleRediff(changeProcessed.getChange());
            return;
        }
        if (event instanceof BulkProcessingFinished) {
            this.postInstallHighlighters();
        }
    }

    private void restartMergeResolveIfNeeded() {
        if (this.isDisposed()) {
            return;
        }
        if (this.myTextDiffProvider.getIgnorePolicy().equals((Object)this.myCurrentIgnorePolicy) && this.getTextSettings().isAutoResolveImportConflicts() == this.myResolveImportConflicts) {
            return;
        }
        if (!this.myInitialRediffFinished) {
            ApplicationManager.getApplication().invokeLater(() -> this.restartMergeResolveIfNeeded());
            return;
        }
        if (this.myContentModified && Messages.showYesNoDialog((Project)this.myProject, (String)DiffBundle.message((String)"changing.highlighting.requires.the.file.merge.restart", (Object[])new Object[0]), (String)DiffBundle.message((String)"update.highlighting.settings", (Object[])new Object[0]), (String)DiffBundle.message((String)"discard.changes.and.restart.merge", (Object[])new Object[0]), (String)DiffBundle.message((String)"continue.merge", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            this.getTextSettings().setIgnorePolicy(this.myCurrentIgnorePolicy);
            this.getTextSettings().setAutoResolveImportConflicts(this.myResolveImportConflicts);
            return;
        }
        this.myInitialRediffFinished = false;
        this.doRediff();
    }

    private boolean setInitialOutputContent(@NotNull CharSequence baseContent) {
        if (baseContent == null) {
            MergeThreesideViewer.$$$reportNull$$$0(12);
        }
        Document outputDocument = this.myMergeRequest.getOutputContent().getDocument();
        return DiffUtil.executeWriteCommand(outputDocument, this.getProject(), DiffBundle.message((String)"message.init.merge.content.command", (Object[])new Object[0]), () -> {
            outputDocument.setText(baseContent);
            DiffUtil.putNonundoableOperation(this.getProject(), outputDocument);
            if (this.getTextSettings().isEnableLstGutterMarkersInMerge()) {
                this.myLineStatusTracker.setBaseRevision(baseContent);
                this.getEditor().getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.SHOW);
            }
        });
    }

    @Override
    @RequiresEdt
    public void rediff(boolean bl) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myInitialRediffStarted) {
            return;
        }
        this.myInitialRediffStarted = true;
        assert (this.model.getAllChanges().isEmpty());
        this.doRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            MergeThreesideViewer.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    @RequiresEdt
    private void doRediff() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myStatusPanel.setBusy(true);
        this.myInnerDiffWorker.disable();
        this.getEditor().setViewer(true);
        this.myLoadingPanel.startLoading();
        this.myAcceptResolveAction.setEnabled(false);
        BackgroundTaskUtil.executeAndTryWait(indicator -> (Runnable)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
            try {
                return this.doPerformRediff((ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException e) {
                return () -> this.myMergeContext.finishMerge(MergeResult.CANCEL);
            }
            catch (Throwable e) {
                LOG.error(e);
                return () -> this.myMergeContext.finishMerge(MergeResult.CANCEL);
            }
        }), null, (long)300L, (boolean)ApplicationManager.getApplication().isUnitTestMode());
    }

    @NotNull
    protected Runnable doPerformRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            MergeThreesideViewer.$$$reportNull$$$0(14);
        }
        try {
            ArrayList<CharSequence> sequences = new ArrayList<CharSequence>();
            indicator.checkCanceled();
            IgnorePolicy ignorePolicy2 = this.myTextDiffProvider.getIgnorePolicy();
            List contents = this.myMergeRequest.getContents();
            MergeRange importRange = (MergeRange)ReadAction.compute(() -> {
                sequences.addAll(ContainerUtil.map((Collection)contents, content -> content.getDocument().getImmutableCharSequence()));
                this.initPsiFiles();
                this.myResolveImportsPossible = this.canImportsBeProcessedAutomatically();
                return this.getTextSettings().isAutoResolveImportConflicts() && this.myResolveImportsPossible ? MergeImportUtil.getImportMergeRange(this.myProject, this.myPsiFiles) : null;
            });
            MergeLineFragmentsWithImportMetadata lineFragments = MergeThreesideViewer.getLineFragments(indicator, sequences, importRange, ignorePolicy2);
            List lineOffsets = ContainerUtil.map(sequences, LineOffsetsUtil::create);
            List conflictTypes = ContainerUtil.map(lineFragments.getFragments(), fragment -> MergeRangeUtil.getLineMergeType((MergeLineFragment)fragment, (List)sequences, (List)lineOffsets, (ComparisonPolicy)ignorePolicy2.getComparisonPolicy()));
            this.myConflictResolver.init(lineOffsets, lineFragments.getFragments(), this.myPsiFiles);
            this.patchConflictTypes(conflictTypes);
            FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(lineFragments.getFragments(), lineOffsets, this.getFoldingModelSettings());
            runnable = () -> this.apply((CharSequence)ThreeSide.BASE.select(sequences), lineFragments, conflictTypes, foldingState, ignorePolicy2);
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable2 == null) {
                MergeThreesideViewer.$$$reportNull$$$0(16);
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setErrorContent();
            };
            if (runnable3 == null) {
                MergeThreesideViewer.$$$reportNull$$$0(17);
            }
            return runnable3;
        }
        if (runnable == null) {
            MergeThreesideViewer.$$$reportNull$$$0(15);
        }
        return runnable;
    }

    private void patchConflictTypes(List<MergeConflictType> conflictTypes) {
        for (int i = 0; i < conflictTypes.size(); ++i) {
            MergeConflictType conflictType = conflictTypes.get(i);
            if (conflictType.canBeResolved() || !this.myConflictResolver.canResolveConflictSemantically(i)) continue;
            conflictType.setResolutionStrategy(MergeConflictResolutionStrategy.SEMANTIC);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public TextMergeRequest getMergeRequest() {
        TextMergeRequest textMergeRequest = this.myMergeRequest;
        if (textMergeRequest == null) {
            MergeThreesideViewer.$$$reportNull$$$0(18);
        }
        return textMergeRequest;
    }

    private static MergeLineFragmentsWithImportMetadata getLineFragments(@NotNull ProgressIndicator indicator, @NotNull List<CharSequence> sequences, @Nullable MergeRange importRange, @NotNull IgnorePolicy ignorePolicy2) {
        if (indicator == null) {
            MergeThreesideViewer.$$$reportNull$$$0(19);
        }
        if (sequences == null) {
            MergeThreesideViewer.$$$reportNull$$$0(20);
        }
        if (ignorePolicy2 == null) {
            MergeThreesideViewer.$$$reportNull$$$0(21);
        }
        if (importRange != null) {
            return MergeImportUtil.getDividedFromImportsFragments(sequences, ignorePolicy2.getComparisonPolicy(), importRange, indicator);
        }
        ComparisonManager manager = ComparisonManager.getInstance();
        List fragments = manager.mergeLines(sequences.get(0), sequences.get(1), sequences.get(2), ignorePolicy2.getComparisonPolicy(), indicator);
        return new MergeLineFragmentsWithImportMetadata(fragments);
    }

    private void initPsiFiles() {
        if (this.myProject == null) {
            return;
        }
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (ThreeSide value : ThreeSide.getEntries()) {
            PsiFile psiFile = MergeImportUtil.getPsiFile(value, this.myProject, this.myMergeRequest);
            if (psiFile != null) {
                files.add(psiFile);
                continue;
            }
            return;
        }
        this.myPsiFiles = files;
    }

    @RequiresEdt
    private void apply(@NotNull CharSequence baseContent, @NotNull MergeLineFragmentsWithImportMetadata fragmentsWithMetadata, @NotNull List<? extends MergeConflictType> conflictTypes, @Nullable FoldingModelSupport.Data foldingState, @NotNull IgnorePolicy ignorePolicy2) {
        if (baseContent == null) {
            MergeThreesideViewer.$$$reportNull$$$0(22);
        }
        if (fragmentsWithMetadata == null) {
            MergeThreesideViewer.$$$reportNull$$$0(23);
        }
        if (conflictTypes == null) {
            MergeThreesideViewer.$$$reportNull$$$0(24);
        }
        if (ignorePolicy2 == null) {
            MergeThreesideViewer.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.clearDiffPresentation();
        this.resetChangeCounters();
        boolean success = this.setInitialOutputContent(baseContent);
        List<Object> fragments = fragmentsWithMetadata.getFragments();
        if (!success) {
            fragments = Collections.emptyList();
            conflictTypes = Collections.emptyList();
            this.myPanel.addNotification(DiffNotifications.createNotification(DiffBundle.message((String)"error.cant.resolve.conflicts.in.a.read.only.file", (Object[])new Object[0])));
        }
        ArrayList<InitChangeData> initChangeData = new ArrayList<InitChangeData>();
        for (int i = 0; i < fragments.size(); ++i) {
            MergeLineFragment fragment = (MergeLineFragment)fragments.get(i);
            MergeConflictType conflictType = (MergeConflictType)conflictTypes.get(i);
            boolean isInImport = fragmentsWithMetadata.isIndexInImportRange(i);
            initChangeData.add(new InitChangeData(fragment, conflictType, isInImport));
        }
        this.model.initWithData(initChangeData);
        this.model.getAllChanges().forEach(change -> {
            ThreesideMergeHighlighters highlighters = new ThreesideMergeHighlighters((TextMergeChange)change, null, this);
            this.myHighlighters.put((TextMergeChange)change, highlighters);
            this.onChangeAdded((ThreesideDiffChangeBase)change);
        });
        this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.onRediff();
        this.myContentPanel.repaintDividers();
        this.myStatusPanel.update();
        this.getEditor().setViewer(false);
        this.myLoadingPanel.stopLoading();
        this.myAcceptResolveAction.setEnabled(true);
        this.myInnerDiffWorker.onEverythingChanged();
        this.myInitialRediffFinished = true;
        this.myContentModified = false;
        this.myCurrentIgnorePolicy = ignorePolicy2;
        this.myResolveImportConflicts = this.getTextSettings().isAutoResolveImportConflicts();
        Language language = null;
        if (this.myPsiFiles.size() == 3) {
            language = ((PsiFile)ThreeSide.BASE.select(this.myPsiFiles)).getLanguage();
        }
        this.myAggregator = new MergeStatisticsAggregator(this.getAllChanges().size(), this.model.getAutoResolvableChanges().size(), this.model.getSemanticallyResolvableChanges().size(), this.getConflictsCount(), language);
        if (this.myResolveImportConflicts) {
            this.myChangeReferenceProcessor = new ChangeReferenceProcessor(this.myProject, (Editor)this.getEditor(), this.myPsiFiles, ContainerUtil.map((Collection)this.myMergeRequest.getContents(), content -> content.getDocument()));
            List<TextMergeChange> importChanges = this.model.getImportChanges();
            if (importChanges.size() != fragments.size()) {
                for (TextMergeChange importChange : importChanges) {
                    this.model.markChangeResolved(importChange.getIndex());
                }
            }
        }
        if (this.getTextSettings().isAutoApplyNonConflictedChanges() && this.model.hasNonConflictedChanges(ThreeSide.BASE)) {
            this.applyNonConflictedChanges(ThreeSide.BASE);
        }
    }

    private boolean canImportsBeProcessedAutomatically() {
        try {
            return this.canSideBeProcessed(ThreeSide.LEFT) && this.canSideBeProcessed(ThreeSide.RIGHT);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private boolean canSideBeProcessed(ThreeSide side) {
        if (this.myProject == null || DumbService.isDumb((Project)this.myProject) || this.myPsiFiles.isEmpty()) {
            return false;
        }
        AtomicReference<Boolean> atLeastOnReferenceFound = new AtomicReference<Boolean>(false);
        return SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)side.select(this.myPsiFiles))).traverse(TreeTraversal.PLAIN_BFS).processEach(element -> {
            PsiReference reference = element.getReference();
            if (reference == null) {
                return true;
            }
            atLeastOnReferenceFound.set(true);
            if (reference.isSoft()) {
                return true;
            }
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference multiReference = (PsiPolyVariantReference)reference;
                return multiReference.multiResolve(false).length > 0;
            }
            PsiElement resolved = reference.resolve();
            return resolved != null;
        }) && atLeastOnReferenceFound.get() != false;
    }

    @Override
    @RequiresEdt
    protected void destroyChangedBlocks() {
        ThreadingAssertions.assertEventDispatchThread();
        super.destroyChangedBlocks();
        this.myInnerDiffWorker.stop();
        for (TextMergeChange change : this.model.getAllChanges()) {
            this.applyForHighlighters(change, DiffViewerHighlighters::destroy);
        }
        this.myHighlighters.clear();
        this.model.clear();
    }

    public Action getLoadedResolveAction(@NotNull MergeResult result) {
        if (result == null) {
            MergeThreesideViewer.$$$reportNull$$$0(26);
        }
        return switch (result) {
            default -> throw new MatchException(null, null);
            case MergeResult.CANCEL -> this.myCancelResolveAction;
            case MergeResult.LEFT -> this.myLeftResolveAction;
            case MergeResult.RIGHT -> this.myRightResolveAction;
            case MergeResult.RESOLVED -> this.myAcceptResolveAction;
        };
    }

    public boolean isContentModified() {
        return this.myContentModified;
    }

    @Override
    @RequiresEdt
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            MergeThreesideViewer.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        super.onBeforeDocumentChange(e);
        if (this.myInitialRediffFinished) {
            this.myContentModified = true;
        }
    }

    public void repaintDividers() {
        this.myContentPanel.repaintDividers();
    }

    private void onChangeResolved(@NotNull TextMergeChange change) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(28);
        }
        if (change.isResolved()) {
            this.onChangeRemoved(change);
        } else {
            this.onChangeAdded(change);
        }
        if (this.getChangesCount() == 0 && this.getConflictsCount() == 0) {
            LOG.assertTrue(ContainerUtil.and(this.getAllChanges(), TextMergeChange::isResolved));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.isDisposed()) {
                    return;
                }
                JComponent component2 = this.getEditor().getComponent();
                RelativePoint point = new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, JBUIScale.scale((int)5)));
                String title = DiffBundle.message((String)"merge.all.changes.processed.title.text", (Object[])new Object[0]);
                @NlsSafe String message = XmlStringUtil.wrapInHtmlTag((String)DiffBundle.message((String)"merge.all.changes.processed.message.text", (Object[])new Object[0]), (String)"a");
                DiffBalloons.showSuccessPopup(title, message, point, (Disposable)this, () -> {
                    if (this.isDisposed() || this.myLoadingPanel.isLoading()) {
                        return;
                    }
                    this.doFinishMerge(MergeResult.RESOLVED, MergeResultSource.NOTIFICATION);
                });
            });
        }
    }

    @NotNull
    public MergeConflictModel getModel() {
        MergeConflictModel mergeConflictModel = this.model;
        if (mergeConflictModel == null) {
            MergeThreesideViewer.$$$reportNull$$$0(29);
        }
        return mergeConflictModel;
    }

    @NotNull
    public List<TextMergeChange> getAllChanges() {
        List<TextMergeChange> list = this.model.getAllChanges();
        if (list == null) {
            MergeThreesideViewer.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<TextMergeChange> getChanges() {
        List<TextMergeChange> list = this.model.getUnresolvedChanges();
        if (list == null) {
            MergeThreesideViewer.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(32);
        }
        return new MyDividerPaintable(side);
    }

    @NotNull
    public KeyboardModifierListener getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            MergeThreesideViewer.$$$reportNull$$$0(33);
        }
        return modifierProvider;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.getEditor(ThreeSide.BASE);
        if (editorEx == null) {
            MergeThreesideViewer.$$$reportNull$$$0(34);
        }
        return editorEx;
    }

    public boolean executeMergeCommand(@Nullable @Nls String commandName, boolean underBulkUpdate, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
        if (task == null) {
            MergeThreesideViewer.$$$reportNull$$$0(35);
        }
        this.myContentModified = true;
        IntArrayList affectedIndexes = null;
        if (affected != null) {
            affectedIndexes = new IntArrayList(affected.size());
            for (TextMergeChange change : affected) {
                affectedIndexes.add(change.getIndex());
            }
        }
        return this.model.executeMergeCommand(commandName, null, UndoConfirmationPolicy.DEFAULT, underBulkUpdate, (IntList)affectedIndexes, task);
    }

    public boolean executeMergeCommand(@Nullable @Nls String commandName, @Nullable List<TextMergeChange> affected, @NotNull Runnable task) {
        if (task == null) {
            MergeThreesideViewer.$$$reportNull$$$0(36);
        }
        return this.executeMergeCommand(commandName, false, affected, task);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public void resolveChangeWithAiAnswer(@NotNull TextMergeChange change, @NotNull List<String> newContentLines) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(37);
        }
        if (newContentLines == null) {
            MergeThreesideViewer.$$$reportNull$$$0(38);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.processChangesAndTransferData(Collections.singletonList(change), ThreeSide.BASE, c -> this.model.replaceChangeWithAi(change.getIndex(), newContentLines));
    }

    protected void postInstallHighlighters() {
        if (!Registry.is((String)"semantic.merge.recompute.after.change", (boolean)false) || this.myProject == null || !this.myConflictResolver.isAvailable()) {
            return;
        }
        PsiFile editablePsiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)this.getEditor().getDocument());
        if (editablePsiFile == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editablePsiFile.getFileDocument());
        List<PsiFile> fileList = List.of((PsiFile)ThreeSide.LEFT.select(this.myPsiFiles), editablePsiFile, (PsiFile)ThreeSide.RIGHT.select(this.myPsiFiles));
        this.myConflictResolver.updateHighlighting(fileList, this.model.getAllChanges(), this.myHighlighters, () -> this.myInnerDiffWorker.scheduleRediff(this.model.getAllChanges()));
    }

    protected void applyNonConflictedChanges(@NotNull ThreeSide side) {
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(39);
        }
        this.executeMergeCommand(DiffBundle.message((String)"merge.dialog.apply.non.conflicted.changes.command", (Object[])new Object[0]), true, null, () -> this.resolveChangesAutomatically(ContainerUtil.filter(this.getAllChanges(), change -> !change.isConflict()), side));
        TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(this.getAllChanges(), c -> !c.isResolved());
        if (firstUnresolved != null) {
            this.doScrollToChange(firstUnresolved, true);
        }
    }

    @ApiStatus.Internal
    public void applyResolvableConflictedChanges() {
        List<TextMergeChange> changes = this.getAllChanges();
        this.executeMergeCommand(DiffBundle.message((String)"message.resolve.simple.conflicts.command", (Object[])new Object[0]), true, null, () -> this.resolveChangesAutomatically(changes, ThreeSide.BASE));
        TextMergeChange firstUnresolved = (TextMergeChange)ContainerUtil.find(changes, c -> !c.isResolved());
        if (firstUnresolved != null) {
            this.doScrollToChange(firstUnresolved, true);
        }
    }

    public void resolveChangesAutomatically(@NotNull List<TextMergeChange> changes, @NotNull ThreeSide threeSide) {
        if (changes == null) {
            MergeThreesideViewer.$$$reportNull$$$0(40);
        }
        if (threeSide == null) {
            MergeThreesideViewer.$$$reportNull$$$0(41);
        }
        this.processChangesAndTransferData(changes, threeSide, change -> this.resolveChangeAutomatically((TextMergeChange)change, threeSide));
    }

    public void resolveSingleChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(42);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(43);
        }
        this.resolveChangesAutomatically(Collections.singletonList(change), side);
    }

    public void replaceChanges(@NotNull List<TextMergeChange> changes, @NotNull Side side, @NotNull Boolean resolveChanges) {
        if (changes == null) {
            MergeThreesideViewer.$$$reportNull$$$0(44);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(45);
        }
        if (resolveChanges == null) {
            MergeThreesideViewer.$$$reportNull$$$0(46);
        }
        this.processChangesAndTransferData(changes, (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT), change -> this.model.replaceChange(change.getIndex(), side, resolveChanges));
    }

    public void replaceSingleChange(@NotNull TextMergeChange change, @NotNull Side side, boolean resolveChange) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(47);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(48);
        }
        this.replaceChanges(Collections.singletonList(change), side, resolveChange);
    }

    private void processChangesAndTransferData(@NotNull List<TextMergeChange> changes, @NotNull ThreeSide side, @NotNull Function<TextMergeChange, LineRange> processor) {
        if (changes == null) {
            MergeThreesideViewer.$$$reportNull$$$0(49);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            MergeThreesideViewer.$$$reportNull$$$0(51);
        }
        ArrayList<LineRange> newRanges = new ArrayList<LineRange>();
        ArrayList<TextMergeChange> filteredChanges = new ArrayList<TextMergeChange>();
        for (TextMergeChange change : changes) {
            LineRange newRange;
            if (change.isImportChange() || (newRange = processor.apply(change)) == null) continue;
            newRanges.add(newRange);
            filteredChanges.add(change);
        }
        this.transferReferenceData(filteredChanges, side, newRanges);
    }

    private void transferReferenceData(@NotNull List<TextMergeChange> changes, @NotNull ThreeSide side, List<LineRange> newRanges) {
        if (changes == null) {
            MergeThreesideViewer.$$$reportNull$$$0(52);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(53);
        }
        if (this.myResolveImportConflicts && this.myPsiFiles.size() == 3) {
            Document document = this.getContent(ThreeSide.BASE).getDocument();
            List markers = ContainerUtil.map(newRanges, range -> document.createRangeMarker(DiffUtil.getLinesRange(document, range.start, range.end)));
            this.myChangeReferenceProcessor.process(side, changes, markers);
            markers.forEach(RangeMarker::dispose);
        }
    }

    @RequiresWriteLock
    public LineRange resolveChangeAutomatically(@NotNull TextMergeChange change, @NotNull ThreeSide side) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(54);
        }
        if (side == null) {
            MergeThreesideViewer.$$$reportNull$$$0(55);
        }
        ThreadingAssertions.assertWriteAccess();
        if (!this.model.canResolveChangeAutomatically(change.getIndex(), side)) {
            return null;
        }
        if (change.isConflict() && Objects.requireNonNull(change.getConflictType().getResolutionStrategy()) == MergeConflictResolutionStrategy.SEMANTIC) {
            CharSequence newContent = this.myConflictResolver.getResolvedConflictContent(change.getIndex());
            if (newContent == null) {
                LOG.warn("Unable to resolve conflict using semantic merge");
                return null;
            }
            return this.model.replaceWithNewContent(change.getIndex(), newContent);
        }
        return this.model.resolveChangeAutomatically(change.getIndex(), side);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresEdt
    public <T> void runExternalResolver(CompletableFuture<? extends T> completableFuture, Consumer<T> consumer, Consumer<? super Throwable> consumer2) {
        void resultHandler;
        void errorHandler;
        void operation;
        ThreadingAssertions.assertEventDispatchThread();
        this.runBeforeExternalOperation();
        operation.whenComplete((arg_0, arg_1) -> this.lambda$runExternalResolver$32((Consumer)errorHandler, (Consumer)resultHandler, arg_0, arg_1));
    }

    protected boolean isExternalOperationInProgress() {
        return Boolean.TRUE.equals(this.myMergeContext.getUserData(EXTERNAL_OPERATION_IN_PROGRESS));
    }

    @RequiresEdt
    private void runBeforeExternalOperation() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myMergeContext.putUserData(EXTERNAL_OPERATION_IN_PROGRESS, (Object)true);
        this.enableResolveActions(false);
        this.getEditor().setViewer(true);
        this.getAllChanges().forEach(this::reinstallAllHighlighters);
    }

    @RequiresEdt
    private void runAfterExternalOperation() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myMergeContext.putUserData(EXTERNAL_OPERATION_IN_PROGRESS, null);
        this.enableResolveActions(true);
        this.getEditor().setViewer(false);
        this.getAllChanges().forEach(this::reinstallAllHighlighters);
    }

    private void applyForHighlighters(@NotNull TextMergeChange change, @NotNull @NotNull Consumer<@NotNull ThreesideMergeHighlighters> consumer) {
        ThreesideMergeHighlighters highlighters;
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(56);
        }
        if (consumer == null) {
            MergeThreesideViewer.$$$reportNull$$$0(57);
        }
        if ((highlighters = this.myHighlighters.get(change)) != null) {
            consumer.accept(highlighters);
        }
    }

    private void reinstallAllHighlighters(@NotNull TextMergeChange change) {
        if (change == null) {
            MergeThreesideViewer.$$$reportNull$$$0(58);
        }
        this.applyForHighlighters(change, ThreesideMergeHighlighters::reinstallAll);
    }

    private void enableResolveActions(boolean enable) {
        this.myLeftResolveAction.setEnabled(enable);
        this.myRightResolveAction.setEnabled(enable);
        this.myAcceptResolveAction.setEnabled(enable);
    }

    @ApiStatus.Internal
    void logMergeCancelled(boolean withConfirmation, boolean discardChanges) {
        this.logDialogButton(MergeResult.CANCEL, withConfirmation, discardChanges, true);
        if (discardChanges) {
            this.logMergeResult(MergeResult.CANCEL, MergeResultSource.DIALOG_CLOSING);
        }
    }

    private void logDialogButton(@NotNull MergeResult result, boolean confirmationShown, boolean discardChanges, boolean byEsc) {
        if (result == null) {
            MergeThreesideViewer.$$$reportNull$$$0(59);
        }
        MergeAction action2 = switch (result) {
            default -> throw new MatchException(null, null);
            case MergeResult.CANCEL -> MergeAction.CANCEL;
            case MergeResult.LEFT -> MergeAction.LEFT;
            case MergeResult.RIGHT -> MergeAction.RIGHT;
            case MergeResult.RESOLVED -> MergeAction.APPLY;
        };
        MergeStatisticsCollector.logMergeDialogEvent(this.myProject, action2, confirmationShown, discardChanges, byEsc);
    }

    private void logMergeResult(MergeResult mergeResult, MergeResultSource source) {
        MergeStatisticsCollector.MergeResult statsResult;
        switch (mergeResult) {
            default: {
                throw new MatchException(null, null);
            }
            case CANCEL: {
                MergeStatisticsCollector.MergeResult mergeResult2 = MergeStatisticsCollector.MergeResult.CANCELED;
                break;
            }
            case RESOLVED: {
                MergeStatisticsCollector.MergeResult mergeResult2 = MergeStatisticsCollector.MergeResult.SUCCESS;
                break;
            }
            case LEFT: 
            case RIGHT: {
                MergeStatisticsCollector.MergeResult mergeResult2 = statsResult = null;
            }
        }
        if (statsResult == null) {
            return;
        }
        this.myAggregator.setUnresolved(this.getChanges().size());
        MergeStatisticsCollector.logMergeFinished(this.myProject, statsResult, source, this.myAggregator);
    }

    private /* synthetic */ void lambda$runExternalResolver$32(Consumer errorHandler, Consumer resultHandler, Object result, Throwable throwable) {
        Runnable runnable = () -> {
            if (this.isDisposed()) {
                return;
            }
            this.runAfterExternalOperation();
            if (throwable != null) {
                errorHandler.accept(throwable);
                return;
            }
            if (result != null) {
                resultHandler.accept(result);
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)this.getComponent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 15, 16, 17, 18, 29, 30, 31, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeRequest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeViewer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeThreesideViewer";
                break;
            }
            case 9: 
            case 10: 
            case 26: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseContent";
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentsWithMetadata";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictTypes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 28: 
            case 37: 
            case 42: 
            case 47: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 32: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContentLines";
                break;
            }
            case 40: 
            case 44: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threeSide";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveChanges";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeThreesideViewer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doPerformRediff";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeRequest";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierProvider";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolders";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolveAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFinishMerge";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setInitialOutputContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doPerformRediff";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLineFragments";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedResolveAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onChangeResolved";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDividerPaintable";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "executeMergeCommand";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveChangeWithAiAnswer";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "applyNonConflictedChanges";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveChangesAutomatically";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveSingleChangeAutomatically";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "replaceChanges";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "replaceSingleChange";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processChangesAndTransferData";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "transferReferenceData";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveChangeAutomatically";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "applyForHighlighters";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "reinstallAllHighlighters";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "logDialogButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 15, 16, 17, 18, 29, 30, 31, 33, 34 -> new IllegalStateException(string);
        };
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(MergeThreesideViewer.this.myPanel, (Disposable)MergeThreesideViewer.this.myTextMergeViewer);
        }

        @Override
        public void onModifiersChanged() {
            for (TextMergeChange change : MergeThreesideViewer.this.model.getAllChanges()) {
                MergeThreesideViewer.this.applyForHighlighters(change, highlighters -> highlighters.updateOperations(false));
            }
        }
    }

    protected class MyInnerDiffWorker {
        @NotNull
        private final Set<TextMergeChange> myScheduled = new HashSet<TextMergeChange>();
        @NotNull
        private final Alarm myAlarm = new Alarm((Disposable)MergeThreesideViewer.this);
        @Nullable
        private ProgressIndicator myProgress;
        private boolean myEnabled = false;

        protected MyInnerDiffWorker() {
        }

        @RequiresEdt
        public void scheduleRediff(@NotNull TextMergeChange change) {
            if (change == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(0);
            }
            ThreadingAssertions.assertEventDispatchThread();
            this.scheduleRediff(Collections.singletonList(change));
        }

        @RequiresEdt
        public void scheduleRediff(@NotNull Collection<TextMergeChange> changes) {
            if (changes == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (!this.myEnabled) {
                return;
            }
            this.putChanges(changes);
            this.schedule();
        }

        @RequiresEdt
        public void onSettingsChanged() {
            boolean enabled;
            ThreadingAssertions.assertEventDispatchThread();
            boolean bl = enabled = MergeThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
            if (this.myEnabled == enabled) {
                return;
            }
            this.myEnabled = enabled;
            this.rebuildEverything();
        }

        @RequiresEdt
        public void onEverythingChanged() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myEnabled = MergeThreesideViewer.this.myTextDiffProvider.getHighlightPolicy() == HighlightPolicy.BY_WORD;
            this.rebuildEverything();
        }

        @RequiresEdt
        public void disable() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myEnabled = false;
            this.stop();
        }

        private void rebuildEverything() {
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
            this.myProgress = null;
            if (this.myEnabled) {
                this.putChanges(MergeThreesideViewer.this.model.getAllChanges());
                this.launchRediff(true);
            } else {
                MergeThreesideViewer.this.myStatusPanel.setBusy(false);
                this.myScheduled.clear();
                for (TextMergeChange change : MergeThreesideViewer.this.model.getAllChanges()) {
                    MergeThreesideViewer.this.applyForHighlighters(change, highlighters -> highlighters.setInnerFragments(null));
                }
            }
        }

        @RequiresEdt
        public void stop() {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
            this.myProgress = null;
            this.myScheduled.clear();
            this.myAlarm.cancelAllRequests();
        }

        @RequiresEdt
        private void putChanges(@NotNull Collection<TextMergeChange> changes) {
            if (changes == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(2);
            }
            ThreadingAssertions.assertEventDispatchThread();
            for (TextMergeChange change : changes) {
                if (change.isResolved()) continue;
                this.myScheduled.add(change);
            }
        }

        @RequiresEdt
        private void schedule() {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.myProgress != null) {
                return;
            }
            if (this.myScheduled.isEmpty()) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.launchRediff(false), 300L);
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        private void launchRediff(boolean bl) {
            void trySync;
            ThreadingAssertions.assertEventDispatchThread();
            MergeThreesideViewer.this.myStatusPanel.setBusy(true);
            ArrayList<TextMergeChange> scheduled = new ArrayList<TextMergeChange>(this.myScheduled);
            this.myScheduled.clear();
            List documents = ThreeSide.map(side -> MergeThreesideViewer.this.getEditor((ThreeSide)side).getDocument());
            List data = ContainerUtil.map(scheduled, change -> new InnerChunkData((TextMergeChange)change, documents));
            long waitMillis = trySync != false ? 300L : 0L;
            ProgressIndicator progress = BackgroundTaskUtil.executeAndTryWait(indicator -> this.performRediff((List<TextMergeChange>)scheduled, data, (ProgressIndicator)indicator), null, (long)waitMillis, (boolean)false);
            if (progress.isRunning()) {
                this.myProgress = progress;
            }
        }

        @RequiresBackgroundThread
        @NotNull
        private Runnable performRediff(@NotNull List<TextMergeChange> scheduled, @NotNull List<? extends InnerChunkData> data, @NotNull ProgressIndicator indicator) {
            if (scheduled == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(3);
            }
            if (data == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(5);
            }
            ThreadingAssertions.assertBackgroundThread();
            ComparisonPolicy comparisonPolicy = MergeThreesideViewer.this.myTextDiffProvider.getIgnorePolicy().getComparisonPolicy();
            ArrayList<MergeInnerDifferences> result = new ArrayList<MergeInnerDifferences>(data.size());
            for (InnerChunkData innerChunkData : data) {
                result.add(DiffUtil.compareThreesideInner(innerChunkData.text, comparisonPolicy, indicator));
            }
            Runnable runnable = () -> {
                if (!this.myEnabled || indicator.isCanceled()) {
                    return;
                }
                this.myProgress = null;
                for (int i = 0; i < scheduled.size(); ++i) {
                    TextMergeChange change = (TextMergeChange)scheduled.get(i);
                    if (this.myScheduled.contains(change)) continue;
                    int index = i;
                    MergeThreesideViewer.this.applyForHighlighters(change, highlighters -> highlighters.setInnerFragments((MergeInnerDifferences)result.get(index)));
                }
                MergeThreesideViewer.this.myStatusPanel.setBusy(false);
                if (!this.myScheduled.isEmpty()) {
                    this.launchRediff(false);
                }
            };
            if (runnable == null) {
                MyInnerDiffWorker.$$$reportNull$$$0(6);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheduled";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/MergeThreesideViewer$MyInnerDiffWorker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/MergeThreesideViewer$MyInnerDiffWorker";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performRediff";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleRediff";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putChanges";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performRediff";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private class MyMergeStatusPanel
    extends ThreesideTextDiffViewerEx.MyStatusPanel {
        private static final JBColor GREEN_CHECKMARK_DEFAULT_COLOR = new JBColor(3573574, 5285473);
        private static final JBColor NO_CONFLICTS_FOREGROUND = JBColor.namedColor((String)"VersionControl.Merge.Status.NoConflicts.foreground", (Color)GREEN_CHECKMARK_DEFAULT_COLOR);

        private MyMergeStatusPanel() {
            super(MergeThreesideViewer.this);
        }

        @Override
        @Nullable
        protected Icon getStatusIcon() {
            if (MergeThreesideViewer.this.getChangesCount() == 0 && MergeThreesideViewer.this.getConflictsCount() == 0) {
                return AllIcons.General.GreenCheckmark;
            }
            return null;
        }

        @Override
        @NotNull
        protected Color getStatusForeground() {
            if (MergeThreesideViewer.this.getChangesCount() == 0 && MergeThreesideViewer.this.getConflictsCount() == 0) {
                JBColor jBColor = NO_CONFLICTS_FOREGROUND;
                if (jBColor == null) {
                    MyMergeStatusPanel.$$$reportNull$$$0(0);
                }
                return jBColor;
            }
            Color color = UIUtil.getLabelForeground();
            if (color == null) {
                MyMergeStatusPanel.$$$reportNull$$$0(1);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/MergeThreesideViewer$MyMergeStatusPanel", "getStatusForeground"));
        }
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        MyDividerPaintable(Side side) {
            if (side == null) {
                MyDividerPaintable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                MyDividerPaintable.$$$reportNull$$$0(1);
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (TextMergeChange mergeChange : MergeThreesideViewer.this.model.getAllChanges()) {
                if (!mergeChange.isChange(this.mySide)) continue;
                boolean isResolved = mergeChange.isResolved(this.mySide);
                if (handler.processResolvable(mergeChange.getStartLine(left), mergeChange.getEndLine(left), mergeChange.getStartLine(right), mergeChange.getEndLine(right), mergeChange.getDiffType(), isResolved)) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeThreesideViewer$MyDividerPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InnerChunkData {
        @NotNull
        public final List<CharSequence> text;

        InnerChunkData(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(0);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(1);
            }
            this.text = InnerChunkData.getChunks(change, documents);
        }

        @NotNull
        private static List<CharSequence> getChunks(@NotNull TextMergeChange change, @NotNull List<? extends Document> documents) {
            if (change == null) {
                InnerChunkData.$$$reportNull$$$0(2);
            }
            if (documents == null) {
                InnerChunkData.$$$reportNull$$$0(3);
            }
            List list = ThreeSide.map(side -> {
                int endLine;
                if (!change.isChange((ThreeSide)side) || change.isResolved((ThreeSide)side)) {
                    return null;
                }
                int startLine = change.getStartLine((ThreeSide)side);
                if (startLine == (endLine = change.getEndLine((ThreeSide)side))) {
                    return null;
                }
                return DiffUtil.getLinesContent((Document)side.select(documents), startLine, endLine);
            });
            if (list == null) {
                InnerChunkData.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documents";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/MergeThreesideViewer$InnerChunkData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/MergeThreesideViewer$InnerChunkData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChunks";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

