/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextMergeRequestImpl
extends TextMergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myOutput;
    @NotNull
    private final List<DocumentContent> myContents;
    @NotNull
    private final CharSequence myOriginalContent;
    @NlsContexts.DialogTitle
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;

    public TextMergeRequestImpl(@Nullable Project project, @NotNull DocumentContent output, @NotNull CharSequence originalContent, @NotNull List<DocumentContent> contents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) {
        if (output == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(0);
        }
        if (originalContent == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(1);
        }
        if (contents == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(2);
        }
        if (contentTitles == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(3);
        }
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myOutput = output;
        this.myOriginalContent = originalContent;
        this.myContents = contents;
        this.myTitles = contentTitles;
        this.myTitle = title;
    }

    @NotNull
    public DocumentContent getOutputContent() {
        DocumentContent documentContent = this.myOutput;
        if (documentContent == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(4);
        }
        return documentContent;
    }

    @NotNull
    public List<DocumentContent> getContents() {
        List<DocumentContent> list = this.myContents;
        if (list == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list = this.myTitles;
        if (list == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void applyResult(@NotNull MergeResult result) {
        if (result == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(7);
        }
        CharSequence applyContent = switch (result) {
            case MergeResult.CANCEL -> MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this) ? this.myOriginalContent : null;
            case MergeResult.LEFT -> {
                CharSequence leftContent = ((DocumentContent)ThreeSide.LEFT.select(this.getContents())).getDocument().getImmutableCharSequence();
                yield StringUtil.convertLineSeparators((String)leftContent.toString());
            }
            case MergeResult.RIGHT -> {
                CharSequence rightContent = ((DocumentContent)ThreeSide.RIGHT.select(this.getContents())).getDocument().getImmutableCharSequence();
                yield StringUtil.convertLineSeparators((String)rightContent.toString());
            }
            case MergeResult.RESOLVED -> null;
            default -> throw new IllegalArgumentException(result.toString());
        };
        if (applyContent != null) {
            DiffUtil.executeWriteCommand(this.myOutput.getDocument(), this.myProject, null, () -> this.myOutput.getDocument().setText(applyContent));
        }
        MergeCallback.getCallback((MergeRequest)this).applyResult(result);
    }

    public void onAssigned(boolean assigned) {
        this.myOutput.onAssigned(assigned);
        for (DocumentContent content : this.myContents) {
            content.onAssigned(assigned);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/TextMergeRequestImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/TextMergeRequestImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

