/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.tools.combined.BlockOrder;
import com.intellij.diff.tools.combined.BlockStateListener;
import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\b\u0010,\u001a\u00020\u001bH\u0016R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010#\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010-\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010%\u00a8\u0006/"}, d2={"Lcom/intellij/diff/tools/combined/BlockState;", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterable;", "Lcom/intellij/diff/tools/combined/BlockOrder;", "list", "", "Lcom/intellij/diff/tools/combined/CombinedBlockId;", "current", "<init>", "(Ljava/util/List;Lcom/intellij/diff/tools/combined/CombinedBlockId;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/diff/tools/combined/BlockStateListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "blocks", "blockByIndex", "", "", "<set-?>", "currentBlock", "getCurrentBlock", "()Lcom/intellij/diff/tools/combined/CombinedBlockId;", "setCurrentBlock", "(Lcom/intellij/diff/tools/combined/CombinedBlockId;)V", "currentBlock$delegate", "Lkotlin/properties/ReadWriteProperty;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "indexOf", "blockId", "getOrNull", "index", "blocksCount", "getBlocksCount", "()I", "iterateBlocks", "", "canGoPrev", "", "canGoNext", "goPrev", "goNext", "currentIndex", "getCurrentIndex", "intellij.platform.diff.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nBlockState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockState.kt\ncom/intellij/diff/tools/combined/BlockState\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n33#2,3:78\n1924#3,3:81\n*S KotlinDebug\n*F\n+ 1 BlockState.kt\ncom/intellij/diff/tools/combined/BlockState\n*L\n33#1:78,3\n44#1:81,3\n*E\n"})
public final class BlockState
implements PrevNextDifferenceIterable,
BlockOrder {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final EventDispatcher<BlockStateListener> eventDispatcher;
    @NotNull
    private final List<CombinedBlockId> blocks;
    @NotNull
    private final Map<CombinedBlockId, Integer> blockByIndex;
    @NotNull
    private final ReadWriteProperty currentBlock$delegate;

    /*
     * WARNING - void declaration
     */
    public BlockState(@NotNull List<? extends CombinedBlockId> list, @NotNull CombinedBlockId current) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        EventDispatcher eventDispatcher = EventDispatcher.create(BlockStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.blocks = CollectionsKt.toList((Iterable)list);
        this.blockByIndex = new LinkedHashMap();
        Delegates delegates = Delegates.INSTANCE;
        CombinedBlockId initialValue$iv = current;
        boolean $i$f$observable = false;
        this.currentBlock$delegate = (ReadWriteProperty)new ObservableProperty<CombinedBlockId>((Object)initialValue$iv, this){
            final /* synthetic */ BlockState this$0;
            {
                this.this$0 = blockState;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                CombinedBlockId combinedBlockId = (CombinedBlockId)newValue;
                CombinedBlockId oldValue2 = (CombinedBlockId)oldValue;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldValue2, (Object)newValue2)) {
                    ((BlockStateListener)BlockState.access$getEventDispatcher$p(this.this$0).getMulticaster()).onCurrentChanged(oldValue2, (CombinedBlockId)newValue2);
                }
            }
        };
        Iterable $this$forEachIndexed$iv = this.blocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void block;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CombinedBlockId combinedBlockId = (CombinedBlockId)item$iv;
            int index = n;
            boolean bl = false;
            this.blockByIndex.put((CombinedBlockId)block, index);
        }
        if (!this.blocks.contains(current)) {
            this.setCurrentBlock((CombinedBlockId)CollectionsKt.first(this.blocks));
        }
    }

    @NotNull
    public final CombinedBlockId getCurrentBlock() {
        return (CombinedBlockId)this.currentBlock$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setCurrentBlock(@NotNull CombinedBlockId combinedBlockId) {
        Intrinsics.checkNotNullParameter((Object)combinedBlockId, (String)"<set-?>");
        this.currentBlock$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)combinedBlockId);
    }

    public final void addListener(@NotNull BlockStateListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener, disposable);
    }

    @Override
    public int indexOf(@NotNull CombinedBlockId blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Integer n = this.blockByIndex.get(blockId);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    @Override
    @Nullable
    public CombinedBlockId getOrNull(int index) {
        return (0 <= index ? index < ((Collection)this.blocks).size() : false) ? this.blocks.get(index) : null;
    }

    @Override
    public int getBlocksCount() {
        return this.blocks.size();
    }

    @Override
    @NotNull
    public Iterable<CombinedBlockId> iterateBlocks() {
        return this.blocks;
    }

    @Override
    public boolean canGoPrev() {
        return this.getCurrentIndex() > 0;
    }

    @Override
    public boolean canGoNext() {
        return this.getCurrentIndex() < this.getBlocksCount() - 1;
    }

    @Override
    public void goPrev() {
        this.setCurrentBlock(this.blocks.get(this.getCurrentIndex() - 1));
    }

    @Override
    public void goNext() {
        this.setCurrentBlock(this.blocks.get(this.getCurrentIndex() + 1));
    }

    private final int getCurrentIndex() {
        return this.indexOf(this.getCurrentBlock());
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(BlockState $this) {
        return $this.eventDispatcher;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BlockState.class, "currentBlock", "getCurrentBlock()Lcom/intellij/diff/tools/combined/CombinedBlockId;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

