/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.editor.DiffEditorTabFilesUtil;
import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorStateWithPreferredOpenMode;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J5\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffEditorState;", "Lcom/intellij/openapi/fileEditor/impl/FileEditorStateWithPreferredOpenMode;", "currentBlockIds", "", "Lcom/intellij/diff/tools/combined/CombinedBlockId;", "activeBlockId", "activeEditorStates", "", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorState;", "<init>", "(Ljava/util/Set;Lcom/intellij/diff/tools/combined/CombinedBlockId;Ljava/util/List;)V", "getCurrentBlockIds", "()Ljava/util/Set;", "getActiveBlockId", "()Lcom/intellij/diff/tools/combined/CombinedBlockId;", "getActiveEditorStates", "()Ljava/util/List;", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "getOpenMode", "()Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "canBeMergedWith", "", "otherState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCombinedDiffComponentProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedDiffComponentProcessorImpl.kt\ncom/intellij/diff/tools/combined/CombinedDiffEditorState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1786#2,3:298\n*S KotlinDebug\n*F\n+ 1 CombinedDiffComponentProcessorImpl.kt\ncom/intellij/diff/tools/combined/CombinedDiffEditorState\n*L\n281#1:298,3\n*E\n"})
public final class CombinedDiffEditorState
implements FileEditorStateWithPreferredOpenMode {
    @NotNull
    private final Set<CombinedBlockId> currentBlockIds;
    @Nullable
    private final CombinedBlockId activeBlockId;
    @NotNull
    private final List<TextEditorState> activeEditorStates;

    public CombinedDiffEditorState(@NotNull Set<? extends CombinedBlockId> currentBlockIds, @Nullable CombinedBlockId activeBlockId, @NotNull List<TextEditorState> activeEditorStates) {
        Intrinsics.checkNotNullParameter(currentBlockIds, (String)"currentBlockIds");
        Intrinsics.checkNotNullParameter(activeEditorStates, (String)"activeEditorStates");
        this.currentBlockIds = currentBlockIds;
        this.activeBlockId = activeBlockId;
        this.activeEditorStates = activeEditorStates;
    }

    @NotNull
    public final Set<CombinedBlockId> getCurrentBlockIds() {
        return this.currentBlockIds;
    }

    @Nullable
    public final CombinedBlockId getActiveBlockId() {
        return this.activeBlockId;
    }

    @NotNull
    public final List<TextEditorState> getActiveEditorStates() {
        return this.activeEditorStates;
    }

    @Nullable
    public FileEditorManagerImpl.OpenMode getOpenMode() {
        return !DiffEditorTabFilesUtil.isDiffInEditor() ? FileEditorManagerImpl.OpenMode.NEW_WINDOW : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
        TextEditorState r;
        Pair pair;
        TextEditorState l;
        Intrinsics.checkNotNullParameter((Object)otherState, (String)"otherState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!(otherState instanceof CombinedDiffEditorState)) return false;
        if (!Intrinsics.areEqual(this.currentBlockIds, ((CombinedDiffEditorState)otherState).currentBlockIds)) return true;
        if (!Intrinsics.areEqual((Object)this.activeBlockId, (Object)((CombinedDiffEditorState)otherState).activeBlockId)) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.activeEditorStates, (Iterable)((CombinedDiffEditorState)otherState).activeEditorStates);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            pair = (Pair)element$iv;
            boolean bl = false;
        } while ((l = (TextEditorState)pair.component1()).canBeMergedWith((FileEditorState)(r = (TextEditorState)pair.component2()), level));
        return false;
    }

    @NotNull
    public final Set<CombinedBlockId> component1() {
        return this.currentBlockIds;
    }

    @Nullable
    public final CombinedBlockId component2() {
        return this.activeBlockId;
    }

    @NotNull
    public final List<TextEditorState> component3() {
        return this.activeEditorStates;
    }

    @NotNull
    public final CombinedDiffEditorState copy(@NotNull Set<? extends CombinedBlockId> currentBlockIds, @Nullable CombinedBlockId activeBlockId, @NotNull List<TextEditorState> activeEditorStates) {
        Intrinsics.checkNotNullParameter(currentBlockIds, (String)"currentBlockIds");
        Intrinsics.checkNotNullParameter(activeEditorStates, (String)"activeEditorStates");
        return new CombinedDiffEditorState(currentBlockIds, activeBlockId, activeEditorStates);
    }

    public static /* synthetic */ CombinedDiffEditorState copy$default(CombinedDiffEditorState combinedDiffEditorState, Set set, CombinedBlockId combinedBlockId, List list, int n, Object object) {
        if ((n & 1) != 0) {
            set = combinedDiffEditorState.currentBlockIds;
        }
        if ((n & 2) != 0) {
            combinedBlockId = combinedDiffEditorState.activeBlockId;
        }
        if ((n & 4) != 0) {
            list = combinedDiffEditorState.activeEditorStates;
        }
        return combinedDiffEditorState.copy(set, combinedBlockId, list);
    }

    @NotNull
    public String toString() {
        return "CombinedDiffEditorState(currentBlockIds=" + this.currentBlockIds + ", activeBlockId=" + this.activeBlockId + ", activeEditorStates=" + this.activeEditorStates + ")";
    }

    public int hashCode() {
        int result = ((Object)this.currentBlockIds).hashCode();
        result = result * 31 + (this.activeBlockId == null ? 0 : this.activeBlockId.hashCode());
        result = result * 31 + ((Object)this.activeEditorStates).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CombinedDiffEditorState)) {
            return false;
        }
        CombinedDiffEditorState combinedDiffEditorState = (CombinedDiffEditorState)other;
        if (!Intrinsics.areEqual(this.currentBlockIds, combinedDiffEditorState.currentBlockIds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.activeBlockId, (Object)combinedDiffEditorState.activeBlockId)) {
            return false;
        }
        return Intrinsics.areEqual(this.activeEditorStates, combinedDiffEditorState.activeEditorStates);
    }
}

