/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.DiffViewerHighlighters;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J-\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diff/tools/simple/SimpleDiffViewerHighlighters;", "Lcom/intellij/diff/tools/simple/DiffViewerHighlighters;", "change", "Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange;", "innerFragments", "Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;", "viewer", "Lcom/intellij/diff/tools/simple/SimpleThreesideDiffViewer;", "<init>", "(Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange;Lcom/intellij/diff/tools/util/text/MergeInnerDifferences;Lcom/intellij/diff/tools/simple/SimpleThreesideDiffViewer;)V", "getChange", "()Lcom/intellij/diff/tools/simple/SimpleThreesideDiffChange;", "installOperations", "", "createAcceptOperation", "Lcom/intellij/diff/util/DiffGutterOperation;", "sourceSide", "Lcom/intellij/diff/util/ThreeSide;", "modifiedSide", "createIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "tooltipText", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "icon", "Ljavax/swing/Icon;", "perform", "Ljava/lang/Runnable;", "Companion", "intellij.platform.diff.impl"})
public final class SimpleDiffViewerHighlighters
extends DiffViewerHighlighters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleThreesideDiffChange change;
    @NotNull
    private final SimpleThreesideDiffViewer viewer;

    public SimpleDiffViewerHighlighters(@NotNull SimpleThreesideDiffChange change, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        super(change, innerFragments, (Function1<? super ThreeSide, ? extends EditorEx>)((Function1)new Function1<ThreeSide, EditorEx>((Object)viewer){

            public final EditorEx invoke(ThreeSide p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SimpleThreesideDiffViewer)this.receiver).getEditor(p0);
            }
        }));
        this.change = change;
        this.viewer = viewer;
        this.reinstallAll();
    }

    @Override
    @NotNull
    protected SimpleThreesideDiffChange getChange() {
        return this.change;
    }

    @Override
    public void installOperations() {
        this.addOperation(this.createAcceptOperation(ThreeSide.LEFT, ThreeSide.BASE));
        this.addOperation(this.createAcceptOperation(ThreeSide.RIGHT, ThreeSide.BASE));
        this.addOperation(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.LEFT));
        this.addOperation(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.RIGHT));
    }

    private final DiffGutterOperation createAcceptOperation(ThreeSide sourceSide, ThreeSide modifiedSide) {
        EditorEx editor = (EditorEx)this.getEditorProvider().invoke((Object)sourceSide);
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, this.getChange().getStartLine(sourceSide));
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> SimpleDiffViewerHighlighters.createAcceptOperation$lambda$0(this, modifiedSide, sourceSide));
    }

    private final GutterIconRenderer createIconRenderer(ThreeSide modifiedSide, String tooltipText, Icon icon, Runnable perform) {
        return new DiffGutterRenderer(icon, tooltipText, this, modifiedSide, perform){
            final /* synthetic */ SimpleDiffViewerHighlighters this$0;
            final /* synthetic */ ThreeSide $modifiedSide;
            final /* synthetic */ Runnable $perform;
            {
                this.this$0 = $receiver;
                this.$modifiedSide = $modifiedSide;
                this.$perform = $perform;
                super($icon, $tooltipText);
            }

            protected void handleMouseClick() {
                if (!this.this$0.getChange().isValid()) {
                    return;
                }
                Project project = SimpleDiffViewerHighlighters.access$getViewer$p(this.this$0).getProject();
                DocumentEx documentEx = SimpleDiffViewerHighlighters.access$getViewer$p(this.this$0).getEditor(this.$modifiedSide).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                Document document = (Document)documentEx;
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), this.$perform);
            }
        };
    }

    private static final void createAcceptOperation$lambda$0$0(SimpleDiffViewerHighlighters this$0, ThreeSide $sourceSide, ThreeSide $modifiedSide) {
        this$0.viewer.replaceChange(this$0.getChange(), $sourceSide, $modifiedSide);
    }

    private static final GutterIconRenderer createAcceptOperation$lambda$0(SimpleDiffViewerHighlighters this$0, ThreeSide $modifiedSide, ThreeSide $sourceSide) {
        boolean isChanged;
        boolean isOtherEditable = this$0.viewer.isEditable($modifiedSide);
        if (!isOtherEditable) {
            return null;
        }
        boolean bl = isChanged = $sourceSide != ThreeSide.BASE && this$0.getChange().isChange($sourceSide) || $modifiedSide != ThreeSide.BASE && this$0.getChange().isChange($modifiedSide);
        if (!isChanged) {
            return null;
        }
        String text = Companion.getApplyActionText(this$0.viewer, $sourceSide, $modifiedSide);
        Side arrowDirection = Side.Companion.fromLeft($sourceSide == ThreeSide.LEFT || $modifiedSide == ThreeSide.RIGHT);
        Icon icon = DiffUtil.getArrowIcon(arrowDirection);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getArrowIcon(...)");
        Icon icon2 = icon;
        return this$0.createIconRenderer($modifiedSide, text, icon2, () -> SimpleDiffViewerHighlighters.createAcceptOperation$lambda$0$0(this$0, $sourceSide, $modifiedSide));
    }

    @JvmStatic
    @NotNull
    public static final String getApplyActionText(@NotNull DiffViewerBase viewer, @NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
        return Companion.getApplyActionText(viewer, sourceSide, modifiedSide);
    }

    public static final /* synthetic */ SimpleThreesideDiffViewer access$getViewer$p(SimpleDiffViewerHighlighters $this) {
        return $this.viewer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/simple/SimpleDiffViewerHighlighters$Companion;", "", "<init>", "()V", "getApplyActionText", "", "Lorg/jetbrains/annotations/Nls;", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "sourceSide", "Lcom/intellij/diff/util/ThreeSide;", "modifiedSide", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getApplyActionText(@NotNull DiffViewerBase viewer, @NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
            String customValue;
            Key<String> key;
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)sourceSide, (String)"sourceSide");
            Intrinsics.checkNotNullParameter((Object)modifiedSide, (String)"modifiedSide");
            Object object = sourceSide == ThreeSide.BASE && modifiedSide == ThreeSide.LEFT ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_LEFT_ACTION_TEXT : (sourceSide == ThreeSide.BASE && modifiedSide == ThreeSide.RIGHT ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_RIGHT_ACTION_TEXT : (sourceSide == ThreeSide.LEFT && modifiedSide == ThreeSide.BASE ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_TO_BASE_ACTION_TEXT : (key = sourceSide == ThreeSide.RIGHT && modifiedSide == ThreeSide.BASE ? DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_TO_BASE_ACTION_TEXT : null)));
            if (key != null && (customValue = DiffUtil.getUserData((UserDataHolder)viewer.getRequest(), (UserDataHolder)viewer.getContext(), key)) != null) {
                return customValue;
            }
            String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

