/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.DiffViewerHighlighters;
import com.intellij.diff.tools.simple.SimpleDiffViewerHighlighters;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleThreesideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    protected final SimpleThreesideTextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final Map<SimpleThreesideDiffChange, SimpleDiffViewerHighlighters> myHighlighters;
    @NotNull
    private final Map<SimpleThreesideDiffChange, SimpleDiffViewerHighlighters> myInvalidHighlighters;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myHighlighters = new HashMap<SimpleThreesideDiffChange, SimpleDiffViewerHighlighters>();
        this.myInvalidHighlighters = new HashMap<SimpleThreesideDiffChange, SimpleDiffViewerHighlighters>();
        DiffUserDataKeys.ThreeSideDiffColors colorsMode = (DiffUserDataKeys.ThreeSideDiffColors)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.THREESIDE_DIFF_COLORS_MODE);
        if (colorsMode == null) {
            colorsMode = DiffUserDataKeys.ThreeSideDiffColors.MERGE_CONFLICT;
        }
        this.myTextDiffProvider = new SimpleThreesideTextDiffProvider(this.getTextSettings(), colorsMode, this::rediff, (Disposable)this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add((AnAction)Separator.create((String)ActionsBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT, false));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT, false));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, false));
        group.add((AnAction)diffGroup);
        group.add((AnAction)Separator.getInstance());
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction(this));
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.LEFT, ThreeSide.BASE));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.RIGHT, ThreeSide.BASE));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.LEFT));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(5);
        }
        try {
            indicator.checkCanceled();
            List sequences = ContainerUtil.map(this.getContents(), content -> content.getDocument().getImmutableCharSequence());
            List<FineMergeLineFragment> lineFragments = this.myTextDiffProvider.compare((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), indicator);
            FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(lineFragments, this.getFoldingModelSettings());
            runnable = this.apply(lineFragments, foldingState);
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable2 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(7);
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = this.applyNotification(DiffNotifications.createError());
            if (runnable3 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(8);
            }
            return runnable3;
        }
        if (runnable == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NotNull
    protected Runnable apply(@NotNull List<? extends FineMergeLineFragment> fragments, @Nullable FoldingModelSupport.Data foldingState) {
        if (fragments == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(9);
        }
        Runnable runnable = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (FineMergeLineFragment fragment : fragments) {
                MergeConflictType conflictType = fragment.getConflictType();
                MergeInnerDifferences innerFragments = fragment.getInnerFragments();
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType);
                SimpleDiffViewerHighlighters highlighters = new SimpleDiffViewerHighlighters(change, innerFragments, this);
                this.myDiffChanges.add(change);
                this.myHighlighters.put(change, highlighters);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
        if (runnable == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(10);
        }
        return runnable;
    }

    @Override
    @RequiresEdt
    protected void destroyChangedBlocks() {
        ThreadingAssertions.assertEventDispatchThread();
        super.destroyChangedBlocks();
        this.myHighlighters.values().forEach(DiffViewerHighlighters::destroy);
        this.myHighlighters.clear();
        this.myInvalidHighlighters.values().forEach(DiffViewerHighlighters::destroy);
        this.myInvalidHighlighters.clear();
        this.myDiffChanges.clear();
    }

    @Override
    @RequiresEdt
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        HashSet<SimpleThreesideDiffChange> invalid = new HashSet<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            for (SimpleThreesideDiffChange change : invalid) {
                SimpleDiffViewerHighlighters removed = this.myHighlighters.remove(change);
                change.markInvalid();
                if (removed == null) continue;
                this.myInvalidHighlighters.put(change, removed);
                removed.destroyOperations();
            }
        }
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list = Collections.unmodifiableList(this.myDiffChanges);
        if (list == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(13);
        }
        return new MyDividerPaintable(side);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(14);
        }
        if (request == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(15);
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request);
    }

    protected boolean isEditable(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(16);
        }
        return DiffUtil.isEditable((Editor)this.getEditor(side));
    }

    @RequiresWriteLock
    public void replaceChange(@NotNull SimpleThreesideDiffChange change, @NotNull ThreeSide sourceSide, @NotNull ThreeSide outputSide) {
        if (change == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(17);
        }
        if (sourceSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(18);
        }
        if (outputSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(19);
        }
        ThreadingAssertions.assertWriteAccess();
        if (!change.isValid()) {
            return;
        }
        DiffUtil.applyModification((Document)this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), (Document)this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myDiffChanges.remove(change);
        change.markInvalid();
        SimpleDiffViewerHighlighters removed = this.myHighlighters.remove(change);
        if (removed != null) {
            this.myInvalidHighlighters.put(change, removed);
            removed.destroyOperations();
        }
        this.scheduleRediff();
    }

    @RequiresEdt
    public void reinstallHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        for (SimpleDiffViewerHighlighters highlighters : this.myHighlighters.values()) {
            highlighters.reinstallAll();
        }
    }

    static String getReplaceActionId(@NotNull ThreeSide master, @NotNull ThreeSide modifiedSide) {
        if (master == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(20);
        }
        if (modifiedSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(21);
        }
        if (master == ThreeSide.LEFT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyLeftSide";
        }
        if (master == ThreeSide.RIGHT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyRightSide";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputSide";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "master";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedSide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDividerPaintable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceActionId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 10, 12 -> new IllegalStateException(string);
        };
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction(SimpleThreesideDiffViewer this$0) {
            super(this$0.getContext(), this$0.getEditableEditors());
        }
    }

    private class ReplaceSelectedChangesAction
    extends SelectedChangesActionBase {
        @NotNull
        protected final ThreeSide mySourceSide;
        @NotNull
        protected final ThreeSide myModifiedSide;

        ReplaceSelectedChangesAction(@NotNull ThreeSide sourceSide, ThreeSide modifiedSide) {
            if (sourceSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            if (modifiedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            this.mySourceSide = sourceSide;
            this.myModifiedSide = modifiedSide;
            String keymapActionId = SimpleThreesideDiffViewer.getReplaceActionId(sourceSide, modifiedSide);
            if (keymapActionId != null) {
                this.copyShortcutFrom(ActionManager.getInstance().getAction(keymapActionId));
            }
        }

        @Override
        protected boolean isVisible(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(2);
            }
            if (side != this.myModifiedSide && side != this.mySourceSide) {
                return false;
            }
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.mySourceSide;
        }

        @Override
        protected boolean isEnabled(@NotNull ThreesideDiffChangeBase change) {
            Side side1;
            if (change == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(3);
            }
            if ((side1 = (Side)this.myModifiedSide.select((Object)Side.LEFT, null, (Object)Side.RIGHT)) != null && change.isChange(side1)) {
                return true;
            }
            Side side2 = (Side)this.mySourceSide.select((Object)Side.LEFT, null, (Object)Side.RIGHT);
            return side2 != null && change.isChange(side2);
        }

        protected boolean isBothEditable() {
            return SimpleThreesideDiffViewer.this.isEditable(this.mySourceSide) && SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide);
        }

        @Override
        @NotNull
        protected String getText(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(4);
            }
            String string = SimpleDiffViewerHighlighters.getApplyActionText(SimpleThreesideDiffViewer.this, this.mySourceSide, this.myModifiedSide);
            if (string == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(6);
            }
            Side arrowDirection = Side.fromLeft((this.mySourceSide == ThreeSide.LEFT || this.myModifiedSide == ThreeSide.RIGHT ? 1 : 0) != 0);
            return DiffUtil.getArrowIcon(arrowDirection);
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull ThreeSide side, @NotNull List<? extends SimpleThreesideDiffChange> changes) {
            if (e == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(7);
            }
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(8);
            }
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(9);
            }
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand((Document)SimpleThreesideDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> {
                for (SimpleThreesideDiffChange change : changes) {
                    SimpleThreesideDiffViewer.this.replaceChange(change, this.mySourceSide, this.myModifiedSide);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        MyDividerPaintable(Side side) {
            if (side == null) {
                MyDividerPaintable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                MyDividerPaintable.$$$reportNull$$$0(1);
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType())) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                return;
            }
            List<SimpleThreesideDiffChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull ThreeSide var1);

        protected abstract boolean isEnabled(@NotNull ThreesideDiffChangeBase var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull ThreeSide var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull ThreeSide var1);

        @RequiresWriteLock
        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull ThreeSide var2, @NotNull List<? extends SimpleThreesideDiffChange> var3);

        private boolean isSomeChangeSelected(@NotNull ThreeSide side) {
            if (side == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            if (SimpleThreesideDiffViewer.this.getChanges().isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleThreesideDiffViewer.this.getEditor(side);
            return DiffUtil.isSomeRangeSelected((Editor)editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(SimpleThreesideDiffViewer.this.getChanges(), change -> this.isChangeSelected((ThreesideDiffChangeBase)change, (BitSet)lines, side))));
        }

        @RequiresEdt
        @NotNull
        private List<SimpleThreesideDiffChange> getSelectedChanges(@NotNull ThreeSide side) {
            if (side == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            ThreadingAssertions.assertEventDispatchThread();
            EditorEx editor = SimpleThreesideDiffViewer.this.getEditor(side);
            BitSet lines = DiffUtil.getSelectedLines((Editor)editor);
            List list = ContainerUtil.filter(SimpleThreesideDiffViewer.this.getChanges(), change -> this.isChangeSelected((ThreesideDiffChangeBase)change, lines, side));
            if (list == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(5);
            }
            return list;
        }

        private boolean isChangeSelected(@NotNull ThreesideDiffChangeBase change, @NotNull BitSet lines, @NotNull ThreeSide side) {
            if (change == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(6);
            }
            if (lines == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(7);
            }
            if (side == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(8);
            }
            if (!this.isEnabled(change)) {
                return false;
            }
            int line1 = change.getStartLine(side);
            int line2 = change.getEndLine(side);
            return DiffUtil.isSelectedByLine(lines, line1, line2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$SelectedChangesActionBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$SelectedChangesActionBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSomeChangeSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedChanges";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isChangeSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }
}

