/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSyncScrollable
implements SyncScrollSupport.SyncScrollable {
    private static final Logger LOG = Logger.getInstance(BaseSyncScrollable.class);

    protected abstract void processHelper(@NotNull ScrollHelper var1);

    @Override
    public int transfer(@NotNull Side baseSide, int line) {
        if (baseSide == null) {
            BaseSyncScrollable.$$$reportNull$$$0(0);
        }
        Range range = this.getRange(baseSide, line);
        return BaseSyncScrollable.transferLine(line, range);
    }

    @Override
    @NotNull
    public Range getRange(@NotNull Side baseSide, int line) {
        if (baseSide == null) {
            BaseSyncScrollable.$$$reportNull$$$0(1);
        }
        if (line < 0) {
            LOG.error("Invalid line number: " + line);
            return BaseSyncScrollable.idRange(line);
        }
        ScrollHelper helper = new ScrollHelper(baseSide, line);
        this.processHelper(helper);
        int master1 = helper.getMaster1();
        int master2 = helper.getMaster2();
        int slave1 = helper.getSlave1();
        int slave2 = helper.getSlave2();
        return new Range(master1, master2, slave1, slave2);
    }

    public static int transferLine(int line, @NotNull Range range) {
        if (range == null) {
            BaseSyncScrollable.$$$reportNull$$$0(2);
        }
        if (range.start1 == line) {
            return range.start2;
        }
        if (range.end1 == line) {
            return range.end2;
        }
        if (range.end1 < line) {
            return line - range.end1 + range.end2;
        }
        return Math.min(range.start2 + (line - range.start1), range.end2);
    }

    @NotNull
    public static Range idRange(int line) {
        return new Range(line, line + 1, line, line + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSide";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/BaseSyncScrollable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "transfer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "transferLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ScrollHelper {
        @NotNull
        private final Side mySide;
        private final int myLine;
        private int myLeft1;
        private int myLeft2;
        private int myRight1;
        private int myRight2;

        public ScrollHelper(@NotNull Side side, int line) {
            if (side == null) {
                ScrollHelper.$$$reportNull$$$0(0);
            }
            this.myLeft1 = 0;
            this.myLeft2 = 0;
            this.myRight1 = 0;
            this.myRight2 = 0;
            this.mySide = side;
            this.myLine = line;
        }

        public boolean process(int left, int right) {
            this.myLeft1 = this.myLeft2;
            this.myRight1 = this.myRight2;
            this.myLeft2 = left;
            this.myRight2 = right;
            return this.myLine > this.mySide.select(left, right);
        }

        public int getMaster1() {
            return this.mySide.select(this.myLeft1, this.myRight1);
        }

        public int getMaster2() {
            return this.mySide.select(this.myLeft2, this.myRight2);
        }

        public int getSlave1() {
            return this.mySide.select(this.myRight1, this.myLeft1);
        }

        public int getSlave2() {
            return this.mySide.select(this.myRight2, this.myLeft2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/BaseSyncScrollable$ScrollHelper", "<init>"));
        }
    }
}

