/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ListenerDiffViewerBase
extends DiffViewerBase {
    public ListenerDiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(1);
        }
        super(context, request);
    }

    @Override
    protected void onInit() {
        super.onInit();
        List<VirtualFile> files = ListenerDiffViewerBase.extractVirtualFiles(this.myRequest);
        if (!files.isEmpty()) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyBulkFileListener(files));
        }
        List documents = ContainerUtil.mapNotNull((Collection)this.myRequest.getContents(), content -> content instanceof DocumentContent ? ((DocumentContent)content).getDocument() : null);
        TextDiffViewerUtil.installDocumentListeners(new MyDocumentListener(), documents, (Disposable)this);
    }

    @NotNull
    private static List<VirtualFile> extractVirtualFiles(@NotNull ContentDiffRequest request) {
        if (request == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(0);
        for (DiffContent content : request.getContents()) {
            if (content instanceof DocumentContent || !(content instanceof FileContent)) continue;
            files.add(((FileContent)content).getFile());
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @RequiresEdt
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.scheduleRediff();
    }

    @RequiresEdt
    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void onFileChange(@NotNull VirtualFile file) {
        if (file == null) {
            ListenerDiffViewerBase.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.scheduleRediff();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractVirtualFiles";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onFileChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class MyBulkFileListener
    implements BulkFileListener {
        private final List<VirtualFile> myFiles;

        MyBulkFileListener(List<VirtualFile> files) {
            if (files == null) {
                MyBulkFileListener.$$$reportNull$$$0(0);
            }
            this.myFiles = files;
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyBulkFileListener.$$$reportNull$$$0(1);
            }
            HashSet<VirtualFile> toRefresh = new HashSet<VirtualFile>();
            for (VFileEvent vFileEvent : events) {
                VirtualFile file;
                if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent) || !this.myFiles.contains(file = Objects.requireNonNull(vFileEvent.getFile()))) continue;
                toRefresh.add(file);
            }
            for (VirtualFile virtualFile : toRefresh) {
                ListenerDiffViewerBase.this.onFileChange(virtualFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$MyBulkFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            ListenerDiffViewerBase.this.onBeforeDocumentChange(event);
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            ListenerDiffViewerBase.this.onDocumentChange(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/diff/tools/util/base/ListenerDiffViewerBase$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

